/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.mixin;

import de.larsensmods.stl_backport.entity.ColdPig;
import de.larsensmods.stl_backport.entity.STLEntityTypes;
import de.larsensmods.stl_backport.entity.WarmPig;
import de.larsensmods.stl_backport.mixin.AnimalMixin;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Pig.class})
public abstract class PigMixin
extends AnimalMixin {
    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    protected void registerGoals(CallbackInfo ci) {
        Pig p = (Pig)this;
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)p, 1.0, ColdPig.class));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)p, 1.0, WarmPig.class));
    }

    @Override
    public void canMate(Animal otherAnimal, CallbackInfoReturnable<Boolean> cir) {
        Pig p = (Pig)this;
        if (otherAnimal == p) {
            cir.setReturnValue((Object)false);
        }
        cir.setReturnValue((Object)(otherAnimal instanceof Pig && p.m_27593_() && otherAnimal.m_27593_() ? 1 : 0));
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Pig;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getBreedOffspring(ServerLevel level, AgeableMob otherParent, CallbackInfoReturnable<Pig> cir) {
        Pig otherPig;
        if (!(otherParent instanceof Pig)) {
            cir.setReturnValue(null);
        }
        if ((otherPig = (Pig)otherParent) instanceof WarmPig) {
            cir.setReturnValue((Object)(Math.random() < 0.5 ? (Pig)STLEntityTypes.WARM_PIG.get().m_20615_((Level)level) : (Pig)EntityType.f_20510_.m_20615_((Level)level)));
        } else if (otherPig instanceof ColdPig) {
            cir.setReturnValue((Object)(Math.random() < 0.5 ? (Pig)STLEntityTypes.COLD_PIG.get().m_20615_((Level)level) : (Pig)EntityType.f_20510_.m_20615_((Level)level)));
        } else {
            cir.setReturnValue((Object)((Pig)EntityType.f_20510_.m_20615_((Level)level)));
        }
    }
}

