/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ColorParticleOption
implements ParticleOptions {
    private final ParticleType<ColorParticleOption> type;
    private final Vector3f color;

    public ColorParticleOption(ParticleType<ColorParticleOption> type, Vector3f color) {
        this.type = type;
        this.color = color;
    }

    public float getRed() {
        return this.color.x;
    }

    public float getGreen() {
        return this.color.y;
    }

    public float getBlue() {
        return this.color.z;
    }

    @NotNull
    public ParticleType<ColorParticleOption> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.color.x);
        buffer.writeFloat(this.color.y);
        buffer.writeFloat(this.color.z);
    }

    @NotNull
    public String m_5942_() {
        return String.format("ColorParticleOption{type=%s, color=%s}", this.type, this.color);
    }

    public static ColorParticleOption create(ParticleType<ColorParticleOption> type, int color) {
        return new ColorParticleOption(type, new Vector3f((float)FastColor.ARGB32.m_13665_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f));
    }

    public static ColorParticleOption create(ParticleType<ColorParticleOption> type, float red, float green, float blue) {
        return new ColorParticleOption(type, new Vector3f(red, green, blue));
    }

    public static Codec<ColorParticleOption> codec(ParticleType<ColorParticleOption> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252432_.fieldOf("color").forGetter(dustParticleOptions -> dustParticleOptions.color)).apply((Applicative)instance, vector3f -> new ColorParticleOption(type, (Vector3f)vector3f)));
    }

    public static ParticleOptions.Deserializer<ColorParticleOption> deserializer() {
        return new ParticleOptions.Deserializer<ColorParticleOption>(){

            @NotNull
            public ColorParticleOption fromCommand(ParticleType<ColorParticleOption> particleType, StringReader reader) throws CommandSyntaxException {
                Vector3f vector3f = this.readVector3f(reader);
                return new ColorParticleOption(particleType, vector3f);
            }

            @NotNull
            public ColorParticleOption fromNetwork(ParticleType<ColorParticleOption> particleType, FriendlyByteBuf buffer) {
                return new ColorParticleOption(particleType, this.readVector3f(buffer));
            }

            private Vector3f readVector3f(StringReader reader) throws CommandSyntaxException {
                float x = reader.readFloat();
                reader.expect(' ');
                float y = reader.readFloat();
                reader.expect(' ');
                float z = reader.readFloat();
                return new Vector3f(x, y, z);
            }

            private Vector3f readVector3f(FriendlyByteBuf buffer) {
                float x = buffer.readFloat();
                float y = buffer.readFloat();
                float z = buffer.readFloat();
                return new Vector3f(x, y, z);
            }
        };
    }
}

