/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.particles.client;

import de.larsensmods.stl_backport.particles.ColorParticleOption;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import org.jetbrains.annotations.NotNull;

public class FallingLeavesParticle
extends TextureSheetParticle {
    private final float spinAcceleration;
    private final float windBig;
    private final boolean swirl;
    private final boolean flowAway;
    private final double xaFlowScale;
    private final double zaFlowScale;
    private final double swirlPeriod;
    private float rotSpeed;

    protected FallingLeavesParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, float gravity, float windBig, boolean swirl, boolean flowAway, float size, float yd) {
        super(level, x, y, z);
        float calculatedSize;
        this.m_108337_(sprites.m_5819_(this.f_107223_.m_188503_(12), 12));
        this.rotSpeed = (float)Math.toRadians(this.f_107223_.m_188499_() ? -30.0 : 30.0);
        float particleRandom = this.f_107223_.m_188501_();
        this.spinAcceleration = (float)Math.toRadians(this.f_107223_.m_188499_() ? -5.0 : 5.0);
        this.windBig = windBig;
        this.swirl = swirl;
        this.flowAway = flowAway;
        this.f_107225_ = 300;
        this.f_107226_ = gravity * 1.2f * 0.0025f;
        this.f_107663_ = calculatedSize = size * (this.f_107223_.m_188499_() ? 0.05f : 0.075f);
        this.m_107250_(calculatedSize, calculatedSize);
        this.f_172258_ = 1.0f;
        this.f_107216_ = -yd;
        this.xaFlowScale = Math.cos(Math.toRadians(particleRandom * 60.0f)) * (double)this.windBig;
        this.zaFlowScale = Math.sin(Math.toRadians(particleRandom * 60.0f)) * (double)this.windBig;
        this.swirlPeriod = Math.toRadians(1000.0f + particleRandom * 3000.0f);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
        if (!this.f_107220_) {
            float baseLifetime = 300 - this.f_107225_;
            float movementModifier = Math.min(baseLifetime / 300.0f, 1.0f);
            double xMovement = 0.0;
            double zMovement = 0.0;
            if (this.flowAway) {
                xMovement += this.xaFlowScale * Math.pow(movementModifier, 1.25);
                zMovement += this.zaFlowScale * Math.pow(movementModifier, 1.25);
            }
            if (this.swirl) {
                xMovement += (double)movementModifier * Math.cos((double)movementModifier * this.swirlPeriod) * (double)this.windBig;
                zMovement += (double)movementModifier * Math.sin((double)movementModifier * this.swirlPeriod) * (double)this.windBig;
            }
            this.f_107215_ += xMovement * (double)0.0025f;
            this.f_107217_ += zMovement * (double)0.0025f;
            this.f_107216_ -= (double)this.f_107226_;
            this.rotSpeed += this.spinAcceleration / 20.0f;
            this.f_107204_ = this.f_107231_;
            this.f_107231_ += this.rotSpeed / 20.0f;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if (this.f_107218_ || this.f_107225_ < 299 && (this.f_107215_ == 0.0 || this.f_107217_ == 0.0)) {
                this.m_107274_();
            }
            if (!this.f_107220_) {
                this.f_107215_ *= (double)this.f_172258_;
                this.f_107216_ *= (double)this.f_172258_;
                this.f_107217_ *= (double)this.f_172258_;
            }
        }
    }

    public static class TintedLeavesProvider
    implements ParticleProvider<ColorParticleOption> {
        private final SpriteSet sprites;

        public TintedLeavesProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(ColorParticleOption option, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingLeavesParticle particle = new FallingLeavesParticle(level, x, y, z, this.sprites, 0.07f, 10.0f, true, false, 2.0f, 0.021f);
            particle.m_107253_(option.getRed(), option.getGreen(), option.getBlue());
            return particle;
        }
    }
}

