/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.util;

import de.larsensmods.stl_backport.util.ColorUtils;
import de.larsensmods.stl_backport.util.DryFoliageColor;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientColorUtils
implements ColorUtils {
    private static final int AZALEA_LEAVES_COLOR = 7377453;
    public static final ColorResolver DRY_FOLIAGE_COLOR_RESOLVER = new ColorResolver(){

        public int m_130045_(Biome biome, double d, double e) {
            return ClientColorUtils.getDryFoliageColorOverride(biome).orElseGet(() -> ClientColorUtils.getDryFoliageColorFromTexture(biome));
        }
    };

    @Override
    public int getAverageDryFoliageColor(BlockAndTintGetter blockAndTintGetter, BlockPos pos) {
        return blockAndTintGetter.m_6171_(pos, DRY_FOLIAGE_COLOR_RESOLVER);
    }

    @Override
    public int getBlockColor(BlockState state, Level level, BlockPos pos, int tintIndex) {
        if (state.m_60713_(Blocks.f_152470_) || state.m_60713_(Blocks.f_152471_)) {
            return 7377453;
        }
        return Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, tintIndex);
    }

    private static Optional<Integer> getDryFoliageColorOverride(Biome biome) {
        return Optional.empty();
    }

    private static int getDryFoliageColorFromTexture(Biome biome) {
        double temp = Mth.m_14036_((float)biome.m_47554_(), (float)0.0f, (float)1.0f);
        double downfall = Mth.m_14036_((float)ClientColorUtils.getDownfall(biome), (float)0.0f, (float)1.0f);
        return DryFoliageColor.get(temp, downfall);
    }

    private static float getDownfall(Biome biome) {
        return 0.5f;
    }
}

