/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.worldgen;

import com.mojang.serialization.Codec;
import de.larsensmods.stl_backport.worldgen.FallenTreeFeatureConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public class FallenTreeFeature
extends Feature<FallenTreeFeatureConfig> {
    public FallenTreeFeature(Codec<FallenTreeFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<FallenTreeFeatureConfig> placeContext) {
        this.placeFallenTree((FallenTreeFeatureConfig)placeContext.m_159778_(), placeContext.m_159777_(), placeContext.m_159774_(), placeContext.m_225041_());
        return true;
    }

    private void placeFallenTree(FallenTreeFeatureConfig config, BlockPos pos, WorldGenLevel level, RandomSource randomSource) {
        this.placeStump(config, level, randomSource, pos.m_122032_());
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(randomSource);
        int length = config.logLength.m_214085_(randomSource) - 2;
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_5484_(direction, 2 + randomSource.m_188503_(2)).m_122032_();
        this.setGroundHeightForFallenLogStartPos(level, mutableBlockPos);
        if (this.canPlaceEntireFallenLog(level, length, mutableBlockPos, direction)) {
            this.placeFallenLog(config, level, randomSource, length, mutableBlockPos, direction);
        }
    }

    private void setGroundHeightForFallenLogStartPos(WorldGenLevel level, BlockPos.MutableBlockPos mutableBlockPos) {
        mutableBlockPos.m_122175_(Direction.UP, 1);
        for (int i = 0; i < 6; ++i) {
            if (this.mayPlaceOn((LevelAccessor)level, (BlockPos)mutableBlockPos)) {
                return;
            }
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
    }

    private void placeStump(FallenTreeFeatureConfig config, WorldGenLevel level, RandomSource randomSource, BlockPos.MutableBlockPos mutableBlockPos) {
        BlockPos blockPos = this.placeLogBlock(config, level, randomSource, mutableBlockPos, Function.identity());
        this.decorateLogs(level, randomSource, Set.of(blockPos), config.stumpDecorators);
    }

    private boolean canPlaceEntireFallenLog(WorldGenLevel level, int length, BlockPos.MutableBlockPos mutableBlockPos, Direction direction) {
        int suspendedLogs = 0;
        for (int i = 0; i < length; ++i) {
            if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)mutableBlockPos)) {
                return false;
            }
            if (!this.isOverSolidGround((LevelAccessor)level, (BlockPos)mutableBlockPos)) {
                if (++suspendedLogs > 2) {
                    return false;
                }
            } else {
                suspendedLogs = 0;
            }
            mutableBlockPos.m_122173_(direction);
        }
        mutableBlockPos.m_122175_(direction.m_122424_(), length);
        return true;
    }

    private void placeFallenLog(FallenTreeFeatureConfig config, WorldGenLevel level, RandomSource randomSource, int length, BlockPos.MutableBlockPos mutableBlockPos, Direction direction) {
        HashSet<BlockPos> fallenLogPositions = new HashSet<BlockPos>();
        for (int i = 0; i < length; ++i) {
            fallenLogPositions.add(this.placeLogBlock(config, level, randomSource, mutableBlockPos, FallenTreeFeature.getSidewaysStateModifier(direction)));
            mutableBlockPos.m_122173_(direction);
        }
        this.decorateLogs(level, randomSource, fallenLogPositions, config.logDecorators);
    }

    private boolean mayPlaceOn(LevelAccessor level, BlockPos pos) {
        return TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos) && this.isOverSolidGround(level, pos);
    }

    private boolean isOverSolidGround(LevelAccessor level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos, Direction.UP);
    }

    private BlockPos placeLogBlock(FallenTreeFeatureConfig config, WorldGenLevel level, RandomSource randomSource, BlockPos.MutableBlockPos mutableBlockPos, Function<BlockState, BlockState> blockStateModifier) {
        level.m_7731_((BlockPos)mutableBlockPos, blockStateModifier.apply(config.trunkProvider.m_213972_(randomSource, (BlockPos)mutableBlockPos)), 3);
        BlockPos below = mutableBlockPos.m_7495_();
        if (level.m_8055_(below).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(below, Blocks.f_50493_.m_49966_(), 3);
        }
        this.m_159739_(level, (BlockPos)mutableBlockPos);
        return mutableBlockPos.m_7949_();
    }

    private void decorateLogs(WorldGenLevel level, RandomSource randomSource, Set<BlockPos> logPositions, List<TreeDecorator> treeDecorators) {
        if (!treeDecorators.isEmpty()) {
            TreeDecorator.Context decoratorContext = new TreeDecorator.Context((LevelSimulatedReader)level, this.getDecorationSetter(level), randomSource, logPositions, Set.of(), Set.of());
            treeDecorators.forEach(decorator -> decorator.m_214187_(decoratorContext));
        }
    }

    private BiConsumer<BlockPos, BlockState> getDecorationSetter(WorldGenLevel level) {
        return (pos, state) -> level.m_7731_(pos, state, 19);
    }

    private static Function<BlockState, BlockState> getSidewaysStateModifier(Direction direction) {
        return original -> (BlockState)original.m_263224_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
    }
}

