/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.worldgen.decorators;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.larsensmods.stl_backport.worldgen.decorators.STLDecoratorTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;

public class PlaceOnGroundDecorator
extends TreeDecorator {
    public static final Codec<PlaceOnGroundDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144629_.fieldOf("tries").orElse((Object)128).forGetter(decorator -> decorator.tries), (App)ExtraCodecs.f_144628_.fieldOf("radius").orElse((Object)2).forGetter(decorator -> decorator.radius), (App)ExtraCodecs.f_144628_.fieldOf("height").orElse((Object)1).forGetter(decorator -> decorator.height), (App)BlockStateProvider.f_68747_.fieldOf("block_state_provider").forGetter(decorator -> decorator.blockStateProvider)).apply((Applicative)instance, PlaceOnGroundDecorator::new));
    private final int tries;
    private final int radius;
    private final int height;
    private final BlockStateProvider blockStateProvider;

    public PlaceOnGroundDecorator(int tries, int radius, int height, BlockStateProvider blockStateProvider) {
        this.tries = tries;
        this.radius = radius;
        this.height = height;
        this.blockStateProvider = blockStateProvider;
    }

    public void m_214187_(TreeDecorator.Context decoratorContext) {
        List<BlockPos> possiblePositions = this.getLowestTrunkOrRootOfTree(decoratorContext);
        if (!possiblePositions.isEmpty()) {
            BlockPos firstPos = possiblePositions.get(0);
            int firstPosY = firstPos.m_123342_();
            int firstPosX = firstPos.m_123341_();
            int firstPosX1 = firstPos.m_123341_();
            int firstPosZ = firstPos.m_123343_();
            int firstPosZ1 = firstPos.m_123343_();
            for (BlockPos pos : possiblePositions) {
                if (pos.m_123342_() != firstPosY) continue;
                firstPosX = Math.min(firstPosX, pos.m_123341_());
                firstPosX1 = Math.max(firstPosX1, pos.m_123341_());
                firstPosZ = Math.min(firstPosZ, pos.m_123343_());
                firstPosZ1 = Math.max(firstPosZ1, pos.m_123343_());
            }
            RandomSource random = decoratorContext.m_226067_();
            BoundingBox boundingBox = new BoundingBox(firstPosX, firstPosY, firstPosZ, firstPosX1, firstPosY, firstPosZ1).m_191961_(Math.max(this.height, this.radius));
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int i = 0; i < this.tries; ++i) {
                mutableBlockPos.m_122178_(random.m_216332_(boundingBox.m_162395_(), boundingBox.m_162399_()), random.m_216332_(boundingBox.m_162396_(), boundingBox.m_162400_()), random.m_216332_(boundingBox.m_162398_(), boundingBox.m_162401_()));
                this.attemptToPlaceBlockAbove(decoratorContext, (BlockPos)mutableBlockPos);
            }
        }
    }

    private void attemptToPlaceBlockAbove(TreeDecorator.Context decoratorContext, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        if (decoratorContext.m_226058_().m_7433_(abovePos, state -> state.m_60795_() || state.m_60713_(Blocks.f_50191_)) && decoratorContext.m_226058_().m_7433_(pos, BlockBehaviour.BlockStateBase::m_280296_) && decoratorContext.m_226058_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos).m_123342_() <= abovePos.m_123342_()) {
            decoratorContext.m_226061_(abovePos, this.blockStateProvider.m_213972_(decoratorContext.m_226067_(), abovePos));
        }
    }

    public List<BlockPos> getLowestTrunkOrRootOfTree(TreeDecorator.Context decoratorContext) {
        ArrayList lowestTrunk = Lists.newArrayList();
        ObjectArrayList roots = decoratorContext.m_226070_();
        ObjectArrayList logs = decoratorContext.m_226068_();
        if (roots.isEmpty()) {
            lowestTrunk.addAll(logs);
        } else if (!logs.isEmpty() && ((BlockPos)roots.get(0)).m_123342_() == ((BlockPos)logs.get(0)).m_123342_()) {
            lowestTrunk.addAll(logs);
            lowestTrunk.addAll(roots);
        } else {
            lowestTrunk.addAll(roots);
        }
        return lowestTrunk;
    }

    @NotNull
    protected TreeDecoratorType<?> m_6663_() {
        return STLDecoratorTypes.PLACE_ON_GROUND.get();
    }
}

