/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.smoothscrollingeverywhere;

import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.gui.entries.LongSliderEntry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.clothconfig2.impl.EasingMethods;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class SmoothScrollingEverywhere
implements ClientModInitializer {
    private static EasingMethod easingMethod = EasingMethod.EasingMethodImpl.LINEAR;
    private static long scrollDuration = 600L;
    private static double scrollStep = 19.0;
    private static double bounceBackMultiplier = 0.24;

    public static EasingMethod getEasingMethod() {
        return easingMethod;
    }

    public static long getScrollDuration() {
        return scrollDuration;
    }

    public static double getScrollStep() {
        return scrollStep;
    }

    public static double getBounceBackMultiplier() {
        return bounceBackMultiplier;
    }

    public void onInitializeClient() {
        SmoothScrollingEverywhere.loadConfig();
    }

    private static void loadConfig() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("config.properties");
        try {
            easingMethod = EasingMethod.EasingMethodImpl.LINEAR;
            scrollDuration = 600L;
            scrollStep = 19.0;
            bounceBackMultiplier = 0.24;
            if (!Files.exists(path, new LinkOption[0])) {
                SmoothScrollingEverywhere.saveConfig();
            }
            Properties properties = new Properties();
            properties.load(Files.newInputStream(path, new OpenOption[0]));
            String easing = properties.getProperty("easingMethod", "LINEAR");
            for (EasingMethod value : EasingMethods.getMethods()) {
                if (!value.toString().equalsIgnoreCase(easing)) continue;
                easingMethod = value;
                break;
            }
            scrollDuration = Long.parseLong(properties.getProperty("scrollDuration", "600"));
            scrollStep = Double.parseDouble(properties.getProperty("scrollStep", "19"));
            bounceBackMultiplier = Double.parseDouble(properties.getProperty("bounceBackMultiplier", "0.24"));
        }
        catch (Exception e) {
            e.printStackTrace();
            easingMethod = EasingMethod.EasingMethodImpl.LINEAR;
            scrollDuration = 600L;
            scrollStep = 19.0;
            bounceBackMultiplier = 0.24;
            try {
                Files.deleteIfExists(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SmoothScrollingEverywhere.saveConfig();
    }

    private static void saveConfig() {
        Path file = FabricLoader.getInstance().getConfigDir().resolve("config.properties");
        try {
            Properties properties = new Properties();
            properties.setProperty("easingMethod", easingMethod.toString());
            properties.setProperty("scrollDuration", "" + scrollDuration);
            properties.setProperty("scrollStep", "" + scrollStep);
            properties.setProperty("bounceBackMultiplier", "" + bounceBackMultiplier);
            properties.store(Files.newOutputStream(file, new OpenOption[0]), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            easingMethod = EasingMethod.EasingMethodImpl.LINEAR;
            scrollDuration = 600L;
            scrollStep = 19.0;
            bounceBackMultiplier = 0.24;
        }
    }

    public static ConfigBuilder getConfigBuilder() {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(class_310.method_1551().field_1755).setTitle((class_2561)class_2561.method_43471((String)"title.smoothscrollingeverywhere.config"));
        builder.setDefaultBackgroundTexture(new class_2960("minecraft:textures/block/oak_planks.png"));
        ConfigCategory scrolling = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"dajikdawjdi9whdna"));
        ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
        final DropdownBoxEntry easingMethodEntry = entryBuilder.startDropdownMenu((class_2561)class_2561.method_43471((String)"option.smoothscrollingeverywhere.easingMethod"), DropdownMenuBuilder.TopCellElementBuilder.of((Object)easingMethod, str -> {
            for (EasingMethod m : EasingMethods.getMethods()) {
                if (!m.toString().equals(str)) continue;
                return m;
            }
            return null;
        })).setDefaultValue((Object)EasingMethod.EasingMethodImpl.LINEAR).setSaveConsumer(o -> {
            easingMethod = o;
        }).setSelections((Iterable)EasingMethods.getMethods()).build();
        final LongSliderEntry scrollDurationEntry = entryBuilder.startLongSlider((class_2561)class_2561.method_43471((String)"option.smoothscrollingeverywhere.scrollDuration"), scrollDuration, 0L, 5000L).setTextGetter(integer -> class_2561.method_43470((String)(integer <= 0L ? "Value: Disabled" : (integer > 1500L ? String.format("Value: %.1fs", Float.valueOf((float)integer.longValue() / 1000.0f)) : "Value: " + integer + "ms")))).setDefaultValue(600L).setSaveConsumer(i -> {
            scrollDuration = i;
        }).build();
        final DoubleListEntry scrollStepEntry = entryBuilder.startDoubleField((class_2561)class_2561.method_43471((String)"option.smoothscrollingeverywhere.scrollStep"), scrollStep).setDefaultValue(19.0).setSaveConsumer(i -> {
            scrollStep = i;
        }).build();
        final LongSliderEntry bounceMultiplierEntry = entryBuilder.startLongSlider((class_2561)class_2561.method_43471((String)"option.smoothscrollingeverywhere.bounceBackMultiplier"), (long)(bounceBackMultiplier * 1000.0), -10L, 750L).setTextGetter(integer -> class_2561.method_43470((String)(integer < 0L ? "Value: Disabled" : String.format("Value: %s", (double)integer.longValue() / 1000.0)))).setDefaultValue(240L).setSaveConsumer(i -> {
            bounceBackMultiplier = (double)i.longValue() / 1000.0;
        }).build();
        scrolling.addEntry((AbstractConfigListEntry)new TooltipListEntry<Object>((class_2561)class_2561.method_43471((String)"option.smoothscrollingeverywhere.setDefaultSmoothScroll"), null){
            final int width = 220;
            private final class_339 buttonWidget;
            private final List<class_339> children;
            {
                super(fieldName, tooltipSupplier);
                this.width = 220;
                this.buttonWidget = new class_4264(0, 0, 0, 20, this.getFieldName()){

                    public void method_25306() {
                        easingMethodEntry.getSelectionElement().getTopRenderer().setValue((Object)EasingMethod.EasingMethodImpl.LINEAR);
                        scrollDurationEntry.setValue(600L);
                        scrollStepEntry.setValue("19.0");
                        bounceMultiplierEntry.setValue(240L);
                    }

                    public void method_37020(class_6382 builder) {
                    }
                };
                this.children = ImmutableList.of((Object)this.buttonWidget);
            }

            public Object getValue() {
                return null;
            }

            public Optional<Object> getDefaultValue() {
                return Optional.empty();
            }

            public void save() {
            }

            public List<? extends class_364> method_25396() {
                return this.children;
            }

            public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
                super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
                class_1041 window = class_310.method_1551().method_22683();
                this.buttonWidget.field_22763 = this.isEditable();
                this.buttonWidget.field_22761 = y;
                this.buttonWidget.field_22760 = x + entryWidth / 2 - 110;
                this.buttonWidget.method_25358(220);
                this.buttonWidget.method_25394(matrices, mouseX, mouseY, delta);
            }

            public List<? extends class_6379> narratables() {
                return null;
            }
        });
        scrolling.addEntry((AbstractConfigListEntry)new TooltipListEntry<Object>((class_2561)class_2561.method_43471((String)"option.smoothscrollingeverywhere.disableSmoothScroll"), null){
            final int width = 220;
            private final class_339 buttonWidget;
            private final List<class_339> children;
            {
                super(fieldName, tooltipSupplier);
                this.width = 220;
                this.buttonWidget = new class_4264(0, 0, 0, 20, this.getFieldName()){

                    public void method_25306() {
                        easingMethodEntry.getSelectionElement().getTopRenderer().setValue((Object)EasingMethod.EasingMethodImpl.NONE);
                        scrollDurationEntry.setValue(0L);
                        scrollStepEntry.setValue("16.0");
                        bounceMultiplierEntry.setValue(-10L);
                    }

                    public void method_37020(class_6382 builder) {
                    }
                };
                this.children = ImmutableList.of((Object)this.buttonWidget);
            }

            public Object getValue() {
                return null;
            }

            public Optional<Object> getDefaultValue() {
                return Optional.empty();
            }

            public void save() {
            }

            public List<? extends class_364> method_25396() {
                return this.children;
            }

            public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
                super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
                class_1041 window = class_310.method_1551().method_22683();
                this.buttonWidget.field_22763 = this.isEditable();
                this.buttonWidget.field_22761 = y;
                this.buttonWidget.field_22760 = x + entryWidth / 2 - 110;
                this.buttonWidget.method_25358(220);
                this.buttonWidget.method_25394(matrices, mouseX, mouseY, delta);
            }

            public List<? extends class_6379> narratables() {
                return null;
            }
        });
        scrolling.addEntry((AbstractConfigListEntry)easingMethodEntry);
        scrolling.addEntry((AbstractConfigListEntry)scrollDurationEntry);
        scrolling.addEntry((AbstractConfigListEntry)scrollStepEntry);
        scrolling.addEntry((AbstractConfigListEntry)bounceMultiplierEntry);
        builder.setSavingRunnable(SmoothScrollingEverywhere::saveConfig);
        builder.transparentBackground();
        return builder;
    }
}

