#version 150

#moj_import <minecraft:fog.glsl>

uniform sampler2D Sampler0;
uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;

out vec4 fragColor;

// Enhanced saturation boost
vec3 boostSaturation(vec3 color, float factor) {
    float gray = (color.r + color.g + color.b) / 3.0;
    return clamp(gray + (color - vec3(gray)) * factor, 0.0, 1.0);
}

void main() {
    vec4 color = texture(Sampler0, texCoord0);

    // Handle transparency
#ifdef ALPHA_CUTOUT
    if (color.a < ALPHA_CUTOUT) {
        discard;
    }
#endif

    color *= vertexColor * ColorModulator;

    // Color overlay for damage
#ifndef NO_OVERLAY
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
#endif

    // Apply lighting
#ifndef EMISSIVE
    color *= lightMapColor;
#endif

    // Brightness enhancement
    color.rgb *= 1.3;

    // Enhanced saturation
    color.rgb = boostSaturation(color.rgb, 1.2);

    // Slight warm tint
    color.rgb *= vec3(1.05, 1.0, 0.95);

    color.rgb = clamp(color.rgb, 0.0, 1.0);

    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}