#version 150

uniform float AmbientLightFactor;
uniform float SkyFactor;
uniform float BlockFactor;
uniform int UseBrightLightmap;
uniform vec3 SkyLightColor;
uniform float NightVisionFactor;
uniform float DarknessScale;
uniform float DarkenWorldFactor;
uniform float BrightnessFactor;

in vec2 texCoord;

out vec4 fragColor;

float getBrightness(float lightLevel) {
    float shapedLevel = lightLevel / (4.0 - 3.0 * lightLevel);
    return mix(shapedLevel, 1.0, AmbientLightFactor);
}

void nightVisionBoost(inout vec3 color) {
    // Night vision enhancement
    color += vec3(0.3, 0.4, 0.3);
    color = clamp(color, 0.0, 1.0);
}

void main() {
    float blockBrightness = getBrightness(texCoord.x) * BlockFactor;
    float skyBrightness = getBrightness(texCoord.y) * SkyFactor;
    
    vec3 color = vec3(
        blockBrightness,
        blockBrightness * 0.9 + 0.1,
        blockBrightness * 0.8 + 0.1
    );
    
    if (UseBrightLightmap != 0) {
        color = mix(color, vec3(0.9, 1.0, 0.8), 0.3);
    } else {
        color += SkyLightColor * skyBrightness * 0.5;
        color = mix(color, color * 0.95, 0.1);
        
        if (DarkenWorldFactor > 0.0) {
            vec3 darkColor = color * vec3(0.8, 0.7, 0.7);
            color = mix(color, darkColor, DarkenWorldFactor);
        }
    }
    
    // Always apply night vision
    nightVisionBoost(color);
    
    if (UseBrightLightmap == 0) {
        color = clamp(color - vec3(DarknessScale * 0.5), 0.0, 1.0);
    }
    
    // Enhanced brightness multiplier
    float brightnessMultiplier = 1.0 + (BrightnessFactor * 8.0);
    color *= brightnessMultiplier;
    
    color = clamp(color, 0.0, 1.0);
    fragColor = vec4(color, 1.0);
}