#version 150

in vec4 vertexColor;
uniform vec4 ColorModulator;

out vec4 fragColor;

// Enhanced saturation for sky elements
vec3 boostSaturation(vec3 color, float factor) {
    float gray = (color.r + color.g + color.b) / 3.0;
    return clamp(gray + (color - vec3(gray)) * factor, 0.0, 1.0);
}

void main() {
    vec4 color = vertexColor;
    
    if (color.a == 0.0) {
        discard;
    }

    // Enhanced brightness for sky
    color.rgb *= 1.2;

    // Enhanced saturation
    color.rgb = boostSaturation(color.rgb, 1.3);

    // Slight blue tint for sky
    vec3 skyTint = vec3(0.95, 0.9, 1.05);
    color.rgb *= skyTint;

    fragColor = color * ColorModulator;
}