#version 150

#moj_import <fog.glsl>

uniform mat4 ProjMat;
uniform vec4 ColorModulator;
uniform vec4 FogColor;
uniform float FogStart;
uniform float FogEnd;

in vec4 vertexColor;
in float vertexDistance;

out vec4 fragColor;

void main() {
    vec4 color = vertexColor * ColorModulator;

    // Skip nearly transparent pixels
    if (color.a < 0.1) {
        discard;
    }

    // Enhanced brightness for clouds
    color.rgb *= 1.4;
    float average = (color.r + color.g + color.b) / 3.0;
    color.rgb = clamp(average + (color.rgb - vec3(average)) * 1.3, 0.0, 1.0);

    // Fog calculation
    float fogWidth = FogEnd - FogStart;
    float extendedWidth = fogWidth * 4.0;
    float fogFade = linear_fog_fade(vertexDistance, FogStart, FogStart + extendedWidth) * FogColor.a;
    fragColor = vec4(mix(FogColor.rgb, color.rgb, 0.7), clamp(color.a * fogFade, 0.0, 1.0));
}