/*
 * Decompiled with CFR 0.152.
 */
package com.cak.bfrc.core;

import com.cak.bfrc.core.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum EnabledState {
    ENABLED(0, "on", ChatFormatting.GREEN),
    DISABLED(1, "off", ChatFormatting.RED);

    private final int index;
    private final String langName;
    private final ChatFormatting color;

    private EnabledState(int index, String langName, ChatFormatting color) {
        this.index = index;
        this.langName = langName;
        this.color = color;
    }

    public static EnabledState byBool(Boolean currentlyEnabled) {
        return currentlyEnabled != false ? ENABLED : DISABLED;
    }

    public MutableComponent getNameComponent() {
        return Lang.modTranslatable("enabled_state." + this.langName, this.color, ChatFormatting.BOLD);
    }

    public MutableComponent getStateComponent() {
        return Lang.literal("[", ChatFormatting.WHITE, ChatFormatting.BOLD).append((Component)this.getNameComponent()).append((Component)Lang.literal("]", ChatFormatting.WHITE, ChatFormatting.BOLD));
    }

    public EnabledState next() {
        return EnabledState.values()[(this.index + 1) % EnabledState.values().length];
    }
}

