/*
 * Decompiled with CFR 0.152.
 */
package com.cak.bfrc.core;

import com.cak.bfrc.core.BFRC;
import com.cak.bfrc.platform.accessors.PlatformReflectionHelper;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public class EventHandlers {
    public static InteractionHand lastInteractionHand = null;
    public static InteractionHand lastUsedInteractionHand = InteractionHand.MAIN_HAND;
    public static boolean noCooldownPeriodActive = false;
    public static InteractionHand noCooldownPeriodHand = InteractionHand.MAIN_HAND;

    public static void tryRightClickHarvest(Level level, ItemStack stack, BlockPos pos, Direction hitVecDirection) {
        if (!BFRC.CONFIG_ACCESSOR.rightClickHarvestEnabled()) {
            return;
        }
        if (!level.isClientSide) {
            return;
        }
        if (Minecraft.getInstance().gameMode == null) {
            return;
        }
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        if (!(block instanceof CropBlock)) {
            return;
        }
        CropBlock heldCropBlock = (CropBlock)block;
        BlockState clickedState = level.getBlockState(pos);
        Block block2 = clickedState.getBlock();
        if (!(block2 instanceof CropBlock)) {
            return;
        }
        CropBlock cropBlock = (CropBlock)block2;
        if (heldCropBlock != cropBlock) {
            return;
        }
        if (!cropBlock.isMaxAge(clickedState)) {
            return;
        }
        Minecraft.getInstance().gameMode.startDestroyBlock(pos, hitVecDirection);
    }

    public static void tickNoCooldownInteractions() {
        if (lastInteractionHand != null) {
            lastUsedInteractionHand = lastInteractionHand;
        }
        lastInteractionHand = null;
        if (!BFRC.CONFIG_ACCESSOR.noCooldownEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.gameMode == null || mc.player == null) {
            return;
        }
        if (!mc.level.isClientSide) {
            return;
        }
        if (!mc.options.keyUse.isDown()) {
            lastUsedInteractionHand = InteractionHand.MAIN_HAND;
            noCooldownPeriodHand = InteractionHand.MAIN_HAND;
            noCooldownPeriodActive = false;
            return;
        }
        InteractionHand hand = noCooldownPeriodActive ? noCooldownPeriodHand : lastUsedInteractionHand;
        ItemStack stack = mc.player.getItemInHand(hand);
        Item item = stack.getItem();
        if (EventHandlers.isNoCooldownItem(item)) {
            noCooldownPeriodActive = true;
            noCooldownPeriodHand = hand;
            try {
                Field field = PlatformReflectionHelper.findField(Minecraft.class, "rightClickDelay");
                field.setAccessible(true);
                field.setInt(Minecraft.getInstance(), 0);
            }
            catch (Exception e) {
                BFRC.LOGGER.error("!!! Critical error in 'no cooldown' handling! PLS report to mod author !!!");
                e.printStackTrace();
            }
        }
    }

    private static boolean isNoCooldownItem(Item item) {
        BlockItem blockItem;
        return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof CropBlock || item instanceof HoeItem;
    }
}

