/*
 * Decompiled with CFR 0.152.
 */
package com.cak.bfrc.platform.config;

import com.cak.bfrc.core.BFRC;
import com.cak.bfrc.core.EnabledState;
import com.cak.bfrc.core.config.ConfigAccessor;
import com.cak.bfrc.core.config.ConfigOptions;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeoForgeModConfig
implements ConfigAccessor {
    final ModConfigSpec.ConfigValue<Boolean> noCooldownEnabled;
    final ModConfigSpec.ConfigValue<Boolean> rightClickHarvestEnabled;
    final ModConfigSpec.ConfigValue<Boolean> enabledOnStartup;
    public static NeoForgeModConfig config;
    public static ModConfigSpec configSpec;

    public NeoForgeModConfig(ModConfigSpec.Builder builder) {
        this.noCooldownEnabled = builder.comment("Whether the no cooldown tool should be enabled (this is what allows the quick usage of seeds and hoes)").define("no_cooldown_enabled", true);
        this.rightClickHarvestEnabled = builder.comment("Whether the right click harvest tool should be enabled").define("right_click_harvest", true);
        this.enabledOnStartup = builder.comment("Whether the mod should be enabled on startup").define("startup_enabled", true);
    }

    @Override
    public void triggerSave() {
        this.noCooldownEnabled.set((Object)((Boolean)ConfigOptions.noCooldownEnabledOption.get()));
        this.rightClickHarvestEnabled.set((Object)((Boolean)ConfigOptions.rightClickHarvestEnabledOption.get()));
        this.enabledOnStartup.set((Object)((Boolean)ConfigOptions.enableOnStartupOption.get()));
        EnabledState newState = EnabledState.byBool((Boolean)ConfigOptions.enableOnStartupOption.get());
        if (newState != BFRC.CURRENT_STATE) {
            BFRC.CURRENT_STATE = newState;
            BFRC.showEnabledState();
        }
    }

    @Override
    public boolean noCooldownEnabled() {
        return (Boolean)this.noCooldownEnabled.get();
    }

    @Override
    public boolean rightClickHarvestEnabled() {
        return (Boolean)this.rightClickHarvestEnabled.get();
    }

    @Override
    public boolean enabledOnStartup() {
        return (Boolean)this.enabledOnStartup.get();
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(NeoForgeModConfig::new);
        config = (NeoForgeModConfig)pair.getLeft();
        configSpec = (ModConfigSpec)pair.getRight();
    }
}

