/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs;

import eu.mrneznamy.mrultimatejobs.api.MrUltimateJobsAPI;
import eu.mrneznamy.mrultimatejobs.commands.JobsCommand;
import eu.mrneznamy.mrultimatejobs.commands.MUJCommand;
import eu.mrneznamy.mrultimatejobs.integrations.PlaceholderAPIIntegration;
import eu.mrneznamy.mrultimatejobs.listeners.JobListener;
import eu.mrneznamy.mrultimatejobs.listeners.MenuListener;
import eu.mrneznamy.mrultimatejobs.managers.BoosterManager;
import eu.mrneznamy.mrultimatejobs.managers.ConfigManager;
import eu.mrneznamy.mrultimatejobs.managers.DataManager;
import eu.mrneznamy.mrultimatejobs.managers.EventManager;
import eu.mrneznamy.mrultimatejobs.managers.JobManager;
import eu.mrneznamy.mrultimatejobs.managers.MessageManager;
import eu.mrneznamy.mrultimatejobs.managers.PlayerDataManager;
import eu.mrneznamy.mrultimatejobs.managers.PlayerJobManager;
import eu.mrneznamy.mrultimatejobs.managers.TournamentManager;
import eu.mrneznamy.mrultimatejobs.menus.MenuManager;
import eu.mrneznamy.mrultimatejobs.utils.CheckUpdates;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MrUltimateJobs
extends JavaPlugin {
    private static MrUltimateJobs instance;
    private MessageManager messageManager;
    private JobManager jobManager;
    private PlayerJobManager playerJobManager;
    private PlayerDataManager playerDataManager;
    private MenuManager menuManager;
    private DataManager dataManager;
    private JobListener jobListener;
    private EventManager eventManager;
    private TournamentManager tournamentManager;
    private BoosterManager boosterManager;
    private ConfigManager configManager;
    private PlaceholderAPIIntegration placeholderAPIIntegration;
    private MrUltimateJobsAPI api;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.dataManager = new DataManager(this);
        this.dataManager.createDefaultFilesIfNotExists();
        this.messageManager = new MessageManager(this);
        this.configManager = new ConfigManager(this);
        this.jobManager = new JobManager(this);
        this.playerJobManager = new PlayerJobManager(this);
        this.playerDataManager = new PlayerDataManager(this);
        this.menuManager = new MenuManager(this);
        this.eventManager = new EventManager(this);
        this.tournamentManager = new TournamentManager(this);
        this.boosterManager = new BoosterManager(this);
        this.api = new MrUltimateJobsAPI(this);
        this.jobManager.loadJobs();
        this.getCommand("jobs").setExecutor((CommandExecutor)new JobsCommand(this));
        this.getCommand("jobs").setTabCompleter((TabCompleter)new JobsCommand(this));
        this.getCommand("muj").setExecutor((CommandExecutor)new MUJCommand(this));
        this.getCommand("muj").setTabCompleter((TabCompleter)new MUJCommand(this));
        this.jobListener = new JobListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.jobListener, (Plugin)this);
        for (Player p : this.getServer().getOnlinePlayers()) {
            this.getPlayerJobManager().restorePlayerJobFromData(p);
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.placeholderAPIIntegration = new PlaceholderAPIIntegration(this);
            this.placeholderAPIIntegration.register();
        }
        CheckUpdates updater = new CheckUpdates();
        updater.EnableMessage();
        updater.checkForUpdates();
    }

    public void onDisable() {
        if (this.playerDataManager != null) {
            this.playerDataManager.saveAllPlayerData();
        }
        if (this.eventManager != null) {
            this.eventManager.shutdown();
        }
        if (this.tournamentManager != null) {
            this.tournamentManager.shutdown();
        }
        if (this.boosterManager != null) {
            this.boosterManager.shutdown();
        }
        if (this.jobListener != null) {
            this.jobListener.cleanup();
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null && this.placeholderAPIIntegration != null) {
            this.placeholderAPIIntegration.unregister();
        }
    }

    public static MrUltimateJobs getInstance() {
        return instance;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public PlayerJobManager getPlayerJobManager() {
        return this.playerJobManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public PlaceholderAPIIntegration getPlaceholderAPIIntegration() {
        return this.placeholderAPIIntegration;
    }

    public JobListener getJobListener() {
        return this.jobListener;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public TournamentManager getTournamentManager() {
        return this.tournamentManager;
    }

    public BoosterManager getBoosterManager() {
        return this.boosterManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MrUltimateJobsAPI getAPI() {
        return this.api;
    }
}

