/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.listeners;

import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import eu.mrneznamy.mrultimatejobs.utils.ColorSystem;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MenuListener
implements Listener {
    private final MrUltimateJobs plugin;

    public MenuListener(MrUltimateJobs plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getClickedInventory();
        if (inventory == null) {
            return;
        }
        String title = event.getView().getTitle();
        if (this.isJobsMenu(title)) {
            event.setCancelled(true);
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem == null || !clickedItem.hasItemMeta()) {
                return;
            }
            ItemMeta meta = clickedItem.getItemMeta();
            if (meta == null || !meta.hasDisplayName()) {
                return;
            }
            String displayName = meta.getDisplayName();
            String jobFromTag = null;
            try {
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "job");
                jobFromTag = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.isRewardsMenu(title)) {
                this.handleRewardsMenuClick(player, displayName, event.getSlot(), title, event.getCurrentItem());
                return;
            }
            if (jobFromTag != null && !jobFromTag.isEmpty()) {
                this.handleMainMenuClick(player, displayName, jobFromTag, event.getClick(), event.getRawSlot());
            }
        }
    }

    private boolean isJobsMenu(String title) {
        boolean isJobs;
        if (title == null || title.trim().isEmpty()) {
            return false;
        }
        String cleanTitle = ColorSystem.stripColor(title);
        boolean bl = isJobs = cleanTitle.contains("Head Menu") || cleanTitle.contains("Jobs") || cleanTitle.contains("jobs") || cleanTitle.contains("JOBS") || cleanTitle.contains("Rewards") || cleanTitle.contains("rewards") || cleanTitle.contains("REWARDS");
        if (isJobs) {
            return true;
        }
        try {
            String baseRewardsTitle;
            String headMenuTitle = this.plugin.getMenuManager().getMenuConfig().getString("MrUltimateJobs.HeadMenu.title", "Jobs Menu");
            String cleanHeadTitle = ColorSystem.stripColor(ColorSystem.colorize(headMenuTitle));
            if (cleanTitle.equals(cleanHeadTitle)) {
                return true;
            }
            String rewardsMenuTitle = this.plugin.getMenuManager().getRewardsConfig().getString("MrUltimateJobs.Rewards.title", "Jobs Rewards");
            String cleanRewardsTitle = ColorSystem.stripColor(ColorSystem.colorize(rewardsMenuTitle));
            if (cleanTitle.contains("|") && cleanRewardsTitle.contains("[JobName]") && (cleanTitle.contains(baseRewardsTitle = cleanRewardsTitle.replace("[JobName]", "").replace("[Job]", "").trim()) || baseRewardsTitle.contains(cleanTitle))) {
                return true;
            }
            if (cleanTitle.equals(cleanRewardsTitle)) {
                return true;
            }
            for (String jobName : this.plugin.getJobManager().getJobNames()) {
                try {
                    FileConfiguration jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
                    String jobDisplayName = jobConfig.getString("MrUltimateJobs.Job.Name", jobName);
                    String cleanJobName = ColorSystem.stripColor(jobDisplayName);
                    if (!cleanTitle.contains(cleanJobName) && !cleanTitle.contains(jobName)) continue;
                    return true;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private boolean isRewardsMenu(String title) {
        if (title == null || title.trim().isEmpty()) {
            return false;
        }
        if (!this.isJobsMenu(title)) {
            return false;
        }
        try {
            String headMenuTitle = this.plugin.getMenuManager().getMenuConfig().getString("MrUltimateJobs.HeadMenu.title", "Jobs Menu");
            String cleanHeadTitle = ColorSystem.stripColor(ColorSystem.colorize(headMenuTitle));
            String cleanTitle = ColorSystem.stripColor(title);
            if (cleanTitle.equals(cleanHeadTitle)) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    private void handleRewardsMenuClick(Player player, String displayName, int slot, String menuTitle, ItemStack clickedItem) {
        PersistentDataContainer pdc;
        ItemMeta meta2;
        String jobName = this.plugin.getMenuManager().getCurrentRewardsJob(player);
        if (jobName == null || jobName.isEmpty()) {
            jobName = this.extractJobNameFromTitle(menuTitle);
        }
        if (displayName.contains("Back") || displayName.contains("back") || displayName.contains("BACK")) {
            this.plugin.getMenuManager().openHeadMenu(player);
            return;
        }
        if (jobName != null && clickedItem != null && clickedItem.hasItemMeta()) {
            try {
                meta2 = clickedItem.getItemMeta();
                pdc = meta2.getPersistentDataContainer();
                String nav = (String)pdc.get(new NamespacedKey((Plugin)this.plugin, "rewards-nav"), PersistentDataType.STRING);
                if (nav != null) {
                    int current = this.plugin.getMenuManager().getRewardsPage(player);
                    int max = this.plugin.getMenuManager().getMaxRewardsPages(jobName);
                    if (nav.equalsIgnoreCase("next")) {
                        int next = Math.min(max - 1, current + 1);
                        this.plugin.getMenuManager().openRewardsMenu(player, jobName, next);
                        return;
                    }
                    if (nav.equalsIgnoreCase("previous")) {
                        int prev = Math.max(0, current - 1);
                        this.plugin.getMenuManager().openRewardsMenu(player, jobName, prev);
                        return;
                    }
                }
            }
            catch (Throwable meta2) {
                // empty catch block
            }
        }
        if (jobName != null && clickedItem != null && clickedItem.hasItemMeta()) {
            try {
                meta2 = clickedItem.getItemMeta();
                pdc = meta2.getPersistentDataContainer();
                String itemJob = (String)pdc.get(new NamespacedKey((Plugin)this.plugin, "job"), PersistentDataType.STRING);
                Integer level = (Integer)pdc.get(new NamespacedKey((Plugin)this.plugin, "level"), PersistentDataType.INTEGER);
                if (itemJob != null && level != null && itemJob.equalsIgnoreCase(jobName)) {
                    if (this.plugin.getPlayerJobManager().isPlayerInJob(player, jobName) && this.plugin.getPlayerJobManager().getPlayerJobLevel(player, jobName) >= level) {
                        if (!this.plugin.getPlayerDataManager().isRewardClaimed(player, jobName, level)) {
                            FileConfiguration jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
                            List cmds = jobConfig.getStringList("MrUltimateJobs.Job.System.Levels-Rewards." + level + ".Commands");
                            for (String cmd : cmds) {
                                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), cmd.replace("[PlayerName]", player.getName()));
                            }
                            this.plugin.getPlayerDataManager().setRewardClaimed(player, jobName, level);
                            player.sendMessage(this.plugin.getMessageManager().getMessage("general.reward-claimed"));
                            int current = this.plugin.getMenuManager().getRewardsPage(player);
                            this.plugin.getMenuManager().openRewardsMenu(player, jobName, current);
                        } else {
                            player.sendMessage(this.plugin.getMessageManager().getMessage("general.reward-already-claimed"));
                        }
                    } else {
                        player.sendMessage(this.plugin.getMessageManager().getMessage("general.reward-not-available"));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void handleMainMenuClick(Player player, String displayName, String localizedName, ClickType clickType, int slot) {
        String jobName;
        String string = jobName = localizedName != null && !localizedName.isEmpty() ? localizedName : this.extractJobName(displayName);
        if (jobName != null) {
            if (clickType.isRightClick()) {
                if (!(player.hasPermission("mrultimatejobs.jobs.leave.*") || player.hasPermission("mrultimatejobs.admin") || player.hasPermission("mrultimatejobs.jobs.leave." + jobName.toLowerCase()))) {
                    player.sendMessage(this.plugin.getMessageManager().getMessage("general.no-permission"));
                    return;
                }
                if (this.plugin.getPlayerJobManager().isPlayerInJob(player, jobName)) {
                    this.plugin.getPlayerJobManager().removePlayerJob(player, jobName);
                    player.sendMessage(this.plugin.getMessageManager().getMessage("general.leave-job", "Job", jobName));
                } else {
                    player.sendMessage(this.plugin.getMessageManager().getMessage("general.not-in-job", "Job", jobName));
                }
            } else if (clickType.isLeftClick()) {
                if (!(player.hasPermission("mrultimatejobs.jobs.join.*") || player.hasPermission("mrultimatejobs.admin") || player.hasPermission("mrultimatejobs.jobs.join." + jobName.toLowerCase()))) {
                    player.sendMessage(this.plugin.getMessageManager().getMessage("general.no-permission"));
                    return;
                }
                if (this.plugin.getPlayerJobManager().isPlayerInJob(player, jobName)) {
                    player.sendMessage(this.plugin.getMessageManager().getMessage("general.already-in-job", "Job", jobName));
                } else if (!this.plugin.getPlayerJobManager().canJoinAnotherJob(player)) {
                    int maxJobs = this.plugin.getPlayerJobManager().getMaxJobsForPlayer(player);
                    player.sendMessage(this.plugin.getMessageManager().getMessage("general.max-jobs-reached", "Max", String.valueOf(maxJobs)));
                } else {
                    this.plugin.getPlayerJobManager().addJob(player, jobName);
                    player.sendMessage(this.plugin.getMessageManager().getMessage("general.join-job", "Job", jobName));
                }
            } else if (clickType == ClickType.MIDDLE) {
                this.plugin.getMenuManager().openRewardsMenu(player, jobName);
                return;
            }
        }
        if (!(displayName.contains("Back") || displayName.contains("back") || displayName.contains("BACK") || !clickType.isLeftClick() && !clickType.isRightClick())) {
            player.closeInventory();
        }
    }

    private String extractJobName(String displayName) {
        String cleanName = ColorSystem.stripColor(displayName);
        for (String jobName : this.plugin.getJobManager().getJobNames()) {
            String jobDisplayName = this.plugin.getJobManager().getJobConfig(jobName).getString("MrUltimateJobs.Job.Name", jobName);
            String cleanJobDisplayName = ColorSystem.stripColor(jobDisplayName);
            if (!cleanName.contains(cleanJobDisplayName) && !cleanName.contains(cleanJobDisplayName.toLowerCase())) continue;
            return jobName;
        }
        return null;
    }

    private String extractJobNameFromTitle(String title) {
        if (title == null || title.trim().isEmpty()) {
            return null;
        }
        String cleanTitle = ColorSystem.stripColor(title);
        for (String jobKey : this.plugin.getJobManager().getJobNames()) {
            try {
                String cleanDisplayName;
                FileConfiguration cfg = this.plugin.getJobManager().getJobConfig(jobKey);
                String jobConfigName = cfg.getString("MrUltimateJobs.Job.JobConfigName", jobKey);
                String displayName = cfg.getString("MrUltimateJobs.Job.Name", jobKey);
                if (cleanTitle.contains(jobKey)) {
                    return jobKey;
                }
                if (jobConfigName != null && cleanTitle.contains(jobConfigName)) {
                    return jobKey;
                }
                if (displayName == null || !cleanTitle.contains(cleanDisplayName = ColorSystem.stripColor(displayName))) continue;
                return jobKey;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }
}

