/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.managers;

import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class JobManager {
    private final MrUltimateJobs plugin;
    private final Map<String, FileConfiguration> jobConfigs;
    private final File jobsFolder;

    public JobManager(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.jobConfigs = new HashMap<String, FileConfiguration>();
        this.jobsFolder = new File(plugin.getDataFolder(), "Jobs");
        if (!this.jobsFolder.exists()) {
            this.jobsFolder.mkdirs();
        }
    }

    public void loadJobs() {
        this.jobConfigs.clear();
        if (!this.jobsFolder.exists() || !this.jobsFolder.isDirectory()) {
            return;
        }
        File[] jobFiles = this.jobsFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (jobFiles == null || jobFiles.length == 0) {
            return;
        }
        for (File jobFile : jobFiles) {
            this.loadJobFile(jobFile);
        }
    }

    private void loadJobFile(File jobFile) {
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)jobFile);
            String validationError = this.validateJobConfig((FileConfiguration)config, jobFile.getName());
            if (validationError != null) {
                return;
            }
            String jobName = config.getString("MrUltimateJobs.Job.JobConfigName");
            if (jobName == null || jobName.isEmpty()) {
                return;
            }
            if (this.jobConfigs.containsKey(jobName.toLowerCase())) {
                return;
            }
            this.jobConfigs.put(jobName.toLowerCase(), (FileConfiguration)config);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String validateJobConfig(FileConfiguration config, String fileName) {
        String balanceSystem;
        if (!config.contains("MrUltimateJobs.Job")) {
            return "Missing MrUltimateJobs.Job section";
        }
        if (!config.contains("MrUltimateJobs.Job.JobConfigName")) {
            return "Missing JobConfigName field";
        }
        if (!config.contains("MrUltimateJobs.Job.Name")) {
            return "Missing Name field";
        }
        if (!config.contains("MrUltimateJobs.Job.System")) {
            return "Missing System section";
        }
        Object action = config.get("MrUltimateJobs.Job.System.Actions.Action");
        if (action == null) {
            return "Missing Action field";
        }
        if (action instanceof String) {
            if (!this.isValidAction((String)action)) {
                return "Invalid Action type: " + String.valueOf(action) + ". Valid actions are: MINE, PLACE, KILL, CRAFT, BREW, CATCH, ENCHANT";
            }
        } else if (action instanceof List) {
            List actions = (List)action;
            for (String act : actions) {
                if (this.isValidAction(act)) continue;
                return "Invalid Action type: " + act + ". Valid actions are: MINE, PLACE, KILL, CRAFT, BREW, CATCH, ENCHANT";
            }
        } else {
            return "Invalid Action field format. Must be a string or list of strings";
        }
        if ((balanceSystem = config.getString("MrUltimateJobs.Job.System.Actions.BalanceSystem")) != null && !balanceSystem.equals("OLD") && !balanceSystem.equals("NEW")) {
            return "Invalid BalanceSystem: " + balanceSystem + ". Must be either OLD or NEW";
        }
        return null;
    }

    private boolean isValidAction(String action) {
        return action.equals("MINE") || action.equals("PLACE") || action.equals("KILL") || action.equals("CRAFT") || action.equals("BREW") || action.equals("CATCH") || action.equals("ENCHANT");
    }

    public FileConfiguration getJobConfig(String jobName) {
        return this.jobConfigs.get(jobName.toLowerCase());
    }

    public Set<String> getJobNames() {
        return this.jobConfigs.keySet();
    }

    public int getJobCount() {
        return this.jobConfigs.size();
    }

    public void reloadJobs() {
        this.loadJobs();
    }

    public boolean jobHasAction(String jobName, String action) {
        FileConfiguration config = this.getJobConfig(jobName);
        if (config == null) {
            return false;
        }
        Object jobAction = config.get("MrUltimateJobs.Job.System.Actions.Action");
        if (jobAction instanceof String) {
            return jobAction.equals(action);
        }
        if (jobAction instanceof List) {
            return ((List)jobAction).contains(action);
        }
        return false;
    }
}

