/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.managers;

import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import eu.mrneznamy.mrultimatejobs.utils.ColorSystem;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final MrUltimateJobs plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public MessageManager(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void reloadConfig() {
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString(path);
        if (message == null) {
            return "&cMessage not found: " + path;
        }
        String prefix = this.messagesConfig.getString("prefix", "&8[&6MrUltimateJobs&8] ");
        message = message.replace("{prefix}", prefix);
        return ColorSystem.colorize(message);
    }

    public String getMessage(String path, String ... replacements) {
        String message = this.messagesConfig.getString(path);
        if (message == null) {
            return "&cMessage not found: " + path;
        }
        String prefix = this.messagesConfig.getString("prefix", "&8[&6MrUltimateJobs&8] ");
        message = message.replace("{prefix}", prefix);
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            String placeholder = replacements[i];
            String value = replacements[i + 1];
            message = message.replace("[" + placeholder + "]", value);
            message = message.replace("{" + placeholder + "}", value);
            message = message.replace("%" + placeholder + "%", value);
            message = message.replace("<" + placeholder + ">", value);
        }
        return ColorSystem.colorize(message);
    }

    public void loadMessages() {
        this.reloadConfig();
    }

    public List<String> getMessageList(String path) {
        List messages = this.messagesConfig.getStringList(path);
        if (messages.isEmpty()) {
            return List.of("&cMessage list not found: " + path);
        }
        String prefix = this.messagesConfig.getString("prefix", "&8[&6MrUltimateJobs&8] ");
        return messages.stream().map(message -> message.replace("{prefix}", prefix)).map(ColorSystem::colorize).toList();
    }

    public String getPrefix() {
        return this.messagesConfig.getString("prefix", "&8[&6MrUltimateJobs&8] ");
    }
}

