/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.managers;

import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerDataManager {
    private final MrUltimateJobs plugin;
    private final Map<UUID, FileConfiguration> playerDataCache;
    private final Map<UUID, File> playerDataFiles;

    public PlayerDataManager(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.playerDataCache = new HashMap<UUID, FileConfiguration>();
        this.playerDataFiles = new HashMap<UUID, File>();
    }

    public void loadPlayerData(Player player) {
        UUID uuid = player.getUniqueId();
        File dataFolder = new File(this.plugin.getDataFolder(), "playerdata");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        File dataFile = new File(dataFolder, uuid.toString() + ".yml");
        this.playerDataFiles.put(uuid, dataFile);
        if (dataFile.exists()) {
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            this.playerDataCache.put(uuid, (FileConfiguration)data);
        } else {
            YamlConfiguration data = new YamlConfiguration();
            this.playerDataCache.put(uuid, (FileConfiguration)data);
            this.savePlayerData(player);
        }
    }

    public void savePlayerData(Player player) {
        UUID uuid = player.getUniqueId();
        FileConfiguration data = this.playerDataCache.get(uuid);
        File dataFile = this.playerDataFiles.get(uuid);
        if (data != null && dataFile != null) {
            try {
                data.save(dataFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not save player data for " + player.getName() + ": " + e.getMessage());
            }
        }
    }

    public void saveAllPlayerData() {
        for (UUID uUID : this.playerDataCache.keySet()) {
        }
    }

    public void setPlayerJobStats(Player player, String jobName, int level, double xp, double moneyEarned) {
        UUID uuid = player.getUniqueId();
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data != null) {
            data.set("current-job", (Object)jobName);
            String path = "jobs." + jobName.toLowerCase();
            data.set(path + ".level", (Object)level);
            data.set(path + ".xp", (Object)xp);
            data.set(path + ".moneyEarned", (Object)moneyEarned);
            List active = data.getStringList("Active-Jobs");
            if (!active.contains(jobName)) {
                active.add(jobName);
                data.set("Active-Jobs", (Object)active);
            }
            this.savePlayerData(player);
        }
    }

    public void addCurrentJob(Player player, String jobName) {
        UUID uuid = player.getUniqueId();
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data == null) {
            return;
        }
        List jobs = data.getStringList("current-jobs");
        if (!jobs.contains(jobName)) {
            jobs.add(jobName);
            data.set("current-jobs", (Object)jobs);
            this.savePlayerData(player);
        }
    }

    public void removeCurrentJob(Player player, String jobName) {
        UUID uuid = player.getUniqueId();
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data == null) {
            return;
        }
        List jobs = data.getStringList("current-jobs");
        if (jobs.removeIf(j -> j.equalsIgnoreCase(jobName))) {
            data.set("current-jobs", (Object)jobs);
            this.savePlayerData(player);
        }
    }

    public List<String> getCurrentJobs(UUID uuid) {
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data == null) {
            return Collections.emptyList();
        }
        return data.getStringList("current-jobs");
    }

    public List<String> getActiveJobs(UUID uuid) {
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data == null) {
            return Collections.emptyList();
        }
        return data.getStringList("Active-Jobs");
    }

    public void addActiveJob(Player player, String jobName) {
        UUID uuid = player.getUniqueId();
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data == null) {
            return;
        }
        List active = data.getStringList("Active-Jobs");
        if (!active.contains(jobName)) {
            active.add(jobName);
            data.set("Active-Jobs", (Object)active);
            this.savePlayerData(player);
        }
    }

    public void removeActiveJob(Player player, String jobName) {
        UUID uuid = player.getUniqueId();
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data == null) {
            return;
        }
        List active = data.getStringList("Active-Jobs");
        if (active.removeIf(j -> j.equalsIgnoreCase(jobName))) {
            data.set("Active-Jobs", (Object)active);
            this.savePlayerData(player);
        }
    }

    public int getPlayerJobLevel(Player player, String jobName) {
        UUID uuid = player.getUniqueId();
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data != null) {
            String path = "jobs." + jobName.toLowerCase();
            return data.getInt(path + ".level", 1);
        }
        return 1;
    }

    public double getPlayerJobXP(Player player, String jobName) {
        UUID uuid = player.getUniqueId();
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data != null) {
            String path = "jobs." + jobName.toLowerCase();
            return data.getDouble(path + ".xp", 0.0);
        }
        return 0.0;
    }

    public double getPlayerMoneyEarned(Player player, String jobName) {
        UUID uuid = player.getUniqueId();
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data != null) {
            String path = "jobs." + jobName.toLowerCase();
            return data.getDouble(path + ".moneyEarned", 0.0);
        }
        return 0.0;
    }

    public void addPlayerMoneyEarned(Player player, String jobName, double amount) {
        UUID uuid = player.getUniqueId();
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data != null) {
            String path = "jobs." + jobName.toLowerCase();
            double current = data.getDouble(path + ".moneyEarned", 0.0);
            data.set(path + ".moneyEarned", (Object)(current + amount));
            double totalMoney = data.getDouble("total-money-earned", 0.0);
            data.set("total-money-earned", (Object)(totalMoney + amount));
            this.savePlayerData(player);
        }
    }

    public void setRewardClaimed(Player player, String jobName, int level) {
        UUID uuid = player.getUniqueId();
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data != null) {
            String path = "jobs." + jobName.toLowerCase() + ".claimedRewards";
            data.set(path + "." + level, (Object)true);
            this.savePlayerData(player);
        }
    }

    public boolean isRewardClaimed(Player player, String jobName, int level) {
        UUID uuid = player.getUniqueId();
        FileConfiguration data = this.playerDataCache.get(uuid);
        if (data != null) {
            String path = "jobs." + jobName.toLowerCase() + ".claimedRewards";
            return data.getBoolean(path + "." + level, false);
        }
        return false;
    }

    public FileConfiguration getPlayerData(UUID playerUUID) {
        return this.playerDataCache.get(playerUUID);
    }

    public double getTotalMoneyEarned(UUID playerUUID) {
        FileConfiguration data = this.playerDataCache.get(playerUUID);
        if (data != null) {
            return data.getDouble("total-money-earned", 0.0);
        }
        return 0.0;
    }
}

