/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.managers;

import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import eu.mrneznamy.mrultimatejobs.utils.ColorSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TournamentManager {
    private final MrUltimateJobs plugin;
    private FileConfiguration tournamentConfig;
    private File tournamentFile;
    private Tournament activeTournament;
    private BukkitTask tournamentTask;
    private BukkitTask autoStartTask;
    private BossBar tournamentBossBar;
    private final Map<UUID, PlayerTournamentData> playerData = new ConcurrentHashMap<UUID, PlayerTournamentData>();

    public TournamentManager(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.loadConfig();
        this.loadActiveTournament();
        this.startAutoTournamentScheduler();
    }

    private void loadConfig() {
        this.tournamentFile = new File(this.plugin.getDataFolder(), "tournaments.yml");
        if (!this.tournamentFile.exists()) {
            this.plugin.saveResource("tournaments.yml", false);
        }
        this.tournamentConfig = YamlConfiguration.loadConfiguration((File)this.tournamentFile);
    }

    public void reloadConfig() {
        this.tournamentConfig = YamlConfiguration.loadConfiguration((File)this.tournamentFile);
        if (this.autoStartTask != null) {
            this.autoStartTask.cancel();
        }
        this.startAutoTournamentScheduler();
    }

    private void loadActiveTournament() {
        File activeTournamentFile = new File(this.plugin.getDataFolder(), "active-tournament.yml");
        if (activeTournamentFile.exists()) {
            YamlConfiguration activeTournamentConfig = YamlConfiguration.loadConfiguration((File)activeTournamentFile);
            int tournamentId = activeTournamentConfig.getInt("tournament-id", -1);
            long startTime = activeTournamentConfig.getLong("start-time", 0L);
            int duration = activeTournamentConfig.getInt("duration", 0);
            if (tournamentId != -1 && startTime != 0L && duration != 0) {
                long endTime;
                long currentTime = System.currentTimeMillis();
                if (currentTime < (endTime = startTime + (long)(duration * 60) * 1000L)) {
                    ConfigurationSection tournamentSection = this.tournamentConfig.getConfigurationSection("MrUltimateJobs.Events." + tournamentId);
                    if (tournamentSection != null) {
                        this.activeTournament = new Tournament(tournamentId, tournamentSection);
                        this.playerData.clear();
                        this.createBossBar();
                        this.startTournamentTimer();
                    }
                } else {
                    activeTournamentFile.delete();
                }
            }
        }
    }

    private void saveActiveTournament() {
        if (this.activeTournament == null) {
            return;
        }
        File activeTournamentFile = new File(this.plugin.getDataFolder(), "active-tournament.yml");
        YamlConfiguration activeTournamentConfig = new YamlConfiguration();
        activeTournamentConfig.set("tournament-id", (Object)this.activeTournament.id);
        activeTournamentConfig.set("start-time", (Object)System.currentTimeMillis());
        activeTournamentConfig.set("duration", (Object)this.activeTournament.timeToEnd);
        try {
            activeTournamentConfig.save(activeTournamentFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteActiveTournament() {
        File activeTournamentFile = new File(this.plugin.getDataFolder(), "active-tournament.yml");
        if (activeTournamentFile.exists()) {
            activeTournamentFile.delete();
        }
    }

    private void startAutoTournamentScheduler() {
        if (!this.tournamentConfig.getBoolean("MrUltimateJobs.Enabled", true)) {
            return;
        }
        String timesString = this.tournamentConfig.getString("MrUltimateJobs.Tournaments-Starting", "");
        if (timesString.isEmpty()) {
            return;
        }
        final String[] times = timesString.split(",");
        this.autoStartTask = new BukkitRunnable(this){
            final /* synthetic */ TournamentManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                Calendar now = Calendar.getInstance();
                int currentHour = now.get(11);
                int currentMinute = now.get(12);
                for (String timeStr : times) {
                    try {
                        int minute;
                        String[] timeParts = timeStr.trim().split(":");
                        int hour = Integer.parseInt(timeParts[0]);
                        int n = minute = timeParts.length > 1 ? Integer.parseInt(timeParts[1]) : 0;
                        if (currentHour != hour || currentMinute != minute || this.this$0.activeTournament != null) continue;
                        this.this$0.startRandomTournament();
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1200L);
    }

    public boolean startTournament(int tournamentId) {
        if (this.activeTournament != null) {
            return false;
        }
        ConfigurationSection tournamentSection = this.tournamentConfig.getConfigurationSection("MrUltimateJobs.Events." + tournamentId);
        if (tournamentSection == null) {
            return false;
        }
        this.activeTournament = new Tournament(tournamentId, tournamentSection);
        this.playerData.clear();
        this.saveActiveTournament();
        this.createBossBar();
        this.sendTournamentMessages("Start");
        this.startTournamentTimer();
        return true;
    }

    public boolean startRandomTournament() {
        ConfigurationSection eventsSection = this.tournamentConfig.getConfigurationSection("MrUltimateJobs.Events");
        if (eventsSection == null) {
            return false;
        }
        Set eventKeys = eventsSection.getKeys(false);
        if (eventKeys.isEmpty()) {
            return false;
        }
        String[] eventArray = eventKeys.toArray(new String[0]);
        int randomIndex = new Random().nextInt(eventArray.length);
        int tournamentId = Integer.parseInt(eventArray[randomIndex]);
        return this.startTournament(tournamentId);
    }

    public boolean endTournament() {
        if (this.activeTournament == null) {
            return false;
        }
        if (this.tournamentTask != null) {
            this.tournamentTask.cancel();
            this.tournamentTask = null;
        }
        if (this.tournamentBossBar != null) {
            this.tournamentBossBar.removeAll();
            this.tournamentBossBar = null;
        }
        this.calculateWinners();
        this.sendTournamentMessages("End");
        this.giveParticipationRewards();
        this.deleteActiveTournament();
        this.activeTournament = null;
        this.playerData.clear();
        return true;
    }

    private void createBossBar() {
        BarStyle style;
        BarColor color;
        if (!this.activeTournament.bossbarEnabled) {
            return;
        }
        try {
            color = BarColor.valueOf((String)this.activeTournament.bossbarColor.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            color = BarColor.PINK;
        }
        try {
            style = BarStyle.valueOf((String)this.activeTournament.bossbarType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            style = BarStyle.SOLID;
        }
        String message = this.activeTournament.bossbarMessage.replace("[EndEvent]", String.valueOf(this.activeTournament.timeToEnd));
        this.tournamentBossBar = Bukkit.createBossBar((String)ColorSystem.colorize(message), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
        this.tournamentBossBar.setProgress(1.0);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.tournamentBossBar.addPlayer(player);
        }
    }

    private void startTournamentTimer() {
        this.tournamentTask = new BukkitRunnable(){
            private int timeLeft;
            private Set<Integer> progressTimes;
            {
                this.timeLeft = TournamentManager.this.activeTournament.timeToEnd * 60;
                this.progressTimes = TournamentManager.this.calculateProgressTimes();
            }

            public void run() {
                --this.timeLeft;
                if (TournamentManager.this.tournamentBossBar != null) {
                    double progress = (double)this.timeLeft / (double)(TournamentManager.this.activeTournament.timeToEnd * 60);
                    TournamentManager.this.tournamentBossBar.setProgress(Math.max(0.0, progress));
                    String message = TournamentManager.this.activeTournament.bossbarMessage.replace("[EndEvent]", String.valueOf((this.timeLeft + 59) / 60));
                    TournamentManager.this.tournamentBossBar.setTitle(ColorSystem.colorize(message));
                }
                if (this.progressTimes.contains(this.timeLeft)) {
                    TournamentManager.this.sendTournamentMessages("Progress");
                    this.progressTimes.remove(this.timeLeft);
                }
                if (this.timeLeft <= 0) {
                    TournamentManager.this.endTournament();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private Set<Integer> calculateProgressTimes() {
        HashSet<Integer> progressTimes = new HashSet<Integer>();
        String progressInfo = this.tournamentConfig.getString("MrUltimateJobs.Progress-Informations", "1:3");
        String[] parts = progressInfo.split(":");
        try {
            int intervalParts = Integer.parseInt(parts[1]);
            int totalTimeSeconds = this.activeTournament.timeToEnd * 60;
            for (int i = 1; i < intervalParts; ++i) {
                int timeRemaining = totalTimeSeconds * i / intervalParts;
                progressTimes.add(timeRemaining);
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            int totalTimeSeconds = this.activeTournament.timeToEnd * 60;
            progressTimes.add(totalTimeSeconds * 2 / 3);
            progressTimes.add(totalTimeSeconds / 3);
        }
        return progressTimes;
    }

    private void sendTournamentMessages(String messageType) {
        List<String> messages = this.activeTournament.getMessages(messageType);
        if (messages == null || messages.isEmpty()) {
            return;
        }
        List<PlayerTournamentData> topPlayers = this.getTopPlayers(3);
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerTournamentData playerStats = this.playerData.get(player.getUniqueId());
            int playerPosition = this.getPlayerPosition(player.getUniqueId());
            for (String message : messages) {
                String processedMessage = message.replace("[EndEvent]", String.valueOf(this.activeTournament.timeToEnd)).replace("[Player-Name-1]", topPlayers.size() > 0 ? topPlayers.get((int)0).playerName : "N/A").replace("[Player-Name-2]", topPlayers.size() > 1 ? topPlayers.get((int)1).playerName : "N/A").replace("[Player-Name-3]", topPlayers.size() > 2 ? topPlayers.get((int)2).playerName : "N/A").replace("[YourPosition]", String.valueOf(playerPosition));
                player.sendMessage(ColorSystem.colorize(processedMessage));
            }
        }
    }

    private void calculateWinners() {
        List<PlayerTournamentData> topPlayers = this.getTopPlayers(this.activeTournament.positions);
        for (int i = 0; i < Math.min(topPlayers.size(), this.activeTournament.positions); ++i) {
            Player player;
            PlayerTournamentData winner = topPlayers.get(i);
            int position = i + 1;
            List<String> rewards = this.activeTournament.getPositionRewards(position);
            if (rewards == null || (player = Bukkit.getPlayer((UUID)winner.playerId)) == null) continue;
            for (String reward : rewards) {
                String command = reward.replace("[PlayerName]", player.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            }
        }
    }

    private void giveParticipationRewards() {
        if (!this.activeTournament.participationRewardEnabled) {
            return;
        }
        List<String> rewards = this.activeTournament.participationRewards;
        if (rewards == null || rewards.isEmpty()) {
            return;
        }
        for (UUID playerId : this.playerData.keySet()) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null) continue;
            for (String reward : rewards) {
                String command = reward.replace("[PlayerName]", player.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            }
        }
    }

    private List<PlayerTournamentData> getTopPlayers(int count) {
        return this.playerData.values().stream().sorted((a, b) -> Integer.compare(b.getScore(this.activeTournament.type, this.activeTournament.value), a.getScore(this.activeTournament.type, this.activeTournament.value))).limit(count).collect(Collectors.toList());
    }

    private int getPlayerPosition(UUID playerId) {
        List sortedPlayers = this.playerData.values().stream().sorted((a, b) -> Integer.compare(b.getScore(this.activeTournament.type, this.activeTournament.value), a.getScore(this.activeTournament.type, this.activeTournament.value))).collect(Collectors.toList());
        for (int i = 0; i < sortedPlayers.size(); ++i) {
            if (!((PlayerTournamentData)sortedPlayers.get((int)i)).playerId.equals(playerId)) continue;
            return i + 1;
        }
        return sortedPlayers.size() + 1;
    }

    public void onJobAction(Player player, TournamentType actionType, String value, int amount) {
        if (this.activeTournament == null || this.activeTournament.type != actionType) {
            return;
        }
        PlayerTournamentData data = this.playerData.computeIfAbsent(player.getUniqueId(), k -> new PlayerTournamentData(player.getUniqueId(), player.getName()));
        switch (actionType.ordinal()) {
            case 0: {
                data.blocksMined += amount;
                break;
            }
            case 1: {
                data.blocksPlaced += amount;
                break;
            }
            case 2: {
                data.mobsKilled += amount;
                break;
            }
            case 3: {
                data.itemsCaught += amount;
                break;
            }
            case 4: {
                data.itemsEnchanted += amount;
                break;
            }
            case 5: {
                data.xpGained += amount;
                break;
            }
            case 6: {
                data.moneyEarned += amount;
            }
        }
        if (this.tournamentBossBar != null && !this.tournamentBossBar.getPlayers().contains(player)) {
            this.tournamentBossBar.addPlayer(player);
        }
    }

    public boolean isTournamentActive() {
        return this.activeTournament != null;
    }

    public List<String> getAvailableTournamentIds() {
        ArrayList<String> ids = new ArrayList<String>();
        ConfigurationSection eventsSection = this.tournamentConfig.getConfigurationSection("MrUltimateJobs.Events");
        if (eventsSection != null) {
            Set eventKeys = eventsSection.getKeys(false);
            ids.addAll(eventKeys);
        }
        return ids;
    }

    public Tournament getActiveTournament() {
        return this.activeTournament;
    }

    public void shutdown() {
        if (this.tournamentTask != null) {
            this.tournamentTask.cancel();
        }
        if (this.autoStartTask != null) {
            this.autoStartTask.cancel();
        }
        if (this.tournamentBossBar != null) {
            this.tournamentBossBar.removeAll();
            this.tournamentBossBar = null;
        }
    }

    public void addScore(Player player, double score) {
        if (this.activeTournament == null) {
            return;
        }
        PlayerTournamentData data = this.playerData.computeIfAbsent(player.getUniqueId(), k -> new PlayerTournamentData(player.getUniqueId(), player.getName()));
        switch (this.activeTournament.type.ordinal()) {
            case 5: {
                data.xpGained += (int)score;
                break;
            }
            case 6: {
                data.moneyEarned += (int)score;
                break;
            }
            case 0: {
                data.blocksMined += (int)score;
                break;
            }
            case 1: {
                data.blocksPlaced += (int)score;
                break;
            }
            case 2: {
                data.mobsKilled += (int)score;
                break;
            }
            case 3: {
                data.itemsCaught += (int)score;
                break;
            }
            case 4: {
                data.itemsEnchanted += (int)score;
            }
        }
        if (this.tournamentBossBar != null && !this.tournamentBossBar.getPlayers().contains(player)) {
            this.tournamentBossBar.addPlayer(player);
        }
    }

    public static class Tournament {
        public final int id;
        public final TournamentType type;
        public final String value;
        public final int positions;
        public final int timeToEnd;
        public final boolean bossbarEnabled;
        public final String bossbarType;
        public final String bossbarColor;
        public final String bossbarMessage;
        public final boolean participationRewardEnabled;
        public final List<String> participationRewards;
        private final ConfigurationSection config;

        public Tournament(int id, ConfigurationSection config) {
            this.id = id;
            this.config = config;
            this.type = TournamentType.valueOf(config.getString("Type", "MOSTMINED").toUpperCase());
            this.value = config.getString("Value", "");
            this.positions = config.getInt("Positions", 3);
            this.timeToEnd = config.getInt("Time-to-End", 15);
            ConfigurationSection bossbarConfig = config.getConfigurationSection("Bossbar");
            this.bossbarEnabled = bossbarConfig != null && bossbarConfig.getBoolean("Enabled", true);
            this.bossbarType = bossbarConfig != null ? bossbarConfig.getString("Type", "PROGRESS") : "PROGRESS";
            this.bossbarColor = bossbarConfig != null ? bossbarConfig.getString("Color", "PINK") : "PINK";
            this.bossbarMessage = bossbarConfig != null ? bossbarConfig.getString("Message", "") : "";
            ConfigurationSection participationConfig = config.getConfigurationSection("Participation-Reward");
            this.participationRewardEnabled = participationConfig != null && participationConfig.getBoolean("Enabled", false);
            this.participationRewards = participationConfig != null ? participationConfig.getStringList("rewards") : new ArrayList();
        }

        public List<String> getMessages(String messageType) {
            return this.config.getStringList("Messages." + messageType);
        }

        public List<String> getPositionRewards(int position) {
            return this.config.getStringList("Positions-Rewards." + position + ".rewards");
        }
    }

    public static class PlayerTournamentData {
        public final UUID playerId;
        public final String playerName;
        public int blocksMined = 0;
        public int blocksPlaced = 0;
        public int mobsKilled = 0;
        public int itemsCaught = 0;
        public int itemsEnchanted = 0;
        public int xpGained = 0;
        public int moneyEarned = 0;

        public PlayerTournamentData(UUID playerId, String playerName) {
            this.playerId = playerId;
            this.playerName = playerName;
        }

        public int getScore(TournamentType type, String value) {
            switch (type.ordinal()) {
                case 0: {
                    return this.blocksMined;
                }
                case 1: {
                    return this.blocksPlaced;
                }
                case 2: {
                    return this.mobsKilled;
                }
                case 3: {
                    return this.itemsCaught;
                }
                case 4: {
                    return this.itemsEnchanted;
                }
                case 5: {
                    return this.xpGained;
                }
                case 6: {
                    return this.moneyEarned;
                }
            }
            return 0;
        }
    }

    public static enum TournamentType {
        MOSTMINED,
        MOSTPLACED,
        MOSTKILLED,
        MOSTCAUGHT,
        MOSTENCHANTED,
        MOSTXPGAINED,
        MOSTMONEYEARNED;

    }
}

