/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class EventManager {
    private final MrUltimateJobs plugin;
    private FileConfiguration eventConfig;
    private File eventFile;
    private ActiveEvent activeEvent;
    private BukkitTask eventTask;
    private BukkitTask autoStartTask;
    private BossBar eventBossBar;

    public EventManager(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.loadConfig();
        this.loadActiveEvent();
        this.startAutoEventScheduler();
    }

    private void loadConfig() {
        this.eventFile = new File(this.plugin.getDataFolder(), "events.yml");
        this.eventConfig = YamlConfiguration.loadConfiguration((File)this.eventFile);
    }

    public void reloadConfig() {
        this.eventConfig = YamlConfiguration.loadConfiguration((File)this.eventFile);
        if (this.autoStartTask != null) {
            this.autoStartTask.cancel();
        }
        this.startAutoEventScheduler();
    }

    private void loadActiveEvent() {
        File activeEventFile = new File(this.plugin.getDataFolder(), "active-event.yml");
        if (activeEventFile.exists()) {
            YamlConfiguration activeEventConfig = YamlConfiguration.loadConfiguration((File)activeEventFile);
            int eventId = activeEventConfig.getInt("event-id", -1);
            long startTime = activeEventConfig.getLong("start-time", 0L);
            int duration = activeEventConfig.getInt("duration", 0);
            if (eventId != -1 && startTime != 0L && duration != 0) {
                long endTime;
                long currentTime = System.currentTimeMillis();
                if (currentTime < (endTime = startTime + (long)(duration * 60) * 1000L)) {
                    ConfigurationSection eventSection = this.eventConfig.getConfigurationSection("MrUltimateJobs.Events." + eventId);
                    if (eventSection != null) {
                        this.activeEvent = new ActiveEvent(eventId, eventSection);
                        this.createBossBar();
                        this.startEventTimer();
                    }
                } else {
                    activeEventFile.delete();
                }
            }
        }
    }

    private void saveActiveEvent() {
        if (this.activeEvent == null) {
            return;
        }
        File activeEventFile = new File(this.plugin.getDataFolder(), "active-event.yml");
        YamlConfiguration activeEventConfig = new YamlConfiguration();
        activeEventConfig.set("event-id", (Object)this.activeEvent.id);
        activeEventConfig.set("start-time", (Object)System.currentTimeMillis());
        activeEventConfig.set("duration", (Object)this.activeEvent.timeToEnd);
        try {
            activeEventConfig.save(activeEventFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteActiveEvent() {
        File activeEventFile = new File(this.plugin.getDataFolder(), "active-event.yml");
        if (activeEventFile.exists()) {
            activeEventFile.delete();
        }
    }

    private void startAutoEventScheduler() {
        if (!this.eventConfig.getBoolean("MrUltimateJobs.Enabled", true)) {
            return;
        }
        String timesString = this.eventConfig.getString("MrUltimateJobs.Tournaments-Starting", "");
        if (timesString.isEmpty()) {
            return;
        }
        final String[] times = timesString.split(",");
        this.autoStartTask = new BukkitRunnable(this){
            final /* synthetic */ EventManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                Calendar now = Calendar.getInstance();
                int currentHour = now.get(11);
                int currentMinute = now.get(12);
                for (String timeStr : times) {
                    try {
                        int minute;
                        String[] timeParts = timeStr.trim().split(":");
                        int hour = Integer.parseInt(timeParts[0]);
                        int n = minute = timeParts.length > 1 ? Integer.parseInt(timeParts[1]) : 0;
                        if (currentHour != hour || currentMinute != minute || this.this$0.activeEvent != null) continue;
                        this.this$0.startRandomEvent();
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1200L);
    }

    public boolean startEvent(int eventId) {
        if (this.activeEvent != null) {
            return false;
        }
        ConfigurationSection eventSection = this.eventConfig.getConfigurationSection("MrUltimateJobs.Events." + eventId);
        if (eventSection == null) {
            return false;
        }
        this.activeEvent = new ActiveEvent(eventId, eventSection);
        this.saveActiveEvent();
        this.createBossBar();
        this.sendEventMessages("Start");
        this.startEventTimer();
        return true;
    }

    public boolean startRandomEvent() {
        ConfigurationSection eventsSection = this.eventConfig.getConfigurationSection("MrUltimateJobs.Events");
        if (eventsSection == null) {
            return false;
        }
        Set eventKeys = eventsSection.getKeys(false);
        if (eventKeys.isEmpty()) {
            return false;
        }
        String[] eventArray = eventKeys.toArray(new String[0]);
        int randomIndex = new Random().nextInt(eventArray.length);
        int eventId = Integer.parseInt(eventArray[randomIndex]);
        return this.startEvent(eventId);
    }

    public boolean endEvent() {
        if (this.activeEvent == null) {
            return false;
        }
        if (this.eventTask != null) {
            this.eventTask.cancel();
            this.eventTask = null;
        }
        if (this.eventBossBar != null) {
            this.eventBossBar.removeAll();
            this.eventBossBar = null;
        }
        this.sendEventMessages("End");
        this.deleteActiveEvent();
        this.activeEvent = null;
        return true;
    }

    private void createBossBar() {
        BarStyle style;
        BarColor color;
        if (!this.activeEvent.bossbarEnabled) {
            return;
        }
        try {
            color = BarColor.valueOf((String)this.activeEvent.bossbarColor.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            color = BarColor.PINK;
        }
        try {
            style = BarStyle.valueOf((String)this.activeEvent.bossbarType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            style = BarStyle.SOLID;
        }
        String message = this.activeEvent.bossbarMessage.replace("[EndEvent]", String.valueOf(this.activeEvent.timeToEnd));
        this.eventBossBar = Bukkit.createBossBar((String)MrLibColors.colorize((String)message), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
        this.eventBossBar.setProgress(1.0);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.eventBossBar.addPlayer(player);
        }
    }

    private void startEventTimer() {
        this.eventTask = new BukkitRunnable(){
            private int timeLeft;
            {
                this.timeLeft = EventManager.this.activeEvent.timeToEnd * 60;
            }

            public void run() {
                --this.timeLeft;
                if (EventManager.this.eventBossBar != null) {
                    double progress = (double)this.timeLeft / (double)(EventManager.this.activeEvent.timeToEnd * 60);
                    EventManager.this.eventBossBar.setProgress(Math.max(0.0, progress));
                    String message = EventManager.this.activeEvent.bossbarMessage.replace("[EndEvent]", String.valueOf((this.timeLeft + 59) / 60));
                    EventManager.this.eventBossBar.setTitle(MrLibColors.colorize((String)message));
                }
                if (this.timeLeft <= 0) {
                    EventManager.this.endEvent();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void sendEventMessages(String messageType) {
        List<String> messages = this.activeEvent.getMessages(messageType);
        if (messages == null || messages.isEmpty()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (String message : messages) {
                String processedMessage = message.replace("[EndEvent]", String.valueOf(this.activeEvent.timeToEnd));
                this.plugin.sendMessage(player, processedMessage);
            }
        }
    }

    public boolean isEventActive() {
        return this.activeEvent != null;
    }

    public List<String> getAvailableEventIds() {
        ArrayList<String> ids = new ArrayList<String>();
        ConfigurationSection eventsSection = this.eventConfig.getConfigurationSection("MrUltimateJobs.Events");
        if (eventsSection != null) {
            Set eventKeys = eventsSection.getKeys(false);
            ids.addAll(eventKeys);
        }
        return ids;
    }

    public ActiveEvent getActiveEvent() {
        return this.activeEvent;
    }

    public void shutdown() {
        if (this.eventTask != null) {
            this.eventTask.cancel();
        }
        if (this.autoStartTask != null) {
            this.autoStartTask.cancel();
        }
        if (this.eventBossBar != null) {
            this.eventBossBar.removeAll();
            this.eventBossBar = null;
        }
    }

    public double getXPMultiplier() {
        if (this.activeEvent == null || this.activeEvent.type != EventType.XPBOOST) {
            return 1.0;
        }
        return this.activeEvent.getMultiplier();
    }

    public double getMoneyMultiplier() {
        if (this.activeEvent == null || this.activeEvent.type != EventType.MONEYBOOST) {
            return 1.0;
        }
        return this.activeEvent.getMultiplier();
    }

    public static class ActiveEvent {
        public final int id;
        public final EventType type;
        public final double value;
        public final int timeToEnd;
        public final boolean bossbarEnabled;
        public final String bossbarType;
        public final String bossbarColor;
        public final String bossbarMessage;
        private final ConfigurationSection config;

        public ActiveEvent(int id, ConfigurationSection config) {
            this.id = id;
            this.config = config;
            this.type = EventType.valueOf(config.getString("Type", "XPBOOST").toUpperCase());
            this.value = Double.parseDouble(config.getString("Value", "1.0"));
            this.timeToEnd = config.getInt("Time-to-End", 15);
            ConfigurationSection bossbarConfig = config.getConfigurationSection("Bossbar");
            this.bossbarEnabled = bossbarConfig != null && bossbarConfig.getBoolean("Enabled", true);
            this.bossbarType = bossbarConfig != null ? bossbarConfig.getString("Type", "PROGRESS") : "PROGRESS";
            this.bossbarColor = bossbarConfig != null ? bossbarConfig.getString("Color", "PINK") : "PINK";
            this.bossbarMessage = bossbarConfig != null ? bossbarConfig.getString("Message", "") : "";
        }

        public List<String> getMessages(String messageType) {
            return this.config.getStringList("Messages." + messageType);
        }

        public double getMultiplier() {
            return this.value;
        }
    }

    public static enum EventType {
        XPBOOST,
        MONEYBOOST,
        LEVELBOOST;

    }
}

