/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.managers;

import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import eu.mrneznamy.mrultimatejobs.events.JobLevelUpEvent;
import eu.mrneznamy.mrultimatejobs.events.JobMoneyEarnedEvent;
import eu.mrneznamy.mrultimatejobs.listeners.JobListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class PlayerJobManager {
    private final MrUltimateJobs plugin;
    private final Map<UUID, Set<String>> activeJobs;
    private final Map<UUID, Map<String, Integer>> jobLevels;
    private final Map<UUID, Map<String, Double>> jobXP;
    private final Map<UUID, Map<String, Double>> jobMoney;

    public PlayerJobManager(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.activeJobs = new HashMap<UUID, Set<String>>();
        this.jobLevels = new HashMap<UUID, Map<String, Integer>>();
        this.jobXP = new HashMap<UUID, Map<String, Double>>();
        this.jobMoney = new HashMap<UUID, Map<String, Double>>();
    }

    public Set<String> getActiveJobs(Player player) {
        return new HashSet<String>(this.activeJobs.getOrDefault(player.getUniqueId(), Collections.emptySet()));
    }

    public void addJob(Player player, String jobName) {
        UUID uuid = player.getUniqueId();
        this.activeJobs.computeIfAbsent(uuid, k -> new HashSet()).add(jobName.toLowerCase());
        this.plugin.getPlayerDataManager().loadPlayerData(player);
        FileConfiguration data = this.plugin.getPlayerDataManager().getPlayerData(uuid);
        int savedLevel = 1;
        double savedXP = 0.0;
        double savedMoney = 0.0;
        if (data != null) {
            savedLevel = data.getInt("jobs." + jobName.toLowerCase() + ".level", 1);
            savedXP = data.getDouble("jobs." + jobName.toLowerCase() + ".xp", 0.0);
            savedMoney = data.getDouble("jobs." + jobName.toLowerCase() + ".moneyEarned", 0.0);
        }
        this.jobLevels.computeIfAbsent(uuid, k -> new HashMap()).put(jobName.toLowerCase(), savedLevel);
        this.jobXP.computeIfAbsent(uuid, k -> new HashMap()).put(jobName.toLowerCase(), savedXP);
        this.jobMoney.computeIfAbsent(uuid, k -> new HashMap()).put(jobName.toLowerCase(), savedMoney);
        this.plugin.getPlayerDataManager().setPlayerJobStats(player, jobName, savedLevel, savedXP, savedMoney);
        this.plugin.getPlayerDataManager().addActiveJob(player, jobName);
    }

    public void removePlayerJob(Player player, String jobName) {
        Map<String, Double> mo;
        Map<String, Double> xp;
        Map<String, Integer> lv;
        UUID uuid = player.getUniqueId();
        Set<String> set = this.activeJobs.get(uuid);
        if (set != null) {
            set.remove(jobName.toLowerCase());
            if (set.isEmpty()) {
                this.activeJobs.remove(uuid);
            }
        }
        if ((lv = this.jobLevels.get(uuid)) != null) {
            lv.remove(jobName.toLowerCase());
            if (lv.isEmpty()) {
                this.jobLevels.remove(uuid);
            }
        }
        if ((xp = this.jobXP.get(uuid)) != null) {
            xp.remove(jobName.toLowerCase());
            if (xp.isEmpty()) {
                this.jobXP.remove(uuid);
            }
        }
        if ((mo = this.jobMoney.get(uuid)) != null) {
            mo.remove(jobName.toLowerCase());
            if (mo.isEmpty()) {
                this.jobMoney.remove(uuid);
            }
        }
        this.plugin.getPlayerDataManager().removeActiveJob(player, jobName);
    }

    public void restorePlayerJobFromData(Player player) {
        List<String> legacy;
        this.plugin.getPlayerDataManager().loadPlayerData(player);
        FileConfiguration data = this.plugin.getPlayerDataManager().getPlayerData(player.getUniqueId());
        if (data == null) {
            return;
        }
        List<String> active = this.plugin.getPlayerDataManager().getActiveJobs(player.getUniqueId());
        if (active != null && !active.isEmpty()) {
            for (String j : active) {
                this.addJob(player, j);
            }
            return;
        }
        String currentJob = data.getString("current-job");
        if (currentJob != null && !currentJob.isEmpty()) {
            this.addJob(player, currentJob);
        }
        if ((legacy = this.plugin.getPlayerDataManager().getCurrentJobs(player.getUniqueId())) != null && !legacy.isEmpty()) {
            for (String j : legacy) {
                this.addJob(player, j);
            }
        }
        if (data.isConfigurationSection("jobs")) {
            Set keys = data.getConfigurationSection("jobs").getKeys(false);
            for (String k : keys) {
                this.addJob(player, k);
            }
        }
    }

    public boolean isPlayerInJob(Player player, String jobName) {
        return this.activeJobs.getOrDefault(player.getUniqueId(), Collections.emptySet()).contains(jobName.toLowerCase());
    }

    public int getPlayerJobLevel(Player player, String jobName) {
        return this.jobLevels.getOrDefault(player.getUniqueId(), Collections.emptyMap()).getOrDefault(jobName.toLowerCase(), 1);
    }

    public void setPlayerJobLevel(Player player, int level) {
        UUID uuid = player.getUniqueId();
        String firstJob = this.getActiveJobs(player).stream().findFirst().orElse(null);
        if (firstJob != null) {
            this.jobLevels.computeIfAbsent(uuid, k -> new HashMap()).put(firstJob.toLowerCase(), level);
            double xp = this.getPlayerJobXP(player, firstJob);
            double money = this.getPlayerMoneyEarned(player, firstJob);
            this.plugin.getPlayerDataManager().setPlayerJobStats(player, firstJob, level, xp, money);
        }
    }

    public void setPlayerJobLevel(Player player, String jobName, int level) {
        if (jobName == null || jobName.isEmpty()) {
            return;
        }
        UUID uuid = player.getUniqueId();
        this.jobLevels.computeIfAbsent(uuid, k -> new HashMap()).put(jobName.toLowerCase(), level);
        double xp = this.getPlayerJobXP(player, jobName);
        double money = this.getPlayerMoneyEarned(player, jobName);
        this.plugin.getPlayerDataManager().setPlayerJobStats(player, jobName, level, xp, money);
    }

    public double getPlayerJobXP(Player player, String jobName) {
        return this.jobXP.getOrDefault(player.getUniqueId(), Collections.emptyMap()).getOrDefault(jobName.toLowerCase(), 0.0);
    }

    public void addPlayerJobXP(Player player, String jobName, double xp) {
        int maxLevel;
        UUID uuid = player.getUniqueId();
        int currentLevel = this.getPlayerJobLevel(player, jobName);
        if (currentLevel >= (maxLevel = this.getMaxLevelForJob(jobName))) {
            return;
        }
        double currentXP = this.getPlayerJobXP(player, jobName);
        double newXP = currentXP + xp;
        this.jobXP.computeIfAbsent(uuid, k -> new HashMap()).put(jobName.toLowerCase(), newXP);
        this.checkForLevelUp(player, jobName, newXP);
        int level = this.getPlayerJobLevel(player, jobName);
        double money = this.getPlayerMoneyEarned(player, jobName);
        this.plugin.getPlayerDataManager().setPlayerJobStats(player, jobName, level, newXP, money);
    }

    public double getPlayerMoneyEarned(Player player, String jobName) {
        return this.jobMoney.getOrDefault(player.getUniqueId(), Collections.emptyMap()).getOrDefault(jobName.toLowerCase(), 0.0);
    }

    public int getMaxLevelForJob(String jobName) {
        FileConfiguration jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
        if (jobConfig == null) {
            return 1;
        }
        ConfigurationSection levelsSection = jobConfig.getConfigurationSection("MrUltimateJobs.Job.System.Levels");
        if (levelsSection == null) {
            return 1;
        }
        int maxLevel = 1;
        for (String levelStr : levelsSection.getKeys(false)) {
            try {
                int level = Integer.parseInt(levelStr);
                if (level <= maxLevel) continue;
                maxLevel = level;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maxLevel;
    }

    public void addPlayerMoneyEarned(Player player, String jobName, double money) {
        UUID uuid = player.getUniqueId();
        double currentMoney = this.getPlayerMoneyEarned(player, jobName);
        double newMoney = currentMoney + money;
        this.jobMoney.computeIfAbsent(uuid, k -> new HashMap()).put(jobName.toLowerCase(), newMoney);
        int level = this.getPlayerJobLevel(player, jobName);
        double xp = this.getPlayerJobXP(player, jobName);
        this.plugin.getPlayerDataManager().setPlayerJobStats(player, jobName, level, xp, newMoney);
        this.plugin.getPlayerDataManager().addPlayerMoneyEarned(player, jobName, money);
        try {
            this.plugin.getServer().getPluginManager().callEvent((Event)new JobMoneyEarnedEvent(player, jobName, money));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean hasJob(Player player) {
        return !this.activeJobs.getOrDefault(player.getUniqueId(), Collections.emptySet()).isEmpty();
    }

    public int getMaxJobsForPlayer(Player player) {
        int maxJobs = 1;
        for (PermissionAttachmentInfo permissionInfo : player.getEffectivePermissions()) {
            String permission = permissionInfo.getPermission();
            if (!permission.startsWith("mrultimatejobs.maxjobs.")) continue;
            try {
                String numberPart = permission.substring("mrultimatejobs.maxjobs.".length());
                int jobsAllowed = Integer.parseInt(numberPart);
                if (jobsAllowed <= maxJobs) continue;
                maxJobs = jobsAllowed;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maxJobs;
    }

    public int getPlayerJobCount(Player player) {
        return this.activeJobs.getOrDefault(player.getUniqueId(), Collections.emptySet()).size();
    }

    public boolean canJoinAnotherJob(Player player) {
        int maxJobs = this.getMaxJobsForPlayer(player);
        int currentJobs = this.getPlayerJobCount(player);
        return currentJobs < maxJobs;
    }

    public int getEmployedCount(String jobName) {
        int count = 0;
        for (Set<String> set : this.activeJobs.values()) {
            if (!set.stream().anyMatch(j -> j.equalsIgnoreCase(jobName))) continue;
            ++count;
        }
        return count;
    }

    public String getPlayerJob(UUID playerUUID) {
        return this.activeJobs.getOrDefault(playerUUID, Collections.emptySet()).stream().findFirst().orElse(null);
    }

    public int getPlayerJobLevel(UUID playerUUID) {
        Map map = this.jobLevels.getOrDefault(playerUUID, Collections.emptyMap());
        return map.values().stream().findFirst().orElse(1);
    }

    public double getPlayerMoneyEarned(UUID playerUUID) {
        Map map = this.jobMoney.getOrDefault(playerUUID, Collections.emptyMap());
        return map.values().stream().findFirst().orElse(0.0);
    }

    private void checkForLevelUp(Player player, String jobName, double currentXP) {
        int currentLevel = this.getPlayerJobLevel(player, jobName);
        int nextLevel = currentLevel + 1;
        double xpRequired = this.plugin.getJobManager().getJobConfig(jobName).getDouble("MrUltimateJobs.Job.System.Levels." + nextLevel, -1.0);
        if (xpRequired > 0.0 && currentXP >= xpRequired) {
            this.setPlayerJobLevel(player, jobName, nextLevel);
            try {
                this.plugin.getServer().getPluginManager().callEvent((Event)new JobLevelUpEvent(player, jobName, nextLevel));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            UUID uuid = player.getUniqueId();
            this.jobXP.computeIfAbsent(uuid, k -> new HashMap()).put(jobName.toLowerCase(), 0.0);
            this.sendLevelUpMessage(player, jobName, nextLevel);
            this.giveLevelUpRewards(player, jobName, nextLevel);
            this.resetAccumulatedValues(player);
            if (jobName != null) {
                int level = this.getPlayerJobLevel(player, jobName);
                double money = this.getPlayerMoneyEarned(player, jobName);
                this.plugin.getPlayerDataManager().setPlayerJobStats(player, jobName, level, 0.0, money);
            }
        }
    }

    private void giveLevelUpRewards(Player player, String jobName, int level) {
        try {
            FileConfiguration jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
            if (jobConfig == null) {
                return;
            }
            List allLevelsRewards = jobConfig.getStringList("MrUltimateJobs.Job.System.Levels-Rewards.ALL-Levels");
            for (String command : allLevelsRewards) {
                this.executeRewardCommand(player, command);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void executeRewardCommand(Player player, String command) {
        if (command == null || command.trim().isEmpty()) {
            return;
        }
        String processedCommand = command.replace("[PlayerName]", player.getName());
        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), processedCommand);
    }

    private void sendLevelUpMessage(Player player, String jobName, int level) {
        FileConfiguration jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
        if (jobConfig == null) {
            return;
        }
        List messages = jobConfig.getStringList("MrUltimateJobs.Job.System.LevelUP-Message");
        if (messages.isEmpty()) {
            String message = this.plugin.getMessageManager().getMessage("jobs.level-up", "Level", String.valueOf(level), "Job", jobName);
            this.plugin.sendMessage(player, message);
            return;
        }
        double moneyPerSet = 0.0;
        int actionsRequired = 0;
        try {
            String moneyFormula = jobConfig.getString("MrUltimateJobs.Job.System.Actions.Money.Money", "0");
            String requiredFormula = jobConfig.getString("MrUltimateJobs.Job.System.Actions.Money.Required", "0");
            moneyPerSet = this.evaluateExpression(moneyFormula, level);
            actionsRequired = (int)Math.floor(this.evaluateExpression(requiredFormula, level));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String message : messages) {
            String processedMessage = message.replace("[Level]", String.valueOf(level)).replace("[Job]", jobName).replace("[PlayerName]", player.getName()).replace("[Money]", String.format("%.2f", moneyPerSet)).replace("[ActionRequired]", String.valueOf(actionsRequired));
            this.plugin.sendMessage(player, processedMessage);
        }
    }

    private void resetAccumulatedValues(Player player) {
        JobListener jobListener = this.plugin.getJobListener();
        if (jobListener != null) {
            jobListener.resetPlayerAccumulatedValues(player);
        }
    }

    private double evaluateExpression(String expression, int level) {
        if (expression == null || expression.trim().isEmpty()) {
            return 0.0;
        }
        String processed = expression.replace("[Level]", String.valueOf(level)).replaceAll("\\s+", "");
        return this.evaluateSimpleMath(processed);
    }

    private double evaluateSimpleMath(String expr) {
        double result;
        double right;
        double left;
        int rightEnd;
        int leftStart;
        int operator;
        int opIndex;
        Object expression = expr;
        while (((String)expression).contains("*") || ((String)expression).contains("/")) {
            int multIndex = ((String)expression).indexOf("*");
            int divIndex = ((String)expression).indexOf("/");
            if (multIndex != -1 && divIndex != -1) {
                opIndex = Math.min(multIndex, divIndex);
                operator = ((String)expression).charAt(opIndex);
            } else if (multIndex != -1) {
                opIndex = multIndex;
                operator = 42;
            } else {
                opIndex = divIndex;
                operator = 47;
            }
            leftStart = this.findNumberStart((String)expression, opIndex - 1);
            rightEnd = this.findNumberEnd((String)expression, opIndex + 1);
            left = Double.parseDouble(((String)expression).substring(leftStart, opIndex));
            right = Double.parseDouble(((String)expression).substring(opIndex + 1, rightEnd + 1));
            result = operator == 42 ? left * right : left / right;
            expression = ((String)expression).substring(0, leftStart) + result + ((String)expression).substring(rightEnd + 1);
        }
        while (((String)expression).contains("+") || ((String)expression).contains("-") && ((String)expression).indexOf("-") > 0) {
            int addIndex = ((String)expression).indexOf("+");
            int subIndex = ((String)expression).indexOf("-", 1);
            if (addIndex != -1 && subIndex != -1) {
                opIndex = Math.min(addIndex, subIndex);
                operator = ((String)expression).charAt(opIndex);
            } else if (addIndex != -1) {
                opIndex = addIndex;
                operator = 43;
            } else {
                opIndex = subIndex;
                operator = 45;
            }
            leftStart = this.findNumberStart((String)expression, opIndex - 1);
            rightEnd = this.findNumberEnd((String)expression, opIndex + 1);
            left = Double.parseDouble(((String)expression).substring(leftStart, opIndex));
            right = Double.parseDouble(((String)expression).substring(opIndex + 1, rightEnd + 1));
            result = operator == 43 ? left + right : left - right;
            expression = ((String)expression).substring(0, leftStart) + result + ((String)expression).substring(rightEnd + 1);
        }
        return Double.parseDouble((String)expression);
    }

    private int findNumberStart(String expression, int startIndex) {
        int index;
        for (index = startIndex; index >= 0 && (Character.isDigit(expression.charAt(index)) || expression.charAt(index) == '.'); --index) {
        }
        if (!(index < 0 || expression.charAt(index) != '-' || index != 0 && Character.isDigit(expression.charAt(index - 1)))) {
            --index;
        }
        return index + 1;
    }

    private int findNumberEnd(String expression, int startIndex) {
        int index;
        for (index = startIndex; index < expression.length() && (Character.isDigit(expression.charAt(index)) || expression.charAt(index) == '.'); ++index) {
        }
        return index - 1;
    }
}

