/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.commands;

import eu.mrneznamy.mrlibcore.utils.MrLibHelper;
import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import eu.mrneznamy.mrultimatejobs.menus.MenuManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class JobsCommand
implements CommandExecutor,
TabCompleter {
    private final MrUltimateJobs plugin;

    public JobsCommand(MrUltimateJobs plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (sender instanceof Player) {
                this.openJobsMenu((Player)sender);
                return true;
            }
            this.plugin.getMessageManager().sendMessage(sender, "general.player-only-command");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "help": {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (args.length == 1) {
                        MrLibHelper.showRegisteredPlugins((Player)player);
                    } else if (args.length == 2) {
                        MrLibHelper.showPluginHelp((Player)player, (String)args[1], (int)1);
                    } else if (args.length == 3) {
                        try {
                            int page = Integer.parseInt(args[2]);
                            MrLibHelper.showPluginHelp((Player)player, (String)args[1], (int)page);
                        }
                        catch (NumberFormatException e) {
                            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("general.no-permission"));
                        }
                    }
                } else {
                    sender.sendMessage("Use /jobs help in-game to see available commands");
                }
                return true;
            }
            case "list": {
                this.listJobs(sender);
                return true;
            }
            case "join": {
                if (sender instanceof Player) {
                    this.handleJoinCommand((Player)sender, args);
                } else {
                    this.plugin.getMessageManager().sendMessage(sender, "general.player-only-command");
                }
                return true;
            }
            case "leave": {
                if (sender instanceof Player) {
                    this.handleLeaveCommand((Player)sender, args);
                } else {
                    this.plugin.getMessageManager().sendMessage(sender, "general.player-only-command");
                }
                return true;
            }
            case "rewards": {
                if (sender instanceof Player) {
                    this.handleRewardsCommand((Player)sender, args);
                } else {
                    this.plugin.getMessageManager().sendMessage(sender, "general.player-only-command");
                }
                return true;
            }
            case "claim": {
                if (sender instanceof Player) {
                    this.handleClaimCommand((Player)sender, args);
                } else {
                    this.plugin.getMessageManager().sendMessage(sender, "general.player-only-command");
                }
                return true;
            }
            case "top": {
                if (sender instanceof Player) {
                    this.handleTopCommand((Player)sender, args);
                } else {
                    this.plugin.getMessageManager().sendMessage(sender, "general.player-only-command");
                }
                return true;
            }
            case "reload": {
                if (sender.hasPermission("mrultimatejobs.admin")) {
                    this.plugin.getJobManager().reloadJobs();
                    this.plugin.getMessageManager().sendMessage(sender, "general.jobs-reloaded");
                } else {
                    this.plugin.getMessageManager().sendMessage(sender, "general.no-permission");
                }
                return true;
            }
        }
        this.plugin.getMessageManager().sendMessage(sender, "general.invalid-command");
        return true;
    }

    private void handleJoinCommand(Player player, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.usage-join");
            return;
        }
        String jobName = args[1];
        if (!player.hasPermission("mrultimatejobs.jobs.join") && !player.hasPermission("mrultimatejobs.admin")) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.no-permission");
            return;
        }
        if (!(player.hasPermission("mrultimatejobs.jobs.join.*") || player.hasPermission("mrultimatejobs.admin") || player.hasPermission("mrultimatejobs.jobs.join." + jobName.toLowerCase()))) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.no-permission");
            return;
        }
        if (this.plugin.getJobManager().getJobConfig(jobName) == null) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.job-not-found", "Job", jobName);
            return;
        }
        if (this.plugin.getPlayerJobManager().isPlayerInJob(player, jobName)) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.already-in-job", "Job", jobName);
            return;
        }
        if (!this.plugin.getPlayerJobManager().canJoinAnotherJob(player)) {
            int maxJobs = this.plugin.getPlayerJobManager().getMaxJobsForPlayer(player);
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.max-jobs-reached", "Max", String.valueOf(maxJobs));
            return;
        }
        this.plugin.getPlayerJobManager().addJob(player, jobName);
        this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.join-job", "Job", jobName);
    }

    private void handleLeaveCommand(Player player, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.usage-leave");
            return;
        }
        String jobName = args[1];
        if (!player.hasPermission("mrultimatejobs.jobs.leave") && !player.hasPermission("mrultimatejobs.admin")) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.no-permission");
            return;
        }
        if (!(player.hasPermission("mrultimatejobs.jobs.leave.*") || player.hasPermission("mrultimatejobs.admin") || player.hasPermission("mrultimatejobs.jobs.leave." + jobName.toLowerCase()))) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.no-permission");
            return;
        }
        if (!this.plugin.getPlayerJobManager().isPlayerInJob(player, jobName)) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.not-in-job", "Job", jobName);
            return;
        }
        this.plugin.getPlayerJobManager().removePlayerJob(player, jobName);
        this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.leave-job", "Job", jobName);
    }

    private void handleRewardsCommand(Player player, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.usage-rewards");
            return;
        }
        String jobName = args[1];
        if (this.plugin.getJobManager().getJobConfig(jobName) == null) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.job-not-found", "Job", jobName);
            return;
        }
        MenuManager menuManager = this.plugin.getMenuManager();
        menuManager.openRewardsMenu(player, jobName);
    }

    private void openJobsMenu(Player player) {
        MenuManager menuManager = this.plugin.getMenuManager();
        menuManager.openHeadMenu(player);
    }

    private void listJobs(CommandSender sender) {
        this.plugin.getMessageManager().sendMessage(sender, "jobs.header");
        if (this.plugin.getJobManager().getJobCount() == 0) {
            this.plugin.getMessageManager().sendMessage(sender, "jobs.no-jobs");
        } else {
            for (String jobName : this.plugin.getJobManager().getJobNames()) {
                FileConfiguration jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
                String jobDisplayName = jobName;
                String jobDescription = jobName;
                if (jobConfig != null) {
                    jobDisplayName = jobConfig.getString("MrUltimateJobs.Job.Name", jobName);
                    jobDescription = jobDisplayName.replaceAll("&[0-9a-fA-F]", "").replaceAll("\u00a7[0-9a-fA-F]", "");
                }
                this.plugin.getMessageManager().sendMessage(sender, "jobs.job-entry", "Job", jobName, "Description", jobDisplayName);
            }
        }
    }

    private void handleClaimCommand(Player player, String[] args) {
        String rewardsPath;
        int level;
        if (!player.hasPermission("mrultimatejobs.rewards.claim")) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.no-permission");
            return;
        }
        if (args.length < 3) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.usage-claim");
            return;
        }
        String jobName = args[1];
        String levelStr = args[2];
        if (this.plugin.getJobManager().getJobConfig(jobName) == null) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.job-not-found", "Job", jobName);
            return;
        }
        try {
            level = Integer.parseInt(levelStr);
        }
        catch (NumberFormatException e) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.invalid-level");
            return;
        }
        if (!this.plugin.getPlayerJobManager().isPlayerInJob(player, jobName)) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("jobs.not-in-job", "Job", jobName));
            return;
        }
        int playerLevel = this.plugin.getPlayerJobManager().getPlayerJobLevel(player, jobName);
        if (playerLevel < level) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.level-too-low", "Level", String.valueOf(level), "PlayerLevel", String.valueOf(playerLevel));
            return;
        }
        if (this.plugin.getPlayerDataManager().isRewardClaimed(player, jobName, level)) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.reward-already-claimed", "Level", String.valueOf(level));
            return;
        }
        FileConfiguration jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
        if (!jobConfig.contains((rewardsPath = "MrUltimateJobs.Job.System.Levels-Rewards." + level) + ".Commands")) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.no-reward-for-level", "Level", String.valueOf(level));
            return;
        }
        List commands = jobConfig.getStringList(rewardsPath + ".Commands");
        for (String command : commands) {
            if (command == null || command.trim().isEmpty()) continue;
            String processedCommand = command.replace("[PlayerName]", player.getName());
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), processedCommand);
        }
        this.plugin.getPlayerDataManager().setRewardClaimed(player, jobName, level);
        this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.reward-claimed", "Level", String.valueOf(level), "Job", jobName);
    }

    private void handleTopCommand(Player player, String[] args) {
        if (!player.hasPermission("mrultimatejobs.top")) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.no-permission");
            return;
        }
        String jobName = "All";
        if (args.length >= 2 && !(jobName = args[1]).equalsIgnoreCase("All") && this.plugin.getJobManager().getJobConfig(jobName) == null) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.job-not-found", "Job", jobName);
            return;
        }
        MenuManager menuManager = this.plugin.getMenuManager();
        menuManager.openTopMenu(player, jobName);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.asList("help", "list", "join", "leave", "rewards", "claim", "top"));
            if (sender.hasPermission("mrultimatejobs.admin")) {
                completions.add("reload");
            }
            return this.filterCompletions(completions, args[0]);
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("join") || args[0].equalsIgnoreCase("leave") || args[0].equalsIgnoreCase("rewards") || args[0].equalsIgnoreCase("claim") || args[0].equalsIgnoreCase("top"))) {
            ArrayList<String> jobNames = new ArrayList<String>(this.plugin.getJobManager().getJobNames());
            if (args[0].equalsIgnoreCase("top")) {
                jobNames.add(0, "All");
            }
            return this.filterCompletions(jobNames, args[1]);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("claim")) {
            String jobName = args[1];
            if (this.plugin.getJobManager().getJobConfig(jobName) != null && sender instanceof Player) {
                Player player = (Player)sender;
                int playerLevel = this.plugin.getPlayerJobManager().getPlayerJobLevel(player, jobName);
                ArrayList<String> levels = new ArrayList<String>();
                for (int i = 1; i <= playerLevel; ++i) {
                    levels.add(String.valueOf(i));
                }
                return this.filterCompletions(levels, args[2]);
            }
        }
        return Collections.emptyList();
    }

    private List<String> filterCompletions(List<String> completions, String arg) {
        ArrayList<String> result = new ArrayList<String>();
        for (String completion : completions) {
            if (!completion.toLowerCase().startsWith(arg.toLowerCase())) continue;
            result.add(completion);
        }
        return result;
    }
}

