/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.commands;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MUJCommand
implements CommandExecutor,
TabCompleter {
    private final MrUltimateJobs plugin;

    public MUJCommand(MrUltimateJobs plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "help": {
                this.sendHelp(sender);
                return true;
            }
            case "reload": {
                if (sender.hasPermission("mrultimatejobs.reload")) {
                    this.plugin.reload();
                    this.plugin.getMessageManager().sendMessage(sender, "general.config-reloaded");
                } else {
                    this.plugin.getMessageManager().sendMessage(sender, "general.no-permission");
                }
                return true;
            }
            case "give": {
                if (sender.hasPermission("mrultimatejobs.give")) {
                    this.handleGiveCommand(sender, args);
                } else {
                    this.plugin.getMessageManager().sendMessage(sender, "general.no-permission");
                }
                return true;
            }
            case "tournament": {
                if (sender.hasPermission("mrultimatejobs.tournament")) {
                    this.handleTournamentCommand(sender, args);
                } else {
                    this.plugin.getMessageManager().sendMessage(sender, "general.no-permission");
                }
                return true;
            }
            case "event": {
                if (sender.hasPermission("mrultimatejobs.tournament")) {
                    this.handleEventCommand(sender, args);
                } else {
                    this.plugin.getMessageManager().sendMessage(sender, "general.no-permission");
                }
                return true;
            }
        }
        this.plugin.getMessageManager().sendMessage(sender, "general.invalid-command");
        return true;
    }

    private void sendHelp(CommandSender sender) {
        this.plugin.getMessageManager().sendMessage(sender, "muj.header");
        this.plugin.getMessageManager().sendMessage(sender, "muj.help");
        this.plugin.getMessageManager().sendMessage(sender, "muj.reload");
        this.plugin.getMessageManager().sendMessage(sender, "muj.give");
        this.plugin.getMessageManager().sendMessage(sender, "muj.tournament");
        this.plugin.getMessageManager().sendMessage(sender, "muj.event");
    }

    private void handleGiveCommand(CommandSender sender, String[] args) {
        String type;
        if (args.length < 3) {
            this.plugin.getMessageManager().sendMessage(sender, "muj.usage-give");
            return;
        }
        switch (type = args[1].toLowerCase()) {
            case "xp": 
            case "level": {
                int amountLvl;
                if (args.length < 5) {
                    this.plugin.getMessageManager().sendMessage(sender, "muj.usage-give");
                    return;
                }
                String jobInput = args[2];
                String playerName = args[3];
                String amountStr = args[4];
                String jobKey = this.resolveJobKey(jobInput);
                if (jobKey == null) {
                    this.plugin.getMessageManager().sendMessage(sender, "general.job-not-found", "Job", jobInput);
                    return;
                }
                Player targetPlayer = this.plugin.getServer().getPlayerExact(playerName);
                if (targetPlayer == null) {
                    this.plugin.getMessageManager().sendMessage(sender, "muj.player-not-found", "PlayerName", playerName);
                    return;
                }
                if (type.equals("xp")) {
                    double amountXp;
                    try {
                        amountXp = Double.parseDouble(amountStr);
                    }
                    catch (NumberFormatException e) {
                        this.plugin.getMessageManager().sendMessage(sender, "muj.invalid-amount", "Amount", amountStr);
                        return;
                    }
                    if (!this.plugin.getPlayerJobManager().isPlayerInJob(targetPlayer, jobKey)) {
                        this.plugin.getPlayerJobManager().addJob(targetPlayer, jobKey);
                    }
                    this.plugin.getPlayerJobManager().addPlayerJobXP(targetPlayer, jobKey, amountXp);
                    this.plugin.getMessageManager().sendMessage(sender, "muj.give-xp-success", "PlayerName", targetPlayer.getName(), "Amount", String.valueOf(amountXp));
                    break;
                }
                try {
                    amountLvl = Integer.parseInt(amountStr);
                }
                catch (NumberFormatException e) {
                    this.plugin.getMessageManager().sendMessage(sender, "muj.invalid-amount", "Amount", amountStr);
                    return;
                }
                if (!this.plugin.getPlayerJobManager().isPlayerInJob(targetPlayer, jobKey)) {
                    this.plugin.getPlayerJobManager().addJob(targetPlayer, jobKey);
                }
                int currentLevel = this.plugin.getPlayerJobManager().getPlayerJobLevel(targetPlayer, jobKey);
                this.plugin.getPlayerJobManager().setPlayerJobLevel(targetPlayer, jobKey, currentLevel + amountLvl);
                this.plugin.getMessageManager().sendMessage(sender, "muj.give-level-success", "PlayerName", targetPlayer.getName(), "Amount", String.valueOf(amountLvl));
                break;
            }
            case "booster": {
                int amount;
                if (args.length < 5) {
                    this.plugin.getMessageManager().sendMessage(sender, "muj.usage-give-booster");
                    return;
                }
                String amountStrBooster = args[2];
                String boosterPlayerName = args[3];
                String boosterIdStr = args[4];
                try {
                    amount = Integer.parseInt(amountStrBooster);
                }
                catch (NumberFormatException e) {
                    this.plugin.getMessageManager().sendMessage(sender, "muj.invalid-amount", "Amount", amountStrBooster);
                    return;
                }
                Player boosterTarget = this.plugin.getServer().getPlayerExact(boosterPlayerName);
                if (boosterTarget == null) {
                    this.plugin.getMessageManager().sendMessage(sender, "muj.player-not-found", "PlayerName", boosterPlayerName);
                    return;
                }
                try {
                    int boosterId = Integer.parseInt(boosterIdStr);
                    ItemStack boosterItem = this.plugin.getBoosterManager().createBoosterItem(boosterId);
                    if (boosterItem != null) {
                        boosterItem.setAmount(amount);
                        boosterTarget.getInventory().addItem(new ItemStack[]{boosterItem});
                        this.plugin.getMessageManager().sendMessage(sender, "muj.give-booster-success", "PlayerName", boosterTarget.getName(), "Amount", String.valueOf(amount));
                        break;
                    }
                    this.plugin.getMessageManager().sendMessage(sender, "muj.booster-creation-failed");
                }
                catch (NumberFormatException e) {
                    this.plugin.getMessageManager().sendMessage(sender, "muj.invalid-booster-type", "Type", boosterIdStr);
                }
                break;
            }
            default: {
                this.plugin.getMessageManager().sendMessage(sender, "muj.invalid-give-type", "Type", type);
            }
        }
    }

    private String resolveJobKey(String input) {
        String needle = MrLibColors.stripColor((String)input).trim();
        for (String jobKey : this.plugin.getJobManager().getJobNames()) {
            if (jobKey.equalsIgnoreCase(needle)) {
                return jobKey;
            }
            try {
                FileConfiguration cfg = this.plugin.getJobManager().getJobConfig(jobKey);
                String jobConfigName = cfg.getString("MrUltimateJobs.Job.JobConfigName", jobKey);
                String displayName = MrLibColors.stripColor((String)cfg.getString("MrUltimateJobs.Job.Name", jobKey));
                if (jobConfigName != null && jobConfigName.equalsIgnoreCase(needle)) {
                    return jobKey;
                }
                if (displayName == null || !displayName.equalsIgnoreCase(needle)) continue;
                return jobKey;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    private void handleTournamentCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessageManager().sendMessage(sender, "muj.usage-tournament");
            return;
        }
        switch (args[1].toLowerCase()) {
            case "start": {
                if (args.length < 3) {
                    if (this.plugin.getTournamentManager().startRandomTournament()) {
                        this.plugin.getMessageManager().sendMessage(sender, "tournament.started-random");
                        break;
                    }
                    this.plugin.getMessageManager().sendMessage(sender, "tournament.start-failed");
                    break;
                }
                String tournamentId = args[2];
                try {
                    int id = Integer.parseInt(tournamentId);
                    if (this.plugin.getTournamentManager().startTournament(id)) {
                        this.plugin.getMessageManager().sendMessage(sender, "tournament.started-specific", "Tournament", tournamentId);
                        break;
                    }
                    this.plugin.getMessageManager().sendMessage(sender, "tournament.not-found", "Tournament", tournamentId);
                }
                catch (NumberFormatException e) {
                    this.plugin.getMessageManager().sendMessage(sender, "tournament.not-found", "[tournament]", tournamentId);
                }
                break;
            }
            case "end": {
                if (this.plugin.getTournamentManager().endTournament()) {
                    this.plugin.getMessageManager().sendMessage(sender, "tournament.ended");
                    break;
                }
                this.plugin.getMessageManager().sendMessage(sender, "tournament.no-active");
                break;
            }
            case "status": {
                if (this.plugin.getTournamentManager().isTournamentActive()) {
                    this.plugin.getMessageManager().sendMessage(sender, "tournament.active-status");
                    break;
                }
                this.plugin.getMessageManager().sendMessage(sender, "tournament.no-active");
                break;
            }
            default: {
                this.plugin.getMessageManager().sendMessage(sender, "muj.usage-tournament");
            }
        }
    }

    private void handleEventCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessageManager().sendMessage(sender, "muj.usage-event");
            return;
        }
        switch (args[1].toLowerCase()) {
            case "start": {
                if (args.length < 3) {
                    if (this.plugin.getEventManager().startRandomEvent()) {
                        this.plugin.getMessageManager().sendMessage(sender, "event.started-random");
                        break;
                    }
                    this.plugin.getMessageManager().sendMessage(sender, "event.start-failed");
                    break;
                }
                String eventId = args[2];
                try {
                    int id = Integer.parseInt(eventId);
                    if (this.plugin.getEventManager().startEvent(id)) {
                        this.plugin.getMessageManager().sendMessage(sender, "event.started-specific", "Event", eventId);
                        break;
                    }
                    this.plugin.getMessageManager().sendMessage(sender, "event.not-found", "Event", eventId);
                }
                catch (NumberFormatException e) {
                    this.plugin.getMessageManager().sendMessage(sender, "event.not-found", "[event]", eventId);
                }
                break;
            }
            case "end": {
                if (this.plugin.getEventManager().endEvent()) {
                    this.plugin.getMessageManager().sendMessage(sender, "event.ended");
                    break;
                }
                this.plugin.getMessageManager().sendMessage(sender, "event.no-active");
                break;
            }
            case "status": {
                if (this.plugin.getEventManager().isEventActive()) {
                    this.plugin.getMessageManager().sendMessage(sender, "event.active-status");
                    break;
                }
                this.plugin.getMessageManager().sendMessage(sender, "event.no-active");
                break;
            }
            default: {
                this.plugin.getMessageManager().sendMessage(sender, "muj.usage-event");
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.asList("help", "reload", "give", "tournament", "event"));
            return this.filterCompletions(completions, args[0]);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
            List<String> types = Arrays.asList("xp", "level", "booster");
            return this.filterCompletions(types, args[1]);
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("tournament") || args[0].equalsIgnoreCase("event"))) {
            List<String> actions = Arrays.asList("start", "end", "status");
            return this.filterCompletions(actions, args[1]);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("tournament") && args[1].equalsIgnoreCase("start")) {
            List<String> tournamentIds = this.plugin.getTournamentManager().getAvailableTournamentIds();
            return this.filterCompletions(tournamentIds, args[2]);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("event") && args[1].equalsIgnoreCase("start")) {
            List<String> eventIds = this.plugin.getEventManager().getAvailableEventIds();
            return this.filterCompletions(eventIds, args[2]);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("give") && (args[1].equalsIgnoreCase("xp") || args[1].equalsIgnoreCase("level"))) {
            ArrayList<String> jobs = new ArrayList<String>();
            for (String jobKey : this.plugin.getJobManager().getJobNames()) {
                String jobConfigName = this.plugin.getJobManager().getJobConfig(jobKey).getString("MrUltimateJobs.Job.JobConfigName", jobKey);
                if (jobs.contains(jobConfigName)) continue;
                jobs.add(jobConfigName);
            }
            return this.filterCompletions(jobs, args[2]);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("give") && args[1].equalsIgnoreCase("booster")) {
            return this.filterCompletions(Arrays.asList("1", "5", "10", "25", "50", "100", "250", "500", "1000"), args[2]);
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("give") && (args[1].equalsIgnoreCase("xp") || args[1].equalsIgnoreCase("level"))) {
            ArrayList<String> playerNames = new ArrayList<String>();
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                playerNames.add(player.getName());
            }
            return this.filterCompletions(playerNames, args[3]);
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("give") && args[1].equalsIgnoreCase("booster")) {
            ArrayList<String> playerNames = new ArrayList<String>();
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                playerNames.add(player.getName());
            }
            return this.filterCompletions(playerNames, args[3]);
        }
        if (args.length == 5 && args[0].equalsIgnoreCase("give") && (args[1].equalsIgnoreCase("xp") || args[1].equalsIgnoreCase("level"))) {
            return this.filterCompletions(Arrays.asList("1", "5", "10", "25", "50", "100", "250", "500", "1000"), args[4]);
        }
        if (args.length == 5 && args[0].equalsIgnoreCase("give") && args[1].equalsIgnoreCase("booster")) {
            ArrayList<String> boosterIds = new ArrayList<String>(this.plugin.getBoosterManager().getAvailableBoosterIds());
            return this.filterCompletions(boosterIds, args[4]);
        }
        return Collections.emptyList();
    }

    private List<String> filterCompletions(List<String> completions, String arg) {
        ArrayList<String> result = new ArrayList<String>();
        for (String completion : completions) {
            if (!completion.toLowerCase().startsWith(arg.toLowerCase())) continue;
            result.add(completion);
        }
        return result;
    }
}

