/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.database;

import eu.mrneznamy.mrlibcore.database.MrLibDatabase;
import eu.mrneznamy.mrlibcore.database.MrLibDatabaseManager;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class JobsDatabaseManager {
    private final MrUltimateJobs plugin;
    private final String storageType;
    private final MrLibDatabase database;
    private final File yamlFolder;

    public JobsDatabaseManager(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.storageType = plugin.getConfig().getString("Database.Type", "yml").toLowerCase();
        this.yamlFolder = new File(plugin.getDataFolder(), "playerdata");
        if ("mysql".equals(this.storageType) || "sqlite".equals(this.storageType)) {
            this.database = this.initializeDatabase();
            if (this.database != null) {
                this.createTables();
            }
        } else {
            this.database = null;
            if (!this.yamlFolder.exists()) {
                this.yamlFolder.mkdirs();
            }
        }
    }

    private MrLibDatabase initializeDatabase() {
        FileConfiguration config = this.plugin.getConfig();
        if ("mysql".equals(this.storageType)) {
            String host = config.getString("Database.MySQL.Host", "localhost");
            int port = config.getInt("Database.MySQL.Port", 3306);
            String dbName = config.getString("Database.MySQL.Database", "ultimatejobs");
            String username = config.getString("Database.MySQL.Username", "root");
            String password = config.getString("Database.MySQL.Password", "");
            MrLibDatabase db = MrLibDatabaseManager.registerMySQL((String)this.plugin.getName(), (String)host, (int)port, (String)dbName, (String)username, (String)password);
            if (db != null) {
                MrLibConsoleSayer.MrSay_Success((String)"MrUltimateJobs connected to MySQL database!");
                return db;
            }
            MrLibConsoleSayer.MrSay_Error((String)"Failed to connect to MySQL! Falling back to YAML.");
            return null;
        }
        if ("sqlite".equals(this.storageType)) {
            String fileName = config.getString("Database.SQLite.FileName", "ultimatejobs.db");
            MrLibDatabase db = MrLibDatabaseManager.registerSQLite((JavaPlugin)this.plugin, (String)fileName);
            if (db != null) {
                MrLibConsoleSayer.MrSay_Success((String)"MrUltimateJobs connected to SQLite database!");
                return db;
            }
            MrLibConsoleSayer.MrSay_Error((String)"Failed to connect to SQLite! Falling back to YAML.");
            return null;
        }
        return null;
    }

    private void createTables() {
        if (this.database == null) {
            return;
        }
        this.database.createTable("player_jobs", "uuid VARCHAR(36) PRIMARY KEY, current_job VARCHAR(100), job_level INTEGER DEFAULT 1, job_exp DOUBLE DEFAULT 0");
        this.database.createTable("player_rewards", "id INTEGER PRIMARY KEY AUTO_INCREMENT, uuid VARCHAR(36) NOT NULL, job VARCHAR(100) NOT NULL, level INTEGER NOT NULL, claimed BOOLEAN DEFAULT FALSE");
        MrLibConsoleSayer.MrSay_Success((String)"Database tables created/verified!");
    }

    public String getCurrentJob(UUID uuid) {
        if (this.database != null) {
            return this.getJobFromDatabase(uuid);
        }
        return this.getJobFromYAML(uuid);
    }

    public void setCurrentJob(UUID uuid, String job) {
        if (this.database != null) {
            this.setJobInDatabase(uuid, job);
        } else {
            this.setJobInYAML(uuid, job);
        }
    }

    public int getJobLevel(UUID uuid) {
        if (this.database != null) {
            return this.getJobLevelFromDatabase(uuid);
        }
        return this.getJobLevelFromYAML(uuid);
    }

    public void setJobLevel(UUID uuid, int level) {
        if (this.database != null) {
            this.setJobLevelInDatabase(uuid, level);
        } else {
            this.setJobLevelInYAML(uuid, level);
        }
    }

    public double getJobExp(UUID uuid) {
        if (this.database != null) {
            return this.getJobExpFromDatabase(uuid);
        }
        return this.getJobExpFromYAML(uuid);
    }

    public void setJobExp(UUID uuid, double exp) {
        if (this.database != null) {
            this.setJobExpInDatabase(uuid, exp);
        } else {
            this.setJobExpInYAML(uuid, exp);
        }
    }

    public boolean hasClaimedReward(UUID uuid, String job, int level) {
        if (this.database != null) {
            return this.hasClaimedRewardInDatabase(uuid, job, level);
        }
        return this.hasClaimedRewardInYAML(uuid, job, level);
    }

    public void setRewardClaimed(UUID uuid, String job, int level) {
        if (this.database != null) {
            this.setRewardClaimedInDatabase(uuid, job, level);
        } else {
            this.setRewardClaimedInYAML(uuid, job, level);
        }
    }

    private File getPlayerFile(UUID uuid) {
        return new File(this.yamlFolder, uuid.toString() + ".yml");
    }

    private FileConfiguration getPlayerData(UUID uuid) {
        File file = this.getPlayerFile(uuid);
        if (!file.exists()) {
            return new YamlConfiguration();
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private void savePlayerData(UUID uuid, FileConfiguration data) {
        try {
            data.save(this.getPlayerFile(uuid));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getJobFromYAML(UUID uuid) {
        return this.getPlayerData(uuid).getString("current_job");
    }

    private void setJobInYAML(UUID uuid, String job) {
        FileConfiguration data = this.getPlayerData(uuid);
        data.set("current_job", (Object)job);
        this.savePlayerData(uuid, data);
    }

    private int getJobLevelFromYAML(UUID uuid) {
        return this.getPlayerData(uuid).getInt("job_level", 1);
    }

    private void setJobLevelInYAML(UUID uuid, int level) {
        FileConfiguration data = this.getPlayerData(uuid);
        data.set("job_level", (Object)level);
        this.savePlayerData(uuid, data);
    }

    private double getJobExpFromYAML(UUID uuid) {
        return this.getPlayerData(uuid).getDouble("job_exp", 0.0);
    }

    private void setJobExpInYAML(UUID uuid, double exp) {
        FileConfiguration data = this.getPlayerData(uuid);
        data.set("job_exp", (Object)exp);
        this.savePlayerData(uuid, data);
    }

    private boolean hasClaimedRewardInYAML(UUID uuid, String job, int level) {
        FileConfiguration data = this.getPlayerData(uuid);
        return data.getBoolean("rewards." + job + "." + level, false);
    }

    private void setRewardClaimedInYAML(UUID uuid, String job, int level) {
        FileConfiguration data = this.getPlayerData(uuid);
        data.set("rewards." + job + "." + level, (Object)true);
        this.savePlayerData(uuid, data);
    }

    private String getJobFromDatabase(UUID uuid) {
        String[] job = new String[]{null};
        this.database.executeQuery("SELECT current_job FROM player_jobs WHERE uuid = ?", rs -> {
            try {
                if (rs.next()) {
                    job[0] = rs.getString("current_job");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, new Object[]{uuid.toString()});
        return job[0];
    }

    private void setJobInDatabase(UUID uuid, String job) {
        boolean[] exists = new boolean[]{false};
        this.database.executeQuery("SELECT uuid FROM player_jobs WHERE uuid = ?", rs -> {
            try {
                if (rs.next()) {
                    exists[0] = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, new Object[]{uuid.toString()});
        if (exists[0]) {
            this.database.executeUpdate("UPDATE player_jobs SET current_job = ? WHERE uuid = ?", new Object[]{job, uuid.toString()});
        } else {
            this.database.executeUpdate("INSERT INTO player_jobs (uuid, current_job) VALUES (?, ?)", new Object[]{uuid.toString(), job});
        }
    }

    private int getJobLevelFromDatabase(UUID uuid) {
        int[] level = new int[]{1};
        this.database.executeQuery("SELECT job_level FROM player_jobs WHERE uuid = ?", rs -> {
            try {
                if (rs.next()) {
                    level[0] = rs.getInt("job_level");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, new Object[]{uuid.toString()});
        return level[0];
    }

    private void setJobLevelInDatabase(UUID uuid, int level) {
        boolean[] exists = new boolean[]{false};
        this.database.executeQuery("SELECT uuid FROM player_jobs WHERE uuid = ?", rs -> {
            try {
                if (rs.next()) {
                    exists[0] = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, new Object[]{uuid.toString()});
        if (exists[0]) {
            this.database.executeUpdate("UPDATE player_jobs SET job_level = ? WHERE uuid = ?", new Object[]{level, uuid.toString()});
        } else {
            this.database.executeUpdate("INSERT INTO player_jobs (uuid, job_level) VALUES (?, ?)", new Object[]{uuid.toString(), level});
        }
    }

    private double getJobExpFromDatabase(UUID uuid) {
        double[] exp = new double[]{0.0};
        this.database.executeQuery("SELECT job_exp FROM player_jobs WHERE uuid = ?", rs -> {
            try {
                if (rs.next()) {
                    exp[0] = rs.getDouble("job_exp");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, new Object[]{uuid.toString()});
        return exp[0];
    }

    private void setJobExpInDatabase(UUID uuid, double exp) {
        boolean[] exists = new boolean[]{false};
        this.database.executeQuery("SELECT uuid FROM player_jobs WHERE uuid = ?", rs -> {
            try {
                if (rs.next()) {
                    exists[0] = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, new Object[]{uuid.toString()});
        if (exists[0]) {
            this.database.executeUpdate("UPDATE player_jobs SET job_exp = ? WHERE uuid = ?", new Object[]{exp, uuid.toString()});
        } else {
            this.database.executeUpdate("INSERT INTO player_jobs (uuid, job_exp) VALUES (?, ?)", new Object[]{uuid.toString(), exp});
        }
    }

    private boolean hasClaimedRewardInDatabase(UUID uuid, String job, int level) {
        boolean[] claimed = new boolean[]{false};
        this.database.executeQuery("SELECT claimed FROM player_rewards WHERE uuid = ? AND job = ? AND level = ?", rs -> {
            try {
                if (rs.next()) {
                    claimed[0] = rs.getBoolean("claimed");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, new Object[]{uuid.toString(), job, level});
        return claimed[0];
    }

    private void setRewardClaimedInDatabase(UUID uuid, String job, int level) {
        this.database.executeUpdate("INSERT OR REPLACE INTO player_rewards (uuid, job, level, claimed) VALUES (?, ?, ?, TRUE)", new Object[]{uuid.toString(), job, level});
    }

    public void close() {
        if (this.database != null) {
            MrLibDatabaseManager.unregister((String)this.plugin.getName());
        }
    }
}

