/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.integrations;

import eu.mrneznamy.mrlibcore.placeholders.MrLibRegisterPlaceholders;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import eu.mrneznamy.mrultimatejobs.managers.PlayerDataManager;
import eu.mrneznamy.mrultimatejobs.managers.PlayerJobManager;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlaceholderAPIIntegration {
    private final MrUltimateJobs plugin;
    private final PlayerDataManager data;
    private final PlayerJobManager jobManager;
    private final Map<String, CachedLeaderboard> cache = new ConcurrentHashMap<String, CachedLeaderboard>();
    private final long CACHE_TTL_MS = 30000L;

    public PlaceholderAPIIntegration(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.data = plugin.getPlayerDataManager();
        this.jobManager = plugin.getPlayerJobManager();
    }

    public void register() {
        MrLibRegisterPlaceholders.register((String)"muj", (String)"jobs_total_workers", (player, params) -> String.valueOf(this.getTotalWorkers()));
        MrLibRegisterPlaceholders.register((String)"muj", (String)"job_current_jobs", (player, params) -> {
            if (player == null) {
                return "0";
            }
            try {
                FileConfiguration cfg = this.loadPlayerConfig(player.getUniqueId());
                if (cfg == null) {
                    return "0";
                }
                List active = cfg.getStringList("Active-Jobs");
                if (active != null && !active.isEmpty()) {
                    return String.valueOf(active.size());
                }
                List legacy = cfg.getStringList("current-jobs");
                if (legacy != null && !legacy.isEmpty()) {
                    return String.valueOf(legacy.size());
                }
                if (cfg.isConfigurationSection("jobs") && !cfg.getConfigurationSection("jobs").getKeys(false).isEmpty()) {
                    return "1";
                }
                return "0";
            }
            catch (Exception ignored) {
                return "0";
            }
        });
        MrLibRegisterPlaceholders.register((String)"muj", (String)"job_max_jobs", (player, params) -> {
            if (player == null) {
                return "1";
            }
            Player onlinePlayer = player.getPlayer();
            if (onlinePlayer == null) {
                try {
                    onlinePlayer = Bukkit.getPlayer((UUID)player.getUniqueId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (onlinePlayer != null) {
                return String.valueOf(this.jobManager.getMaxJobsForPlayer(onlinePlayer));
            }
            return "1";
        });
        MrLibRegisterPlaceholders.register((String)"muj", (String)"job_totalmoneymaked", (player, params) -> {
            if (player == null) {
                return "0";
            }
            return this.formatDouble(this.getTotalMoneyForPlayer(player.getUniqueId()));
        });
        MrLibRegisterPlaceholders.register((String)"muj", (String)"job", (player, params) -> {
            if (params == null || params.isEmpty()) {
                return null;
            }
            return this.handleJobPlaceholders((OfflinePlayer)player, params);
        });
    }

    private String handleJobPlaceholders(OfflinePlayer player, String params) {
        String[] parts = params.split("_");
        if (parts.length < 2) {
            return "0";
        }
        String jobToken = parts[0];
        String jobKey = this.resolveJobKey(jobToken);
        if (jobKey == null || this.plugin.getJobManager().getJobConfig(jobKey) == null) {
            return "0";
        }
        if (parts.length >= 2) {
            String twoPart;
            String first = parts[1].toLowerCase(Locale.ROOT);
            switch (twoPart = parts.length >= 3 ? (parts[1] + "_" + parts[2]).toLowerCase(Locale.ROOT) : first) {
                case "total_workers": {
                    return String.valueOf(this.getJobWorkersCount(jobKey));
                }
                case "current_level": {
                    if (player == null) {
                        return "1";
                    }
                    return String.valueOf(this.getPlayerJobLevel(player, jobKey));
                }
                case "max_level": {
                    return String.valueOf(this.getJobMaxLevel(jobKey));
                }
                case "money_maked": {
                    if (player == null) {
                        return "0";
                    }
                    return this.formatDouble(this.getPlayerMoneyEarned(player, jobKey));
                }
            }
            if (first.equals("topn") || first.equals("topv")) {
                if (parts.length >= 4) {
                    int position;
                    String type = parts[2];
                    String positionStr = parts[3];
                    LeaderboardType lbType = LeaderboardType.fromString(type);
                    if (lbType == null) {
                        return "";
                    }
                    List<LBEntry> entries = this.getJobLeaderboard(jobKey, lbType);
                    if (entries.isEmpty()) {
                        return "";
                    }
                    try {
                        position = Integer.parseInt(positionStr);
                    }
                    catch (NumberFormatException ex) {
                        return "";
                    }
                    if (position <= 0 || position > entries.size()) {
                        return "";
                    }
                    LBEntry entry = entries.get(position - 1);
                    return first.equals("topn") ? entry.name : String.valueOf(entry.value);
                }
                return "";
            }
        }
        if (parts.length >= 4 && (parts[1].equals("topn") || parts[1].equals("topv"))) {
            int position;
            String type = parts[2];
            String positionStr = parts[3];
            LeaderboardType lbType = LeaderboardType.fromString(type);
            if (lbType == null) {
                return "";
            }
            List<LBEntry> entries = this.getJobLeaderboard(jobKey, lbType);
            if (entries.isEmpty()) {
                return "";
            }
            try {
                position = Integer.parseInt(positionStr);
            }
            catch (NumberFormatException ex) {
                return "";
            }
            if (position <= 0 || position > entries.size()) {
                return "";
            }
            LBEntry entry = entries.get(position - 1);
            if (parts[1].equals("topn")) {
                return entry.name;
            }
            return String.valueOf(entry.value);
        }
        return "";
    }

    private String resolveJobKey(String input) {
        if (input == null) {
            return null;
        }
        String needle = MrLibColors.stripColor((String)input).trim();
        for (String jobKey : this.plugin.getJobManager().getJobNames()) {
            if (jobKey.equalsIgnoreCase(needle)) {
                return jobKey;
            }
            try {
                FileConfiguration cfg = this.plugin.getJobManager().getJobConfig(jobKey);
                if (cfg == null) continue;
                String jobConfigName = cfg.getString("MrUltimateJobs.Job.JobConfigName", jobKey);
                String displayName = cfg.getString("MrUltimateJobs.Job.Name", jobKey);
                if (jobConfigName != null && jobConfigName.equalsIgnoreCase(needle)) {
                    return jobKey;
                }
                if (displayName == null || !MrLibColors.stripColor((String)displayName).equalsIgnoreCase(needle)) continue;
                return jobKey;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private int getTotalWorkers() {
        int total = 0;
        File dataFolder = new File(this.plugin.getDataFolder(), "playerdata");
        File[] files = dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null) {
            return 0;
        }
        for (File file : files) {
            try {
                YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
                List active = cfg.getStringList("Active-Jobs");
                if (active != null && !active.isEmpty()) {
                    ++total;
                    continue;
                }
                if (cfg.getString("current-job") != null && !cfg.getString("current-job").isEmpty()) {
                    ++total;
                    continue;
                }
                if (!cfg.isConfigurationSection("jobs") || cfg.getConfigurationSection("jobs").getKeys(false).isEmpty()) continue;
                ++total;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return total;
    }

    private int getJobWorkersCount(String jobName) {
        int count = 0;
        File dataFolder = new File(this.plugin.getDataFolder(), "playerdata");
        File[] files = dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null) {
            return 0;
        }
        block2: for (File file : files) {
            try {
                YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
                List active = cfg.getStringList("Active-Jobs");
                if (active != null) {
                    for (String j : active) {
                        if (!j.equalsIgnoreCase(jobName)) continue;
                        ++count;
                        continue block2;
                    }
                    continue;
                }
                String currentJob = cfg.getString("current-job");
                if (currentJob != null && currentJob.equalsIgnoreCase(jobName)) {
                    ++count;
                    continue;
                }
                if (!cfg.isConfigurationSection("jobs") || !cfg.getConfigurationSection("jobs").getKeys(false).stream().anyMatch(k -> k.equalsIgnoreCase(jobName))) continue;
                ++count;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count;
    }

    private int getPlayerJobLevel(OfflinePlayer player, String jobName) {
        FileConfiguration cfg = this.loadPlayerConfig(player.getUniqueId());
        if (cfg == null) {
            return 1;
        }
        try {
            return cfg.getInt("jobs." + jobName.toLowerCase() + ".level", 1);
        }
        catch (Exception ignored) {
            return 1;
        }
    }

    private int getJobMaxLevel(String jobName) {
        FileConfiguration jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
        if (jobConfig == null) {
            return 1;
        }
        ConfigurationSection section = jobConfig.getConfigurationSection("MrUltimateJobs.Job.System.Levels");
        if (section == null) {
            return 1;
        }
        return section.getKeys(false).size();
    }

    private double getPlayerMoneyEarned(OfflinePlayer player, String jobName) {
        FileConfiguration cfg = this.loadPlayerConfig(player.getUniqueId());
        if (cfg == null) {
            return 0.0;
        }
        try {
            return cfg.getDouble("jobs." + jobName.toLowerCase() + ".moneyEarned", 0.0);
        }
        catch (Exception ignored) {
            return 0.0;
        }
    }

    private double getTotalMoneyForPlayer(UUID uuid) {
        try {
            FileConfiguration cfg = this.loadPlayerConfig(uuid);
            if (cfg != null) {
                double total = cfg.getDouble("total-money-earned", Double.NaN);
                if (!Double.isNaN(total)) {
                    return total;
                }
                if (cfg.isConfigurationSection("jobs")) {
                    double sum = 0.0;
                    for (String key : cfg.getConfigurationSection("jobs").getKeys(false)) {
                        sum += cfg.getDouble("jobs." + key + ".moneyEarned", 0.0);
                    }
                    return sum;
                }
            }
        }
        catch (Exception cfg) {
            // empty catch block
        }
        try {
            return this.data.getTotalMoneyEarned(uuid);
        }
        catch (Exception ignored) {
            return 0.0;
        }
    }

    private String formatDouble(double value) {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros();
        return bd.toPlainString();
    }

    private int getPlayerIndex(List<LBEntry> list, UUID uuid) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get((int)i).uuid.equals(uuid)) continue;
            return i;
        }
        return -1;
    }

    private FileConfiguration loadPlayerConfig(UUID uuid) {
        File playerFile = new File(this.plugin.getDataFolder(), "playerdata/" + String.valueOf(uuid) + ".yml");
        if (!playerFile.exists()) {
            return null;
        }
        try {
            return YamlConfiguration.loadConfiguration((File)playerFile);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private List<LBEntry> getJobLeaderboard(String jobName, LeaderboardType type) {
        String key = jobName + "_" + type.name();
        CachedLeaderboard cached = this.cache.get(key);
        long now = System.currentTimeMillis();
        if (cached != null && now - cached.timestamp < 30000L) {
            return cached.entries;
        }
        File dataFolder = new File(this.plugin.getDataFolder(), "playerdata");
        File[] files = dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null) {
            this.cache.put(key, new CachedLeaderboard(now, Collections.emptyList()));
            return Collections.emptyList();
        }
        ArrayList<LBEntry> entries = new ArrayList<LBEntry>(files.length);
        for (File f : files) {
            try {
                String currentJob;
                String uuidStr = f.getName().substring(0, f.getName().length() - 4);
                UUID uuid = UUID.fromString(uuidStr);
                YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);
                boolean hasJob = false;
                List active = cfg.getStringList("Active-Jobs");
                if (active != null && !active.isEmpty()) {
                    for (String j : active) {
                        if (!j.equalsIgnoreCase(jobName)) continue;
                        hasJob = true;
                        break;
                    }
                }
                if (!hasJob && (currentJob = cfg.getString("current-job")) != null && currentJob.equalsIgnoreCase(jobName)) {
                    hasJob = true;
                }
                if (!hasJob && cfg.isConfigurationSection("jobs") && cfg.getConfigurationSection("jobs").getKeys(false).stream().anyMatch(k -> k.equalsIgnoreCase(jobName))) {
                    hasJob = true;
                }
                if (!hasJob) continue;
                long value = switch (type.ordinal()) {
                    case 0 -> cfg.getLong("jobs." + jobName + ".level", 1L);
                    case 1 -> (long)cfg.getDouble("jobs." + jobName + ".moneyEarned", 0.0);
                    default -> 0L;
                };
                String name2 = Optional.ofNullable(Bukkit.getOfflinePlayer((UUID)uuid).getName()).orElse(uuid.toString());
                entries.add(new LBEntry(uuid, name2, value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        entries.sort(Comparator.comparingLong(e -> e.value).reversed());
        this.cache.put(key, new CachedLeaderboard(now, entries));
        return entries;
    }

    private static enum LeaderboardType {
        LEVEL("level"),
        MONEYMAKED("moneymaked");

        final String id;

        private LeaderboardType(String id) {
            this.id = id;
        }

        static LeaderboardType fromString(String s) {
            for (LeaderboardType t : LeaderboardType.values()) {
                if (!t.id.equalsIgnoreCase(s)) continue;
                return t;
            }
            return null;
        }
    }

    private static class LBEntry {
        final UUID uuid;
        final String name;
        final long value;

        LBEntry(UUID uuid, String name, long value) {
            this.uuid = uuid;
            this.name = name;
            this.value = value;
        }
    }

    private static class CachedLeaderboard {
        final long timestamp;
        final List<LBEntry> entries;

        CachedLeaderboard(long timestamp, List<LBEntry> entries) {
            this.timestamp = timestamp;
            this.entries = entries;
        }
    }
}

