/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.listeners;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import eu.mrneznamy.mrultimatejobs.managers.JobManager;
import eu.mrneznamy.mrultimatejobs.managers.PlayerJobManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class JobListener
implements Listener {
    private final MrUltimateJobs plugin;
    private final Map<UUID, BossBar> playerBossBars;
    private final Map<UUID, Long> lastActivityTime;
    private final Map<UUID, Integer> playerMoneyActionCounts;
    private final Map<UUID, Integer> playerXPActionCounts;
    private final Map<UUID, Double> playerAccumulatedXP;
    private final Map<UUID, Double> playerAccumulatedMoney;

    public JobListener(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.playerBossBars = new HashMap<UUID, BossBar>();
        this.lastActivityTime = new HashMap<UUID, Long>();
        this.playerMoneyActionCounts = new HashMap<UUID, Integer>();
        this.playerXPActionCounts = new HashMap<UUID, Integer>();
        this.playerAccumulatedXP = new HashMap<UUID, Double>();
        this.playerAccumulatedMoney = new HashMap<UUID, Double>();
        this.startBossBarCleanupTask();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        block2: {
            String jobKey;
            Set savedJobs;
            Iterator iterator;
            FileConfiguration playerData;
            Player player;
            block3: {
                String job;
                player = event.getPlayer();
                this.plugin.getPlayerDataManager().loadPlayerData(player);
                playerData = this.plugin.getPlayerDataManager().getPlayerData(player.getUniqueId());
                if (playerData == null) break block2;
                List<String> jobs = this.plugin.getPlayerDataManager().getActiveJobs(player.getUniqueId());
                if (jobs == null || jobs.isEmpty()) {
                    String currentJob = playerData.getString("current-job");
                    if (currentJob != null && !currentJob.isEmpty()) {
                        String jobToAdd = currentJob;
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getPlayerJobManager().addJob(player, jobToAdd));
                        return;
                    }
                    jobs = this.plugin.getPlayerDataManager().getCurrentJobs(player.getUniqueId());
                }
                if (jobs == null || jobs.isEmpty()) break block3;
                String jobToAdd = job = jobs.get(0);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getPlayerJobManager().addJob(player, jobToAdd));
                break block2;
            }
            if (!playerData.isConfigurationSection("jobs") || !(iterator = (savedJobs = playerData.getConfigurationSection("jobs").getKeys(false)).iterator()).hasNext()) break block2;
            String jobToAdd = jobKey = (String)iterator.next();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getPlayerJobManager().addJob(player, jobToAdd));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.getPlayerDataManager().savePlayerData(player);
        UUID playerId = player.getUniqueId();
        BossBar bossBar = this.playerBossBars.get(playerId);
        if (bossBar != null) {
            bossBar.removePlayer(player);
            bossBar.removeAll();
            this.playerBossBars.remove(playerId);
        }
        this.lastActivityTime.remove(playerId);
        this.playerMoneyActionCounts.remove(playerId);
        this.playerXPActionCounts.remove(playerId);
        this.playerAccumulatedXP.remove(playerId);
        this.playerAccumulatedMoney.remove(playerId);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Material blockType = event.getBlock().getType();
        PlayerJobManager playerJobManager = this.plugin.getPlayerJobManager();
        if (!playerJobManager.hasJob(player)) {
            return;
        }
        JobManager jobManager = this.plugin.getJobManager();
        for (String jobName : playerJobManager.getActiveJobs(player)) {
            FileConfiguration jobConfig = jobManager.getJobConfig(jobName);
            if (jobConfig == null || !jobManager.jobHasAction(jobName, "MINE") || this.isWorldDisabled(player.getWorld().getName()) || !this.isToolAllowed(jobConfig, player.getInventory().getItemInMainHand().getType()) || !this.isBlockInJobList(jobConfig, "Mine-Blocks", blockType)) continue;
            this.processJobAction(player, jobName, jobConfig, "Mine-Blocks", blockType);
            this.plugin.getPlayerDataManager().incrementJobStat(player, jobName, "blocks_broken", 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Material blockType = event.getBlock().getType();
        PlayerJobManager playerJobManager2 = this.plugin.getPlayerJobManager();
        if (!playerJobManager2.hasJob(player)) {
            return;
        }
        JobManager jobManager2 = this.plugin.getJobManager();
        for (String jobName : playerJobManager2.getActiveJobs(player)) {
            FileConfiguration jobConfig = jobManager2.getJobConfig(jobName);
            if (jobConfig == null || !jobManager2.jobHasAction(jobName, "PLACE") || this.isWorldDisabled(player.getWorld().getName())) continue;
            boolean blockMatch = this.isBlockInJobList(jobConfig, "Place-Blocks", blockType);
            if (blockMatch) {
                this.processJobAction(player, jobName, jobConfig, "Place-Blocks", blockType);
                this.plugin.getPlayerDataManager().incrementJobStat(player, jobName, "blocks_placed", 1L);
                continue;
            }
            Material handType = event.getItemInHand() != null ? event.getItemInHand().getType() : Material.AIR;
            boolean itemMatch = this.isItemInJobList(jobConfig, "Place-Blocks", handType);
            if (!itemMatch) continue;
            this.processJobActionForItem(player, jobName, jobConfig, "Place-Blocks", handType);
            this.plugin.getPlayerDataManager().incrementJobStat(player, jobName, "blocks_placed", 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        Player player = event.getEntity().getKiller();
        if (player == null) {
            return;
        }
        EntityType entityType = event.getEntity().getType();
        PlayerJobManager playerJobManager3 = this.plugin.getPlayerJobManager();
        if (!playerJobManager3.hasJob(player)) {
            return;
        }
        JobManager jobManager3 = this.plugin.getJobManager();
        for (String jobName : playerJobManager3.getActiveJobs(player)) {
            FileConfiguration jobConfig = jobManager3.getJobConfig(jobName);
            if (jobConfig == null || !jobManager3.jobHasAction(jobName, "KILL") || this.isWorldDisabled(player.getWorld().getName()) || !this.isToolAllowed(jobConfig, player.getInventory().getItemInMainHand().getType()) || !this.isEntityInJobList(jobConfig, "Kill-Mobs", entityType)) continue;
            this.processJobActionForEntity(player, jobName, jobConfig, "Kill-Mobs", entityType);
            this.plugin.getPlayerDataManager().incrementJobStat(player, jobName, "mobs_killed", 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null || itemInHand.getType() == Material.AIR) {
            return;
        }
        Material itemType = itemInHand.getType();
        if (event.getRightClicked() instanceof Animals) {
            return;
        }
        PlayerJobManager playerJobManager4 = this.plugin.getPlayerJobManager();
        if (!playerJobManager4.hasJob(player)) {
            return;
        }
        JobManager jobManager4 = this.plugin.getJobManager();
        for (String jobName : playerJobManager4.getActiveJobs(player)) {
            FileConfiguration jobConfig = jobManager4.getJobConfig(jobName);
            if (jobConfig == null || !jobManager4.jobHasAction(jobName, "CATCH") || this.isWorldDisabled(player.getWorld().getName()) || !this.isItemInJobList(jobConfig, "Catch-Items", itemType)) continue;
            this.processJobActionForItem(player, jobName, jobConfig, "Catch-Items", itemType);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEnchantItem(EnchantItemEvent event) {
        Player player = event.getEnchanter();
        ItemStack item = event.getItem();
        PlayerJobManager playerJobManager = this.plugin.getPlayerJobManager();
        if (!playerJobManager.hasJob(player)) {
            return;
        }
        JobManager jobManager = this.plugin.getJobManager();
        for (String jobName : playerJobManager.getActiveJobs(player)) {
            FileConfiguration jobConfig = jobManager.getJobConfig(jobName);
            if (jobConfig == null || !jobManager.jobHasAction(jobName, "ENCHANT") || this.isWorldDisabled(player.getWorld().getName()) || !this.isItemInJobList(jobConfig, "Enchant-Items", item.getType())) continue;
            this.processJobActionForItem(player, jobName, jobConfig, "Enchant-Items", item.getType());
            this.plugin.getPlayerDataManager().incrementJobStat(player, jobName, "items_enchanted", 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.plugin.getPlayerJobManager().hasJob(player)) {
            return;
        }
        Entity caught = event.getCaught();
        if (!(caught instanceof Item)) {
            return;
        }
        Item caughtItem = (Item)caught;
        Material itemType = caughtItem.getItemStack().getType();
        JobManager jobManager = this.plugin.getJobManager();
        for (String jobName : this.plugin.getPlayerJobManager().getActiveJobs(player)) {
            FileConfiguration jobConfig = jobManager.getJobConfig(jobName);
            if (jobConfig == null || !jobManager.jobHasAction(jobName, "CATCH") || this.isWorldDisabled(player.getWorld().getName()) || !this.isItemInJobList(jobConfig, "Catch-Items", itemType)) continue;
            this.processJobActionForItem(player, jobName, jobConfig, "Catch-Items", itemType);
            this.plugin.getPlayerDataManager().incrementJobStat(player, jobName, "fish_caught", 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityEnterLoveMode(EntityEnterLoveModeEvent event) {
        if (!(event.getHumanEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getHumanEntity();
        if (!this.plugin.getPlayerJobManager().hasJob(player)) {
            return;
        }
        Material handType = player.getInventory().getItemInMainHand() != null ? player.getInventory().getItemInMainHand().getType() : Material.AIR;
        JobManager jobManager = this.plugin.getJobManager();
        for (String jobName : this.plugin.getPlayerJobManager().getActiveJobs(player)) {
            FileConfiguration jobConfig;
            if (!jobManager.jobHasAction(jobName, "CATCH") || (jobConfig = jobManager.getJobConfig(jobName)) == null || this.isWorldDisabled(player.getWorld().getName()) || !this.isItemInJobList(jobConfig, "Catch-Items", handType)) continue;
            this.processJobActionForItem(player, jobName, jobConfig, "Catch-Items", handType);
        }
    }

    private boolean isBlockInJobList(FileConfiguration jobConfig, String listName, Material blockType) {
        List blockList = jobConfig.getStringList("MrUltimateJobs.Job.System.Actions." + listName);
        for (String blockEntry : blockList) {
            String[] parts = blockEntry.split(",");
            if (parts.length <= 0) continue;
            try {
                Material material = Material.valueOf((String)parts[0].trim().toUpperCase());
                if (material != blockType) continue;
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return false;
    }

    private boolean isEntityInJobList(FileConfiguration jobConfig, String listName, EntityType entityType) {
        List entityList = jobConfig.getStringList("MrUltimateJobs.Job.System.Actions." + listName);
        for (String entityEntry : entityList) {
            String[] parts = entityEntry.split(",");
            if (parts.length <= 0) continue;
            try {
                EntityType entity = EntityType.valueOf((String)parts[0].trim().toUpperCase());
                if (entity != entityType) continue;
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return false;
    }

    private boolean isItemInJobList(FileConfiguration jobConfig, String listName, Material itemType) {
        List itemList = jobConfig.getStringList("MrUltimateJobs.Job.System.Actions." + listName);
        for (String itemEntry : itemList) {
            String[] parts = itemEntry.split(",");
            if (parts.length <= 0) continue;
            try {
                Material material = Material.valueOf((String)parts[0].trim().toUpperCase());
                if (material != itemType) continue;
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return false;
    }

    private void processJobAction(Player player, String jobName, FileConfiguration jobConfig, String actionList, Material blockType) {
        String balanceSystem = jobConfig.getString("MrUltimateJobs.Job.System.Actions.BalanceSystem", "OLD");
        if ("NEW".equalsIgnoreCase(balanceSystem)) {
            this.processNewSystemAction(player, jobName, jobConfig, actionList, blockType);
        } else {
            this.processOldSystemAction(player, jobName, jobConfig, actionList, blockType);
        }
    }

    private void processNewSystemAction(Player player, String jobName, FileConfiguration jobConfig, String actionList, Material blockType) {
        UUID playerId = player.getUniqueId();
        int moneyCount = this.playerMoneyActionCounts.getOrDefault(playerId, 0);
        int xpCount = this.playerXPActionCounts.getOrDefault(playerId, 0);
        this.playerMoneyActionCounts.put(playerId, ++moneyCount);
        this.playerXPActionCounts.put(playerId, ++xpCount);
        int playerLevel = this.plugin.getPlayerJobManager().getPlayerJobLevel(player, jobName);
        double xpGained = 0.0;
        try {
            String xpRequiredFormula = jobConfig.getString("MrUltimateJobs.Job.System.Actions.XP.Required", "1");
            double xpRequiredRaw = this.evaluateExpression(xpRequiredFormula, playerLevel);
            int xpRequired = (int)Math.floor(xpRequiredRaw);
            if (xpCount >= xpRequired) {
                this.playerXPActionCounts.put(playerId, 0);
                String xpFormula = jobConfig.getString("MrUltimateJobs.Job.System.Actions.XP.XP", "0.3*[Level]");
                xpGained = this.evaluateExpression(xpFormula, playerLevel);
                double xpMultiplier = this.plugin.getEventManager().getXPMultiplier() * this.plugin.getBoosterManager().getXPMultiplier(player);
                this.plugin.getPlayerJobManager().addPlayerJobXP(player, jobName, xpGained *= xpMultiplier);
                if (this.plugin.getTournamentManager().isTournamentActive()) {
                    this.plugin.getTournamentManager().addScore(player, xpGained);
                }
            }
        }
        catch (Exception xpRequiredFormula) {
            // empty catch block
        }
        double moneyGained = 0.0;
        try {
            String moneyRequiredFormula = jobConfig.getString("MrUltimateJobs.Job.System.Actions.Money.Required", "10");
            double moneyRequiredRaw = this.evaluateExpression(moneyRequiredFormula, playerLevel);
            int moneyRequired = (int)Math.floor(moneyRequiredRaw);
            if (moneyCount >= moneyRequired) {
                Economy economy;
                this.playerMoneyActionCounts.put(playerId, 0);
                String moneyFormula = jobConfig.getString("MrUltimateJobs.Job.System.Actions.Money.Money", "0.3*[Level]");
                moneyGained = this.evaluateExpression(moneyFormula, playerLevel);
                double moneyMultiplier = this.plugin.getEventManager().getMoneyMultiplier() * this.plugin.getBoosterManager().getMoneyMultiplier(player);
                this.plugin.getPlayerJobManager().addPlayerMoneyEarned(player, jobName, moneyGained *= moneyMultiplier);
                if (moneyGained > 0.0 && (economy = (Economy)this.plugin.getServer().getServicesManager().getRegistration(Economy.class).getProvider()) != null) {
                    economy.depositPlayer((OfflinePlayer)player, moneyGained);
                }
                if (this.plugin.getTournamentManager().isTournamentActive()) {
                    this.plugin.getTournamentManager().addScore(player, moneyGained);
                }
            }
        }
        catch (Exception moneyRequiredFormula) {
            // empty catch block
        }
        double accumulatedXP = this.playerAccumulatedXP.getOrDefault(playerId, 0.0) + xpGained;
        double accumulatedMoney = this.playerAccumulatedMoney.getOrDefault(playerId, 0.0) + moneyGained;
        this.playerAccumulatedXP.put(playerId, accumulatedXP);
        this.playerAccumulatedMoney.put(playerId, accumulatedMoney);
        this.updateBossBarWithXPProgress(player, jobName, jobConfig, accumulatedXP, accumulatedMoney);
        this.lastActivityTime.put(player.getUniqueId(), System.currentTimeMillis());
    }

    private void processOldSystemAction(Player player, String jobName, FileConfiguration jobConfig, String actionList, Material blockType) {
        Economy economy;
        List blockList = jobConfig.getStringList("MrUltimateJobs.Job.System.Actions." + actionList);
        String blockEntry = null;
        for (String entry : blockList) {
            String[] parts = entry.split(",");
            if (parts.length <= 0) continue;
            try {
                Material material = Material.valueOf((String)parts[0].trim().toUpperCase());
                if (material != blockType) continue;
                blockEntry = entry;
                break;
            }
            catch (IllegalArgumentException material) {
            }
        }
        if (blockEntry == null) {
            return;
        }
        String[] parts = blockEntry.split(",");
        if (parts.length < 3) {
            return;
        }
        double xpGained = 0.0;
        double moneyGained = 0.0;
        try {
            int playerLevel = this.plugin.getPlayerJobManager().getPlayerJobLevel(player, jobName);
            xpGained = this.evaluateExpression(parts[1].trim(), playerLevel);
            moneyGained = this.evaluateExpression(parts[2].trim(), playerLevel);
        }
        catch (Exception e) {
            return;
        }
        PlayerJobManager playerJobManager = this.plugin.getPlayerJobManager();
        playerJobManager.addPlayerJobXP(player, jobName, xpGained);
        playerJobManager.addPlayerMoneyEarned(player, jobName, moneyGained);
        if (moneyGained > 0.0 && (economy = (Economy)this.plugin.getServer().getServicesManager().getRegistration(Economy.class).getProvider()) != null) {
            economy.depositPlayer((OfflinePlayer)player, moneyGained);
        }
        UUID playerId = player.getUniqueId();
        double accumulatedXP = this.playerAccumulatedXP.getOrDefault(playerId, 0.0) + xpGained;
        double accumulatedMoney = this.playerAccumulatedMoney.getOrDefault(playerId, 0.0) + moneyGained;
        this.playerAccumulatedXP.put(playerId, accumulatedXP);
        this.playerAccumulatedMoney.put(playerId, accumulatedMoney);
        this.updateBossBarWithXPProgress(player, jobName, jobConfig, accumulatedXP, accumulatedMoney);
        this.lastActivityTime.put(player.getUniqueId(), System.currentTimeMillis());
    }

    private void processJobActionForEntity(Player player, String jobName, FileConfiguration jobConfig, String actionList, EntityType entityType) {
        Economy economy;
        List entityList = jobConfig.getStringList("MrUltimateJobs.Job.System.Actions." + actionList);
        String entityEntry = null;
        for (String entry : entityList) {
            String[] parts = entry.split(",");
            if (parts.length <= 0) continue;
            try {
                EntityType entity = EntityType.valueOf((String)parts[0].trim().toUpperCase());
                if (entity != entityType) continue;
                entityEntry = entry;
                break;
            }
            catch (IllegalArgumentException entity) {
            }
        }
        if (entityEntry == null) {
            return;
        }
        String[] parts = entityEntry.split(",");
        if (parts.length < 3) {
            return;
        }
        double xpGained = 0.0;
        double moneyGained = 0.0;
        try {
            int playerLevel = this.plugin.getPlayerJobManager().getPlayerJobLevel(player, jobName);
            xpGained = this.evaluateExpression(parts[1].trim(), playerLevel);
            moneyGained = this.evaluateExpression(parts[2].trim(), playerLevel);
        }
        catch (Exception e) {
            return;
        }
        PlayerJobManager playerJobManager = this.plugin.getPlayerJobManager();
        playerJobManager.addPlayerJobXP(player, jobName, xpGained);
        playerJobManager.addPlayerMoneyEarned(player, jobName, moneyGained);
        if (moneyGained > 0.0 && (economy = (Economy)this.plugin.getServer().getServicesManager().getRegistration(Economy.class).getProvider()) != null) {
            economy.depositPlayer((OfflinePlayer)player, moneyGained);
        }
        UUID playerId = player.getUniqueId();
        double accumulatedXP = this.playerAccumulatedXP.getOrDefault(playerId, 0.0) + xpGained;
        double accumulatedMoney = this.playerAccumulatedMoney.getOrDefault(playerId, 0.0) + moneyGained;
        this.playerAccumulatedXP.put(playerId, accumulatedXP);
        this.playerAccumulatedMoney.put(playerId, accumulatedMoney);
        this.updateBossBarWithXPProgress(player, jobName, jobConfig, accumulatedXP, accumulatedMoney);
        this.lastActivityTime.put(player.getUniqueId(), System.currentTimeMillis());
    }

    private void processJobActionForItem(Player player, String jobName, FileConfiguration jobConfig, String actionList, Material itemType) {
        Economy economy;
        List itemList = jobConfig.getStringList("MrUltimateJobs.Job.System.Actions." + actionList);
        String itemEntry = null;
        for (String entry : itemList) {
            String[] parts = entry.split(",");
            if (parts.length <= 0) continue;
            try {
                Material material = Material.valueOf((String)parts[0].trim().toUpperCase());
                if (material != itemType) continue;
                itemEntry = entry;
                break;
            }
            catch (IllegalArgumentException material) {
            }
        }
        if (itemEntry == null) {
            return;
        }
        String[] parts = itemEntry.split(",");
        if (parts.length < 3) {
            return;
        }
        double xpGained = 0.0;
        double moneyGained = 0.0;
        try {
            int playerLevel = this.plugin.getPlayerJobManager().getPlayerJobLevel(player, jobName);
            xpGained = this.evaluateExpression(parts[1].trim(), playerLevel);
            moneyGained = this.evaluateExpression(parts[2].trim(), playerLevel);
        }
        catch (Exception e) {
            return;
        }
        PlayerJobManager playerJobManager = this.plugin.getPlayerJobManager();
        playerJobManager.addPlayerJobXP(player, jobName, xpGained);
        playerJobManager.addPlayerMoneyEarned(player, jobName, moneyGained);
        if (moneyGained > 0.0 && (economy = (Economy)this.plugin.getServer().getServicesManager().getRegistration(Economy.class).getProvider()) != null) {
            economy.depositPlayer((OfflinePlayer)player, moneyGained);
        }
        UUID playerId = player.getUniqueId();
        double accumulatedXP = this.playerAccumulatedXP.getOrDefault(playerId, 0.0) + xpGained;
        double accumulatedMoney = this.playerAccumulatedMoney.getOrDefault(playerId, 0.0) + moneyGained;
        this.playerAccumulatedXP.put(playerId, accumulatedXP);
        this.playerAccumulatedMoney.put(playerId, accumulatedMoney);
        this.updateBossBarWithXPProgress(player, jobName, jobConfig, accumulatedXP, accumulatedMoney);
        this.lastActivityTime.put(player.getUniqueId(), System.currentTimeMillis());
    }

    private void updateBossBar(Player player, String jobName, FileConfiguration jobConfig, double xpGained, double moneyGained) {
        if (!jobConfig.getBoolean("MrUltimateJobs.Job.Progress.Bossbar.Enabled", false)) {
            return;
        }
        UUID playerId = player.getUniqueId();
        BossBar bossBar = this.playerBossBars.get(playerId);
        if (bossBar == null) {
            bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            this.playerBossBars.put(playerId, bossBar);
        }
        String title = jobConfig.getString("MrUltimateJobs.Job.Progress.Bossbar.Text", "");
        String colorStr = jobConfig.getString("MrUltimateJobs.Job.Progress.Bossbar.Color", "GREEN");
        String styleStr = jobConfig.getString("MrUltimateJobs.Job.Progress.Bossbar.Style", "SOLID");
        BarColor color = BarColor.GREEN;
        BarStyle style = BarStyle.SOLID;
        try {
            color = BarColor.valueOf((String)colorStr.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            style = BarStyle.valueOf((String)styleStr.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        bossBar.setColor(color);
        bossBar.setStyle(style);
        PlayerJobManager playerJobManager = this.plugin.getPlayerJobManager();
        int level = playerJobManager.getPlayerJobLevel(player, jobName);
        int maxLevel = playerJobManager.getMaxLevelForJob(jobName);
        if (level >= maxLevel) {
            title = title.replace("[Level]", String.valueOf(level)).replace("[XP]", "MAX").replace("[MONEY]", String.format("%.2f", moneyGained)).replace("[PlayerName]", player.getName());
            bossBar.setTitle(MrLibColors.colorize((String)title));
            bossBar.setProgress(1.0);
        } else {
            title = title.replace("[Level]", String.valueOf(level)).replace("[XP]", String.format("%.2f", xpGained)).replace("[MONEY]", String.format("%.2f", moneyGained)).replace("[PlayerName]", player.getName());
            bossBar.setTitle(MrLibColors.colorize((String)title));
            double currentXP = playerJobManager.getPlayerJobXP(player, jobName);
            int currentLevel = playerJobManager.getPlayerJobLevel(player, jobName);
            double xpNeededForNextLevel = this.getXPNeededForNextLevel(jobConfig, currentLevel);
            double progress = Math.min(1.0, currentXP / xpNeededForNextLevel);
            bossBar.setProgress(progress);
        }
        if (!bossBar.getPlayers().contains(player)) {
            bossBar.addPlayer(player);
        }
        bossBar.setVisible(true);
    }

    private void updateBossBarWithProgress(Player player, String jobName, FileConfiguration jobConfig, double xpGained, double moneyGained, int currentCount, int requiredActions) {
        if (!jobConfig.getBoolean("MrUltimateJobs.Job.Progress.Bossbar.Enabled", false)) {
            return;
        }
        UUID playerId = player.getUniqueId();
        BossBar bossBar = this.playerBossBars.get(playerId);
        if (bossBar == null) {
            bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            this.playerBossBars.put(playerId, bossBar);
        }
        String title = jobConfig.getString("MrUltimateJobs.Job.Progress.Bossbar.Text", "");
        String colorStr = jobConfig.getString("MrUltimateJobs.Job.Progress.Bossbar.Color", "GREEN");
        String styleStr = jobConfig.getString("MrUltimateJobs.Job.Progress.Bossbar.Style", "SOLID");
        BarColor color = BarColor.GREEN;
        BarStyle style = BarStyle.SOLID;
        try {
            color = BarColor.valueOf((String)colorStr.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            style = BarStyle.valueOf((String)styleStr.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        bossBar.setColor(color);
        bossBar.setStyle(style);
        PlayerJobManager playerJobManager = this.plugin.getPlayerJobManager();
        int level = playerJobManager.getPlayerJobLevel(player, jobName);
        title = title.replace("[Level]", String.valueOf(level)).replace("[XP]", String.format("%.2f", xpGained)).replace("[MONEY]", String.format("%.2f", moneyGained)).replace("[PlayerName]", player.getName()).replace("[Progress]", currentCount + "/" + requiredActions);
        bossBar.setTitle(MrLibColors.colorize((String)title));
        double progress = (double)currentCount / (double)requiredActions;
        bossBar.setProgress(progress);
        if (!bossBar.getPlayers().contains(player)) {
            bossBar.addPlayer(player);
        }
        bossBar.setVisible(true);
    }

    private void updateBossBarWithAccumulatedValues(Player player, String jobName, FileConfiguration jobConfig, double accumulatedXP, double accumulatedMoney, int currentCount) {
        if (!jobConfig.getBoolean("MrUltimateJobs.Job.Progress.Bossbar.Enabled", false)) {
            return;
        }
        UUID playerId = player.getUniqueId();
        BossBar bossBar = this.playerBossBars.get(playerId);
        if (bossBar == null) {
            bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            this.playerBossBars.put(playerId, bossBar);
        }
        String title = jobConfig.getString("MrUltimateJobs.Job.Progress.Bossbar.Text", "");
        String colorStr = jobConfig.getString("MrUltimateJobs.Job.Progress.Bossbar.Color", "GREEN");
        String styleStr = jobConfig.getString("MrUltimateJobs.Job.Progress.Bossbar.Style", "SOLID");
        BarColor color = BarColor.GREEN;
        BarStyle style = BarStyle.SOLID;
        try {
            color = BarColor.valueOf((String)colorStr.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            style = BarStyle.valueOf((String)styleStr.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        bossBar.setColor(color);
        bossBar.setStyle(style);
        PlayerJobManager playerJobManager = this.plugin.getPlayerJobManager();
        int level = playerJobManager.getPlayerJobLevel(player, jobName);
        title = title.replace("[Level]", String.valueOf(level)).replace("[XP]", String.format("%.2f", accumulatedXP)).replace("[MONEY]", String.format("%.2f", accumulatedMoney)).replace("[PlayerName]", player.getName()).replace("[Progress]", String.valueOf(currentCount));
        bossBar.setTitle(MrLibColors.colorize((String)title));
        int requiredActions = jobConfig.getInt("MrUltimateJobs.Job.System.Actions.RequiredAction", 10);
        double progress = Math.min(1.0, (double)currentCount / (double)requiredActions);
        bossBar.setProgress(progress);
        if (!bossBar.getPlayers().contains(player)) {
            bossBar.addPlayer(player);
        }
        bossBar.setVisible(true);
    }

    private void updateBossBarWithXPProgress(Player player, String jobName, FileConfiguration jobConfig, double accumulatedXP, double accumulatedMoney) {
        if (!jobConfig.getBoolean("MrUltimateJobs.Job.Progress.Bossbar.Enabled", false)) {
            return;
        }
        UUID playerId = player.getUniqueId();
        BossBar bossBar = this.playerBossBars.get(playerId);
        if (bossBar == null) {
            bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            this.playerBossBars.put(playerId, bossBar);
        }
        String title = jobConfig.getString("MrUltimateJobs.Job.Progress.Bossbar.Text", "");
        String colorStr = jobConfig.getString("MrUltimateJobs.Job.Progress.Bossbar.Color", "GREEN");
        String styleStr = jobConfig.getString("MrUltimateJobs.Job.Progress.Bossbar.Style", "SOLID");
        BarColor color = BarColor.GREEN;
        BarStyle style = BarStyle.SOLID;
        try {
            color = BarColor.valueOf((String)colorStr.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            style = BarStyle.valueOf((String)styleStr.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        bossBar.setColor(color);
        bossBar.setStyle(style);
        PlayerJobManager playerJobManager = this.plugin.getPlayerJobManager();
        int level = playerJobManager.getPlayerJobLevel(player, jobName);
        int maxLevel = playerJobManager.getMaxLevelForJob(jobName);
        double currentXP = playerJobManager.getPlayerJobXP(player, jobName);
        if (level >= maxLevel) {
            title = title.replace("[Level]", String.valueOf(level)).replace("[XP]", "MAX").replace("[MONEY]", String.format("%.2f", accumulatedMoney)).replace("[PlayerName]", player.getName());
            bossBar.setTitle(MrLibColors.colorize((String)title));
            bossBar.setProgress(1.0);
        } else {
            title = title.replace("[Level]", String.valueOf(level)).replace("[XP]", String.format("%.2f", accumulatedXP)).replace("[MONEY]", String.format("%.2f", accumulatedMoney)).replace("[PlayerName]", player.getName());
            bossBar.setTitle(MrLibColors.colorize((String)title));
            double xpNeededForNextLevel = this.getXPNeededForNextLevel(jobConfig, level);
            double progress = xpNeededForNextLevel > 0.0 ? Math.min(1.0, currentXP / xpNeededForNextLevel) : 0.0;
            bossBar.setProgress(progress);
        }
        if (!bossBar.getPlayers().contains(player)) {
            bossBar.addPlayer(player);
        }
        bossBar.setVisible(true);
    }

    private void startBossBarCleanupTask() {
        new BukkitRunnable(){

            public void run() {
                long currentTime = System.currentTimeMillis();
                double hideDelaySeconds = 1.5;
                for (UUID playerId : new HashMap<UUID, Long>(JobListener.this.lastActivityTime).keySet()) {
                    Long lastActivity = JobListener.this.lastActivityTime.get(playerId);
                    if (lastActivity == null || !((double)(currentTime - lastActivity) > hideDelaySeconds * 1000.0)) continue;
                    BossBar bossBar = JobListener.this.playerBossBars.get(playerId);
                    if (bossBar != null) {
                        bossBar.setVisible(false);
                    }
                    JobListener.this.playerAccumulatedXP.put(playerId, 0.0);
                    JobListener.this.playerAccumulatedMoney.put(playerId, 0.0);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    private boolean isWorldDisabled(String worldName) {
        List disabledWorlds = this.plugin.getConfig().getStringList("MrUltimateJobs.Settings.Disabled-Worlds");
        return disabledWorlds.contains(worldName);
    }

    private boolean isToolAllowed(FileConfiguration jobConfig, Material toolType) {
        List allowedTools = jobConfig.getStringList("MrUltimateJobs.Job.System.Actions.Allowed-Tools");
        if (allowedTools.isEmpty()) {
            return true;
        }
        for (String toolName : allowedTools) {
            try {
                Material material = Material.valueOf((String)toolName.trim().toUpperCase());
                if (material != toolType) continue;
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return false;
    }

    private double getXPNeededForNextLevel(FileConfiguration jobConfig, int currentLevel) {
        int nextLevel = currentLevel + 1;
        return jobConfig.getDouble("MrUltimateJobs.Job.System.Levels." + nextLevel, 100.0);
    }

    private double evaluateExpression(String expression, int level) {
        if (expression == null || expression.trim().isEmpty()) {
            return 0.0;
        }
        String processedExpression = expression.replace("[Level]", String.valueOf(level));
        try {
            return this.evaluateSimpleMath(processedExpression);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private double evaluateSimpleMath(String expression) {
        double result;
        double right;
        double left;
        int rightEnd;
        int leftStart;
        int operator;
        int opIndex;
        expression = ((String)expression).replaceAll("\\s+", "");
        while (((String)expression).contains("*") || ((String)expression).contains("/")) {
            int multIndex = ((String)expression).indexOf("*");
            int divIndex = ((String)expression).indexOf("/");
            opIndex = -1;
            operator = 32;
            if (multIndex != -1 && divIndex != -1) {
                opIndex = Math.min(multIndex, divIndex);
                operator = ((String)expression).charAt(opIndex);
            } else if (multIndex != -1) {
                opIndex = multIndex;
                operator = 42;
            } else if (divIndex != -1) {
                opIndex = divIndex;
                operator = 47;
            }
            if (opIndex == -1) break;
            leftStart = this.findNumberStart((String)expression, opIndex - 1);
            rightEnd = this.findNumberEnd((String)expression, opIndex + 1);
            left = Double.parseDouble(((String)expression).substring(leftStart, opIndex));
            right = Double.parseDouble(((String)expression).substring(opIndex + 1, rightEnd + 1));
            result = operator == 42 ? left * right : left / right;
            expression = ((String)expression).substring(0, leftStart) + result + ((String)expression).substring(rightEnd + 1);
        }
        while (((String)expression).contains("+") || ((String)expression).contains("-") && ((String)expression).indexOf("-") > 0) {
            int addIndex = ((String)expression).indexOf("+");
            int subIndex = ((String)expression).indexOf("-", 1);
            opIndex = -1;
            operator = 32;
            if (addIndex != -1 && subIndex != -1) {
                opIndex = Math.min(addIndex, subIndex);
                operator = ((String)expression).charAt(opIndex);
            } else if (addIndex != -1) {
                opIndex = addIndex;
                operator = 43;
            } else if (subIndex != -1) {
                opIndex = subIndex;
                operator = 45;
            }
            if (opIndex == -1) break;
            leftStart = this.findNumberStart((String)expression, opIndex - 1);
            rightEnd = this.findNumberEnd((String)expression, opIndex + 1);
            left = Double.parseDouble(((String)expression).substring(leftStart, opIndex));
            right = Double.parseDouble(((String)expression).substring(opIndex + 1, rightEnd + 1));
            result = operator == 43 ? left + right : left - right;
            expression = ((String)expression).substring(0, leftStart) + result + ((String)expression).substring(rightEnd + 1);
        }
        return Double.parseDouble((String)expression);
    }

    private int findNumberStart(String expression, int startIndex) {
        int index;
        for (index = startIndex; index >= 0 && (Character.isDigit(expression.charAt(index)) || expression.charAt(index) == '.'); --index) {
        }
        if (!(index < 0 || expression.charAt(index) != '-' || index != 0 && Character.isDigit(expression.charAt(index - 1)))) {
            --index;
        }
        return index + 1;
    }

    private int findNumberEnd(String expression, int startIndex) {
        int index;
        for (index = startIndex; index < expression.length() && (Character.isDigit(expression.charAt(index)) || expression.charAt(index) == '.'); ++index) {
        }
        return index - 1;
    }

    public void cleanup() {
        for (BossBar bossBar : this.playerBossBars.values()) {
            for (Player player : bossBar.getPlayers()) {
                bossBar.removePlayer(player);
            }
            bossBar.removeAll();
        }
        this.playerBossBars.clear();
        this.lastActivityTime.clear();
        this.playerMoneyActionCounts.clear();
        this.playerXPActionCounts.clear();
        this.playerAccumulatedXP.clear();
        this.playerAccumulatedMoney.clear();
    }

    public void resetPlayerAccumulatedValues(Player player) {
        UUID playerId = player.getUniqueId();
        this.playerAccumulatedXP.put(playerId, 0.0);
        this.playerAccumulatedMoney.put(playerId, 0.0);
    }
}

