/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BoosterManager
implements Listener {
    private final MrUltimateJobs plugin;
    private FileConfiguration boostersConfig;
    private final Map<UUID, Map<BoosterType, ActiveBooster>> activeBoosters;

    public BoosterManager(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.boostersConfig = plugin.getConfigManager().getBoostersConfig();
        this.activeBoosters = new ConcurrentHashMap<UUID, Map<BoosterType, ActiveBooster>>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.loadActiveBoosters();
    }

    public ItemStack createBoosterItem(int boosterId) {
        ConfigurationSection customModelData;
        Material material;
        ConfigurationSection boosterSection = this.boostersConfig.getConfigurationSection("MrUltimateJobs.Boosters." + boosterId);
        if (boosterSection == null) {
            return null;
        }
        ConfigurationSection itemSection = boosterSection.getConfigurationSection("Item");
        if (itemSection == null) {
            return null;
        }
        String materialName = itemSection.getString("material", "DIAMOND_SWORD");
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            material = Material.DIAMOND_SWORD;
        }
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        String displayName = itemSection.getString("display-name", "&6Booster");
        displayName = MrLibColors.colorize((String)displayName);
        meta.setDisplayName(displayName);
        List lore = itemSection.getStringList("lore");
        ArrayList<String> coloredLore = new ArrayList<String>();
        for (String line : lore) {
            line = MrLibColors.colorize((String)line);
            ConfigurationSection booster = boosterSection.getConfigurationSection("Booster");
            if (booster != null) {
                double value = booster.getDouble("value", 1.0);
                int duration = booster.getInt("duration", 60);
                String rarity = booster.getString("rarity", "");
                line = this.replacePlaceholder(line, "value", String.valueOf(value));
                line = this.replacePlaceholder(line, "duration", String.valueOf(duration));
                line = this.replacePlaceholder(line, "rarity", rarity);
                line = this.replacePlaceholder(line, "Value", String.valueOf(value));
                line = this.replacePlaceholder(line, "Duration", String.valueOf(duration));
                line = this.replacePlaceholder(line, "Rarity", rarity);
            }
            coloredLore.add(line);
        }
        meta.setLore(coloredLore);
        if (itemSection.getBoolean("glowing", false)) {
            meta.addEnchant(Enchantment.LURE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if ((customModelData = itemSection.getConfigurationSection("custom-model-data")) != null && customModelData.getBoolean("enabled", false)) {
            meta.setCustomModelData(Integer.valueOf(customModelData.getInt("value", 0)));
        }
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        NamespacedKey boosterKey = new NamespacedKey((Plugin)this.plugin, "booster_id");
        dataContainer.set(boosterKey, PersistentDataType.INTEGER, (Object)boosterId);
        item.setItemMeta(meta);
        return item;
    }

    private String replacePlaceholder(String text, String placeholder, String value) {
        if (text == null || placeholder == null || value == null) {
            return text;
        }
        text = text.replace("%" + placeholder + "%", value);
        text = text.replace("[" + placeholder + "]", value);
        text = text.replace("{" + placeholder + "}", value);
        text = text.replace("<" + placeholder + ">", value);
        return text;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        NamespacedKey boosterKey;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        if (!dataContainer.has(boosterKey = new NamespacedKey((Plugin)this.plugin, "booster_id"), PersistentDataType.INTEGER)) {
            return;
        }
        if (!event.getAction().name().contains("RIGHT_CLICK")) {
            return;
        }
        event.setCancelled(true);
        int boosterId = (Integer)dataContainer.get(boosterKey, PersistentDataType.INTEGER);
        this.activateBooster(player, boosterId);
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            player.getInventory().setItemInMainHand(null);
        }
    }

    public boolean activateBooster(final Player player, int boosterId) {
        BoosterType type;
        ConfigurationSection boosterSection = this.boostersConfig.getConfigurationSection("MrUltimateJobs.Boosters." + boosterId);
        if (boosterSection == null) {
            return false;
        }
        ConfigurationSection booster = boosterSection.getConfigurationSection("Booster");
        if (booster == null) {
            return false;
        }
        String typeString = booster.getString("type", "XP").toUpperCase();
        try {
            type = BoosterType.valueOf(typeString);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        double value = booster.getDouble("value", 1.0);
        String rarity = booster.getString("rarity", "");
        int durationSeconds = booster.getInt("duration", 60);
        long durationMs = (long)durationSeconds * 1000L;
        Map playerBoosters = this.activeBoosters.computeIfAbsent(player.getUniqueId(), k -> new HashMap());
        if (playerBoosters.containsKey((Object)type)) {
            ActiveBooster existingBooster = (ActiveBooster)playerBoosters.get((Object)type);
            if (Math.abs(existingBooster.getValue() - value) < 0.001) {
                existingBooster.extendDuration(durationMs);
                String message = this.plugin.getMessageManager().getMessage("boosters.extended", "Type", type.name(), "Duration", String.valueOf(durationSeconds));
                this.plugin.sendMessage(player, message);
                return true;
            }
            String message = this.plugin.getMessageManager().getMessage("boosters.conflict", "Type", type.name().toLowerCase());
            this.plugin.sendMessage(player, message);
            return false;
        }
        ActiveBooster activeBooster = new ActiveBooster(type, value, rarity, durationMs);
        playerBoosters.put(type, activeBooster);
        this.saveActiveBoosters();
        String message = this.plugin.getMessageManager().getMessage("boosters.activated", "Type", type.name(), "Value", String.valueOf(value), "Duration", String.valueOf(durationSeconds));
        this.plugin.sendMessage(player, message);
        new BukkitRunnable(){

            public void run() {
                Map<BoosterType, ActiveBooster> boosters = BoosterManager.this.activeBoosters.get(player.getUniqueId());
                if (boosters != null) {
                    boosters.remove((Object)type);
                    if (boosters.isEmpty()) {
                        BoosterManager.this.activeBoosters.remove(player.getUniqueId());
                    }
                }
                if (player.isOnline()) {
                    String expiredMessage = BoosterManager.this.plugin.getMessageManager().getMessage("boosters.expired", "Type", type.name().toLowerCase());
                    BoosterManager.this.plugin.sendMessage(player, expiredMessage);
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)durationSeconds * 20L);
        return true;
    }

    public double getBoosterMultiplier(Player player, BoosterType type) {
        Map<BoosterType, ActiveBooster> playerBoosters = this.activeBoosters.get(player.getUniqueId());
        if (playerBoosters == null) {
            return 1.0;
        }
        ActiveBooster booster = playerBoosters.get((Object)type);
        if (booster == null || booster.isExpired()) {
            if (booster != null) {
                playerBoosters.remove((Object)type);
                if (playerBoosters.isEmpty()) {
                    this.activeBoosters.remove(player.getUniqueId());
                }
            }
            return 1.0;
        }
        return booster.getValue();
    }

    public double getXPMultiplier(Player player) {
        return this.getBoosterMultiplier(player, BoosterType.XP);
    }

    public double getMoneyMultiplier(Player player) {
        return this.getBoosterMultiplier(player, BoosterType.MONEY);
    }

    public Map<BoosterType, ActiveBooster> getActiveBoosters(Player player) {
        Map<BoosterType, ActiveBooster> playerBoosters = this.activeBoosters.get(player.getUniqueId());
        if (playerBoosters == null) {
            return new HashMap<BoosterType, ActiveBooster>();
        }
        playerBoosters.entrySet().removeIf(entry -> ((ActiveBooster)entry.getValue()).isExpired());
        if (playerBoosters.isEmpty()) {
            this.activeBoosters.remove(player.getUniqueId());
            return new HashMap<BoosterType, ActiveBooster>();
        }
        return new HashMap<BoosterType, ActiveBooster>(playerBoosters);
    }

    public void cleanupExpiredBoosters() {
        this.activeBoosters.entrySet().removeIf(entry -> {
            Map playerBoosters = (Map)entry.getValue();
            playerBoosters.entrySet().removeIf(boosterEntry -> ((ActiveBooster)boosterEntry.getValue()).isExpired());
            return playerBoosters.isEmpty();
        });
    }

    public void onPlayerQuit(Player player) {
        this.activeBoosters.remove(player.getUniqueId());
    }

    public Set<String> getAvailableBoosterIds() {
        ConfigurationSection boostersSection = this.boostersConfig.getConfigurationSection("MrUltimateJobs.Boosters");
        if (boostersSection != null) {
            return boostersSection.getKeys(false);
        }
        return new HashSet<String>();
    }

    private void loadActiveBoosters() {
        File activeBoostersFile = new File(this.plugin.getDataFolder(), "active-boosters.yml");
        if (activeBoostersFile.exists()) {
            YamlConfiguration activeBoostersConfig = YamlConfiguration.loadConfiguration((File)activeBoostersFile);
            for (String playerUuidStr : activeBoostersConfig.getKeys(false)) {
                try {
                    final UUID playerUuid = UUID.fromString(playerUuidStr);
                    HashMap<BoosterType, ActiveBooster> playerBoosters = new HashMap<BoosterType, ActiveBooster>();
                    ConfigurationSection playerSection = activeBoostersConfig.getConfigurationSection(playerUuidStr);
                    if (playerSection != null) {
                        for (String boosterTypeStr : playerSection.getKeys(false)) {
                            try {
                                long endTime;
                                final BoosterType boosterType = BoosterType.valueOf(boosterTypeStr.toUpperCase());
                                ConfigurationSection boosterSection = playerSection.getConfigurationSection(boosterTypeStr);
                                if (boosterSection == null) continue;
                                double value = boosterSection.getDouble("value", 1.0);
                                String rarity = boosterSection.getString("rarity", "");
                                long startTime = boosterSection.getLong("start-time", System.currentTimeMillis());
                                long duration = boosterSection.getLong("duration", 0L);
                                long currentTime = System.currentTimeMillis();
                                if (currentTime >= (endTime = startTime + duration)) continue;
                                ActiveBooster booster = new ActiveBooster(boosterType, value, rarity, duration);
                                booster.startTime = startTime;
                                playerBoosters.put(boosterType, booster);
                                long remainingTime = (endTime - currentTime) / 1000L;
                                if (remainingTime <= 0L) continue;
                                new BukkitRunnable(){

                                    public void run() {
                                        Player player;
                                        Map<BoosterType, ActiveBooster> boosters = BoosterManager.this.activeBoosters.get(playerUuid);
                                        if (boosters != null) {
                                            boosters.remove((Object)boosterType);
                                            if (boosters.isEmpty()) {
                                                BoosterManager.this.activeBoosters.remove(playerUuid);
                                            }
                                        }
                                        if ((player = Bukkit.getPlayer((UUID)playerUuid)) != null && player.isOnline()) {
                                            String expiredMessage = BoosterManager.this.plugin.getMessageManager().getMessage("boosters.expired", "Type", boosterType.name().toLowerCase());
                                            BoosterManager.this.plugin.sendMessage(player, expiredMessage);
                                        }
                                    }
                                }.runTaskLater((Plugin)this.plugin, remainingTime * 20L);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                    }
                    if (playerBoosters.isEmpty()) continue;
                    this.activeBoosters.put(playerUuid, playerBoosters);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (!this.activeBoosters.isEmpty()) {
                // empty if block
            }
        }
    }

    private void saveActiveBoosters() {
        File activeBoostersFile = new File(this.plugin.getDataFolder(), "active-boosters.yml");
        YamlConfiguration activeBoostersConfig = new YamlConfiguration();
        for (Map.Entry<UUID, Map<BoosterType, ActiveBooster>> entry : this.activeBoosters.entrySet()) {
            String playerUuidStr = entry.getKey().toString();
            Map<BoosterType, ActiveBooster> playerBoosters = entry.getValue();
            for (Map.Entry<BoosterType, ActiveBooster> boosterEntry : playerBoosters.entrySet()) {
                BoosterType boosterType = boosterEntry.getKey();
                ActiveBooster booster = boosterEntry.getValue();
                String path = playerUuidStr + "." + boosterType.name().toLowerCase();
                activeBoostersConfig.set(path + ".value", (Object)booster.getValue());
                activeBoostersConfig.set(path + ".rarity", (Object)booster.getRarity());
                activeBoostersConfig.set(path + ".start-time", (Object)booster.startTime);
                activeBoostersConfig.set(path + ".duration", (Object)booster.getDuration());
            }
        }
        try {
            activeBoostersConfig.save(activeBoostersFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reloadConfig() {
        this.boostersConfig = this.plugin.getConfigManager().getBoostersConfig();
    }

    public void shutdown() {
        this.saveActiveBoosters();
        this.activeBoosters.clear();
    }

    public static enum BoosterType {
        XP,
        MONEY,
        LEVEL;

    }

    public static class ActiveBooster {
        private final BoosterType type;
        private final double value;
        private final String rarity;
        private long startTime;
        private long duration;

        public ActiveBooster(BoosterType type, double value, String rarity, long duration) {
            this.type = type;
            this.value = value;
            this.rarity = rarity;
            this.startTime = System.currentTimeMillis();
            this.duration = duration;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.startTime + this.duration;
        }

        public long getRemainingTime() {
            long remaining = this.startTime + this.duration - System.currentTimeMillis();
            return Math.max(0L, remaining);
        }

        public void extendDuration(long additionalDuration) {
            this.duration += additionalDuration;
        }

        public BoosterType getType() {
            return this.type;
        }

        public double getValue() {
            return this.value;
        }

        public String getRarity() {
            return this.rarity;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

