/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.managers;

import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataManager {
    private final MrUltimateJobs plugin;
    private FileConfiguration dataConfig;
    private File dataFile;

    public DataManager(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "data.yml");
        this.loadData();
    }

    public void loadData() {
        if (this.dataFile.exists()) {
            this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        } else {
            this.dataConfig = new YamlConfiguration();
            this.dataConfig.set("filesCreated", (Object)false);
            this.saveData();
        }
    }

    public void saveData() {
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean areFilesCreated() {
        return this.dataConfig.getBoolean("filesCreated", false);
    }

    public void markFilesAsCreated() {
        this.dataConfig.set("filesCreated", (Object)true);
        this.saveData();
    }

    public void resetFilesCreated() {
        this.dataConfig.set("filesCreated", (Object)false);
        this.saveData();
    }

    public void createDefaultFilesIfNotExists() {
        File menusFolder;
        if (this.areFilesCreated()) {
            return;
        }
        File jobsFolder = new File(this.plugin.getDataFolder(), "Jobs");
        if (!jobsFolder.exists()) {
            jobsFolder.mkdirs();
        }
        if (!(menusFolder = new File(this.plugin.getDataFolder(), "Menus")).exists()) {
            menusFolder.mkdirs();
        }
        this.copyResourceFile("config.yml");
        this.copyResourceFile("messages.yml");
        this.copyResourceFile("tournaments.yml");
        this.copyResourceFile("boosters.yml");
        this.copyResourceFile("events.yml");
        this.copyResourceFile("Menus/headmenu.yml");
        this.copyResourceFile("Menus/rewards.yml");
        this.copyResourceFileForce("Menus/top.yml");
        this.copyResourceFile("Jobs/farmer.yml");
        this.copyResourceFile("Jobs/builder.yml");
        this.copyResourceFile("Jobs/fisher.yml");
        this.copyResourceFile("Jobs/lumberjack.yml");
        this.copyResourceFile("Jobs/enchanter.yml");
        this.copyResourceFile("Jobs/warrior.yml");
        this.copyResourceFile("Jobs/examplejob.yml");
        this.markFilesAsCreated();
    }

    private void copyResourceFile(String resourcePath) {
        File targetFile = new File(this.plugin.getDataFolder(), resourcePath);
        File parentDir = targetFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (!targetFile.exists()) {
            try {
                InputStream inputStream = this.plugin.getResource(resourcePath.replace("\\", "/"));
                if (inputStream != null) {
                    Files.copy(inputStream, targetFile.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void copyResourceFileForce(String resourcePath) {
        File targetFile = new File(this.plugin.getDataFolder(), resourcePath);
        File parentDir = targetFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        try {
            InputStream inputStream = this.plugin.getResource(resourcePath.replace("\\", "/"));
            if (inputStream != null) {
                if (targetFile.exists()) {
                    targetFile.delete();
                }
                Files.copy(inputStream, targetFile.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not copy resource file: " + resourcePath);
        }
    }
}

