/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import java.io.File;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManager {
    private final MrUltimateJobs plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public MessageManager(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void reloadConfig() {
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString("MrUltimateJobs." + path);
        if (message == null) {
            message = this.messagesConfig.getString(path);
        }
        if (message == null) {
            return "&cMessage not found: " + path;
        }
        String prefixRaw = this.messagesConfig.getString("MrUltimateJobs.Prefix");
        if (prefixRaw == null) {
            prefixRaw = this.messagesConfig.getString("MrUltimateJobs.prefix");
        }
        if (prefixRaw == null) {
            prefixRaw = this.messagesConfig.getString("prefix", "&8[&6MrUltimateJobs&8] ");
        }
        if ((message = message.replace("{prefix}", prefixRaw)).contains("(!message!)") && !message.contains(prefixRaw)) {
            message = message.replace("(!message!)", "(!message!)" + prefixRaw);
        }
        return MrLibColors.colorize((String)message);
    }

    public String getMessage(String path, String ... replacements) {
        String message = this.messagesConfig.getString("MrUltimateJobs." + path);
        if (message == null) {
            message = this.messagesConfig.getString(path);
        }
        if (message == null) {
            return "&cMessage not found: " + path;
        }
        String prefixRaw = this.messagesConfig.getString("MrUltimateJobs.Prefix");
        if (prefixRaw == null) {
            prefixRaw = this.messagesConfig.getString("MrUltimateJobs.prefix");
        }
        if (prefixRaw == null) {
            prefixRaw = this.messagesConfig.getString("prefix", "&8[&6MrUltimateJobs&8] ");
        }
        if ((message = message.replace("{prefix}", prefixRaw)).contains("(!message!)") && !message.contains(prefixRaw)) {
            message = message.replace("(!message!)", "(!message!)" + prefixRaw);
        }
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            String placeholder = replacements[i];
            String value = replacements[i + 1];
            message = message.replace("[" + placeholder + "]", value);
            message = message.replace("{" + placeholder + "}", value);
            message = message.replace("%" + placeholder + "%", value);
            message = message.replace("<" + placeholder + ">", value);
        }
        return MrLibColors.colorize((String)message);
    }

    public void sendMessage(CommandSender sender, String key) {
        if (sender instanceof Player) {
            this.plugin.sendMessage((Player)sender, this.getMessage(key));
        } else {
            sender.sendMessage(MrLibColors.colorize((String)this.getMessage(key)));
        }
    }

    public void sendMessage(CommandSender sender, String key, String ... replacements) {
        if (sender instanceof Player) {
            this.plugin.sendMessage((Player)sender, this.getMessage(key, replacements));
        } else {
            sender.sendMessage(MrLibColors.colorize((String)this.getMessage(key, replacements)));
        }
    }

    public void loadMessages() {
        this.reloadConfig();
    }

    public List<String> getMessageList(String path) {
        List messages = this.messagesConfig.getStringList("MrUltimateJobs." + path);
        if (messages.isEmpty()) {
            messages = this.messagesConfig.getStringList(path);
        }
        if (messages.isEmpty()) {
            return List.of("&cMessage list not found: " + path);
        }
        String prefixRaw = this.messagesConfig.getString("MrUltimateJobs.Prefix");
        if (prefixRaw == null) {
            prefixRaw = this.messagesConfig.getString("MrUltimateJobs.prefix");
        }
        if (prefixRaw == null) {
            prefixRaw = this.messagesConfig.getString("prefix", "&8[&6MrUltimateJobs&8] ");
        }
        String finalPrefix = prefixRaw;
        return messages.stream().map(message -> message.replace("{prefix}", finalPrefix)).map(MrLibColors::colorize).toList();
    }

    public String getPrefix() {
        String prefixRaw = this.messagesConfig.getString("MrUltimateJobs.Prefix");
        if (prefixRaw == null) {
            prefixRaw = this.messagesConfig.getString("MrUltimateJobs.prefix");
        }
        if (prefixRaw == null) {
            prefixRaw = this.messagesConfig.getString("prefix", "&8[&6MrUltimateJobs&8] ");
        }
        return prefixRaw;
    }
}

