/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatejobs.menus;

import eu.mrneznamy.mrlibcore.gui.MrLibGUI;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatejobs.MrUltimateJobs;
import eu.mrneznamy.mrultimatejobs.menus.TopPlayerData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MenuManager {
    private final MrUltimateJobs plugin;
    private FileConfiguration menuConfig;
    private FileConfiguration rewardsConfig;
    private FileConfiguration topConfig;
    private final ConcurrentHashMap<UUID, Integer> rewardsPage = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, String> currentRewardsJob = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Integer> topPage = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, String> currentTopJob = new ConcurrentHashMap();

    public MenuManager(MrUltimateJobs plugin) {
        this.plugin = plugin;
        this.loadMenuConfig();
        this.loadRewardsConfig();
        this.loadTopConfig();
    }

    public void loadMenuConfig() {
        File menuFile = new File(this.plugin.getDataFolder(), "Menus/headmenu.yml");
        if (menuFile.exists()) {
            this.menuConfig = YamlConfiguration.loadConfiguration((File)menuFile);
        }
    }

    public void loadRewardsConfig() {
        File rewardsFile = new File(this.plugin.getDataFolder(), "Menus/rewards.yml");
        if (rewardsFile.exists()) {
            this.rewardsConfig = YamlConfiguration.loadConfiguration((File)rewardsFile);
        }
    }

    public void loadTopConfig() {
        File topFile = new File(this.plugin.getDataFolder(), "Menus/top.yml");
        if (topFile.exists()) {
            this.topConfig = YamlConfiguration.loadConfiguration((File)topFile);
        }
    }

    public void openHeadMenu(Player player) {
        if (this.menuConfig == null) {
            this.loadMenuConfig();
            if (this.menuConfig == null) {
                this.plugin.sendMessage(player, "&cMenu configuration not found!");
                return;
            }
        }
        String title = this.menuConfig.getString("MrUltimateJobs.HeadMenu.title", "Jobs Menu");
        int size = this.menuConfig.getInt("MrUltimateJobs.HeadMenu.size", 54);
        int rows = size / 9;
        MrLibGUI gui = new MrLibGUI(MrLibColors.colorize((String)title), rows);
        boolean hideInfoGlobal = this.menuConfig.getBoolean("MrUltimateJobs.HeadMenu.disable-item-info", false);
        if (this.menuConfig.contains("MrUltimateJobs.HeadMenu.decorations")) {
            for (String decorationKey : this.menuConfig.getConfigurationSection("MrUltimateJobs.HeadMenu.decorations").getKeys(false)) {
                this.addDecoration(gui, decorationKey, "headmenu", player, null);
            }
        }
        if (this.menuConfig.contains("MrUltimateJobs.HeadMenu.items")) {
            this.addConfiguredHeadItems(gui, player);
        } else {
            Set<String> jobNames = this.plugin.getJobManager().getJobNames();
            int slot = 19;
            for (String jobName : jobNames) {
                if (slot >= 36) break;
                this.addJobItem(gui, jobName, slot, player);
                if (++slot == 25) {
                    slot = 28;
                }
                if (slot != 34) continue;
                slot = 37;
            }
        }
        gui.open(player);
    }

    private void addConfiguredHeadItems(MrLibGUI gui, Player player) {
        Inventory inventory = gui.getInventory();
        ConfigurationSection section = this.menuConfig.getConfigurationSection("MrUltimateJobs.HeadMenu.items");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ItemStack item;
            ItemMeta meta;
            Material material;
            String path = "MrUltimateJobs.HeadMenu.items." + key;
            String configuredJob = this.menuConfig.getString(path + ".job", key);
            String jobName = null;
            for (String loaded : this.plugin.getJobManager().getJobNames()) {
                if (!loaded.equalsIgnoreCase(configuredJob)) continue;
                jobName = loaded;
                break;
            }
            if (jobName == null) continue;
            Object displayName = this.menuConfig.getString(path + ".display-name", this.plugin.getJobManager().getJobConfig(jobName).getString("MrUltimateJobs.Job.Name", "&f" + jobName));
            String materialName = this.menuConfig.getString(path + ".material", this.getJobMaterial(jobName));
            int slot = this.menuConfig.getInt(path + ".slot", -1);
            List customLore = this.menuConfig.getStringList(path + ".lore");
            boolean glowing = this.menuConfig.getBoolean(path + ".glowing", false);
            boolean cmdEnabled = this.menuConfig.getBoolean(path + ".custom-model-data.enabled", false);
            int cmdValue = this.menuConfig.getInt(path + ".custom-model-data.value", 0);
            boolean hideInfo = this.menuConfig.getBoolean(path + ".disable-item-info", this.menuConfig.getBoolean("MrUltimateJobs.HeadMenu.disable-item-info", false));
            FileConfiguration jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
            if (jobConfig == null) continue;
            boolean isInJob = this.plugin.getPlayerJobManager().isPlayerInJob(player, jobName);
            if (isInJob) {
                displayName = "&a" + (String)displayName + " " + this.plugin.getMessageManager().getMessage("general.your-job");
            }
            if ((material = Material.getMaterial((String)materialName.toUpperCase())) == null) {
                material = Material.PAPER;
            }
            if ((meta = (item = new ItemStack(material)).getItemMeta()) != null) {
                meta.setDisplayName(MrLibColors.colorize((String)this.stripMessageTags(this.replaceCommonPlaceholders((String)displayName, player, jobName, jobConfig))));
                try {
                    NamespacedKey jobKey = new NamespacedKey((Plugin)this.plugin, "job");
                    PersistentDataContainer pdc = meta.getPersistentDataContainer();
                    pdc.set(jobKey, PersistentDataType.STRING, (Object)jobName);
                }
                catch (Throwable jobKey) {
                    // empty catch block
                }
                if (hideInfo) {
                    try {
                        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_ENCHANTS});
                    }
                    catch (Throwable jobKey) {
                        // empty catch block
                    }
                }
                ArrayList<String> lore = new ArrayList<String>();
                if (customLore != null && !customLore.isEmpty()) {
                    int employedCount = this.plugin.getPlayerJobManager().getEmployedCount(jobName);
                    int playerLevelStat = this.plugin.getPlayerJobManager().isPlayerInJob(player, jobName) ? this.plugin.getPlayerJobManager().getPlayerJobLevel(player, jobName) : 0;
                    int maxLevelStat = 1;
                    if (jobConfig.contains("MrUltimateJobs.Job.System.Levels")) {
                        Set levelKeys = jobConfig.getConfigurationSection("MrUltimateJobs.Job.System.Levels").getKeys(false);
                        for (String levelStr : levelKeys) {
                            try {
                                int lvl = Integer.parseInt(levelStr);
                                if (lvl <= maxLevelStat) continue;
                                maxLevelStat = lvl;
                            }
                            catch (NumberFormatException lvl) {}
                        }
                    }
                    double playerXPStat = this.plugin.getPlayerJobManager().isPlayerInJob(player, jobName) ? this.plugin.getPlayerJobManager().getPlayerJobXP(player, jobName) : 0.0;
                    int nextLevel = Math.min(playerLevelStat + 1, maxLevelStat);
                    int xpNeedStat = jobConfig.getInt("MrUltimateJobs.Job.System.Levels." + nextLevel, 0);
                    double xpToNextStat = Math.max(0.0, (double)xpNeedStat - playerXPStat);
                    for (String line : customLore) {
                        String replaced = line.replace("[Job]", jobName).replace("[Employed]", String.valueOf(employedCount)).replace("[PlayerLevel]", String.valueOf(playerLevelStat)).replace("[MaxLevel]", String.valueOf(maxLevelStat)).replace("[JobXP]", String.format("%.1f", playerXPStat)).replace("[JobXPNeed]", String.valueOf(xpNeedStat)).replace("[XPToNext]", String.format("%.1f", xpToNextStat));
                        lore.add(MrLibColors.colorize((String)this.stripMessageTags(replaced)));
                    }
                } else {
                    lore.add("");
                    if (isInJob) {
                        int playerLevel = this.plugin.getPlayerJobManager().getPlayerJobLevel(player, jobName);
                        int maxLevel = 1;
                        if (jobConfig.contains("MrUltimateJobs.Job.System.Levels")) {
                            Set levelKeys = jobConfig.getConfigurationSection("MrUltimateJobs.Job.System.Levels").getKeys(false);
                            for (String levelStr : levelKeys) {
                                try {
                                    int lvl = Integer.parseInt(levelStr);
                                    if (lvl <= maxLevel) continue;
                                    maxLevel = lvl;
                                }
                                catch (NumberFormatException lvl) {}
                            }
                        }
                        int xpNeededForNextLevel = jobConfig.getInt("MrUltimateJobs.Job.System.Levels." + (playerLevel + 1), 0);
                        double playerXP = this.plugin.getPlayerJobManager().getPlayerJobXP(player, jobName);
                        double xpToNextLevel = Math.max(0.0, (double)xpNeededForNextLevel - playerXP);
                        int employedCount = this.plugin.getPlayerJobManager().getEmployedCount(jobName);
                        lore.add(MrLibColors.colorize((String)("&7Employed: &e" + employedCount)));
                        lore.add(MrLibColors.colorize((String)("&7Level: &e" + playerLevel + "&7/&e" + maxLevel)));
                        lore.add(MrLibColors.colorize((String)("&7XP: &c" + String.format("%.1f", playerXP) + "&7/&c" + xpNeededForNextLevel)));
                        lore.add(MrLibColors.colorize((String)("&7XP to next level: &c" + String.format("%.1f", xpToNextLevel))));
                        lore.add("");
                        lore.add(MrLibColors.colorize((String)"&cRight click &7| &fTo leave this job!"));
                        lore.add(MrLibColors.colorize((String)"&eDrop (Q) &7| &fTo view rewards!"));
                    } else {
                        int maxLevel = 1;
                        if (jobConfig.contains("MrUltimateJobs.Job.System.Levels")) {
                            Set levelKeys = jobConfig.getConfigurationSection("MrUltimateJobs.Job.System.Levels").getKeys(false);
                            for (String levelStr : levelKeys) {
                                try {
                                    int lvl = Integer.parseInt(levelStr);
                                    if (lvl <= maxLevel) continue;
                                    maxLevel = lvl;
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        }
                        int employedCount = this.plugin.getPlayerJobManager().getEmployedCount(jobName);
                        lore.add(MrLibColors.colorize((String)("&7Employed: &e" + employedCount)));
                        lore.add(MrLibColors.colorize((String)("&7Max Level: &e" + maxLevel)));
                        lore.add(MrLibColors.colorize((String)"&eLeft click &7| &fTo join this job!"));
                        lore.add(MrLibColors.colorize((String)"&cRight click &7| &fTo view details!"));
                        lore.add(MrLibColors.colorize((String)"&eDrop (Q) &7| &fTo view rewards!"));
                    }
                }
                meta.setLore(lore);
                if (cmdEnabled) {
                    try {
                        meta.setCustomModelData(Integer.valueOf(cmdValue));
                    }
                    catch (Throwable maxLevel) {
                        // empty catch block
                    }
                }
                if (glowing) {
                    try {
                        Enchantment glow = this.getGlowEnchant();
                        if (glow != null) {
                            meta.addEnchant(glow, 1, true);
                            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        }
                    }
                    catch (Throwable glow) {
                        // empty catch block
                    }
                }
                item.setItemMeta(meta);
            }
            if (slot < 0 || slot >= gui.getInventory().getSize()) continue;
            String finalJobName = jobName;
            boolean finalIsInJob = isInJob;
            gui.setItem(slot, item, event -> {
                Player clicker = (Player)event.getWhoClicked();
                event.setCancelled(true);
                ClickType clickType = event.getClick();
                if (clickType == ClickType.DROP || clickType == ClickType.CONTROL_DROP || event.isShiftClick() && event.isLeftClick()) {
                    this.openRewardsMenu(clicker, finalJobName);
                    return;
                }
                if (event.isLeftClick()) {
                    if (finalIsInJob) {
                        String msg = this.plugin.getMessageManager().getMessage("general.already-in-job").replace("[Job]", finalJobName);
                        this.plugin.sendMessage(clicker, msg);
                    } else {
                        clicker.closeInventory();
                        clicker.performCommand("jobs join " + finalJobName);
                    }
                } else if (event.isRightClick()) {
                    if (finalIsInJob) {
                        clicker.closeInventory();
                        clicker.performCommand("jobs leave " + finalJobName);
                    } else {
                        this.openHeadMenu(clicker);
                    }
                }
            });
        }
    }

    public void openRewardsMenu(Player player, String jobName) {
        this.openRewardsMenu(player, jobName, 0);
    }

    public void openRewardsMenu(Player player, String jobName, int page) {
        FileConfiguration jobConfig;
        if (this.rewardsConfig == null) {
            this.loadRewardsConfig();
            if (this.rewardsConfig == null) {
                this.plugin.sendMessage(player, "&cRewards configuration not found!");
                return;
            }
        }
        if ((jobConfig = this.plugin.getJobManager().getJobConfig(jobName)) == null) {
            this.plugin.getMessageManager().sendMessage((CommandSender)player, "general.job-not-found", "Job", jobName);
            return;
        }
        String title = this.rewardsConfig.getString("MrUltimateJobs.Rewards.title", "Jobs Rewards");
        String jobDisplay = jobConfig.getString("MrUltimateJobs.Job.JobConfigName", jobName);
        title = title.replace("[Job]", jobDisplay).replace("[JobName]", jobDisplay);
        int size = this.rewardsConfig.getInt("MrUltimateJobs.Rewards.size", 54);
        int rows = size / 9;
        MrLibGUI gui = new MrLibGUI(MrLibColors.colorize((String)title), rows);
        this.rewardsPage.put(player.getUniqueId(), Math.max(0, page));
        this.currentRewardsJob.put(player.getUniqueId(), jobName);
        if (this.rewardsConfig.contains("MrUltimateJobs.Rewards.decorations")) {
            for (String decorationKey : this.rewardsConfig.getConfigurationSection("MrUltimateJobs.Rewards.decorations").getKeys(false)) {
                this.addDecoration(gui, decorationKey, "rewards", player, jobName);
            }
        }
        if (this.rewardsConfig.contains("MrUltimateJobs.Rewards.keys")) {
            for (String keyKey : this.rewardsConfig.getConfigurationSection("MrUltimateJobs.Rewards.keys").getKeys(false)) {
                this.addKeyItem(gui, keyKey, player, jobName);
            }
        }
        this.addRewardItems(gui, jobName, player, this.rewardsPage.get(player.getUniqueId()));
        gui.open(player);
    }

    private void addDecoration(MrLibGUI gui, String decorationKey, String menuType, Player player, String jobName) {
        ItemStack item;
        ItemMeta meta;
        Inventory inventory = gui.getInventory();
        String path = "MrUltimateJobs." + (menuType.equals("headmenu") ? "HeadMenu" : "Rewards") + ".decorations." + decorationKey;
        FileConfiguration config = menuType.equals("headmenu") ? this.menuConfig : this.rewardsConfig;
        String materialName = config.getString(path + ".material", "STONE");
        String displayName = config.getString(path + ".display-name", " ");
        List<Integer> slots = this.parseSlots(config.getString(path + ".slots", ""));
        boolean glowing = config.getBoolean(path + ".glowing", false);
        List loreList = config.getStringList(path + ".lore");
        boolean cmdEnabled = config.getBoolean(path + ".custom-model-data.enabled", false);
        int cmdValue = config.getInt(path + ".custom-model-data.value", 0);
        Material material = Material.getMaterial((String)materialName.toUpperCase());
        if (material == null) {
            material = Material.STONE;
        }
        if ((meta = (item = new ItemStack(material)).getItemMeta()) != null) {
            FileConfiguration jobConfig = null;
            if (jobName != null) {
                jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
            }
            meta.setDisplayName(MrLibColors.colorize((String)this.stripMessageTags(this.replaceCommonPlaceholders(displayName, player, jobName, jobConfig))));
            if (loreList != null && !loreList.isEmpty()) {
                ArrayList<String> coloredLore = new ArrayList<String>();
                for (String line : loreList) {
                    coloredLore.add(MrLibColors.colorize((String)this.stripMessageTags(this.replaceCommonPlaceholders(line, player, jobName, jobConfig))));
                }
                meta.setLore(coloredLore);
            }
            if (cmdEnabled) {
                try {
                    meta.setCustomModelData(Integer.valueOf(cmdValue));
                }
                catch (Throwable coloredLore) {
                    // empty catch block
                }
            }
            if (glowing) {
                try {
                    Enchantment glow = this.getGlowEnchant();
                    if (glow != null) {
                        meta.addEnchant(glow, 1, true);
                        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    }
                }
                catch (Throwable glow) {
                    // empty catch block
                }
            }
            item.setItemMeta(meta);
        }
        for (int slot : slots) {
            if (slot < 0 || slot >= gui.getInventory().getSize()) continue;
            gui.setItem(slot, item, event -> event.setCancelled(true));
        }
    }

    private String replaceCommonPlaceholders(String text, Player player, String jobName, FileConfiguration jobConfig) {
        Set<String> jobs;
        if (text == null || text.isEmpty()) {
            return text;
        }
        String result = text;
        int currentJobs = this.plugin.getPlayerJobManager().getPlayerJobCount(player);
        int maxJobs = this.plugin.getPlayerJobManager().getMaxJobsForPlayer(player);
        double totalMoney = this.plugin.getPlayerDataManager().getTotalMoneyEarned(player.getUniqueId());
        result = result.replace("[CurrentJobs]", String.valueOf(currentJobs)).replace("[MaxJobs]", String.valueOf(maxJobs)).replace("[TotalMoneyMaked]", String.format("%.2f", totalMoney)).replace("[PlayerName]", player.getName());
        String effectiveJob = jobName;
        if (effectiveJob == null && !(jobs = this.plugin.getPlayerJobManager().getActiveJobs(player)).isEmpty()) {
            effectiveJob = jobs.iterator().next();
        }
        if (effectiveJob != null) {
            double jobXP;
            int playerLevel = this.plugin.getPlayerJobManager().isPlayerInJob(player, effectiveJob) ? this.plugin.getPlayerJobManager().getPlayerJobLevel(player, effectiveJob) : 0;
            int maxLevel = this.plugin.getPlayerJobManager().getMaxLevelForJob(effectiveJob);
            double d = jobXP = this.plugin.getPlayerJobManager().isPlayerInJob(player, effectiveJob) ? this.plugin.getPlayerJobManager().getPlayerJobXP(player, effectiveJob) : 0.0;
            if (jobConfig == null) {
                jobConfig = this.plugin.getJobManager().getJobConfig(effectiveJob);
            }
            int nextLevel = Math.min(playerLevel + 1, Math.max(maxLevel, playerLevel + 1));
            int xpNeed = jobConfig != null ? jobConfig.getInt("MrUltimateJobs.Job.System.Levels." + nextLevel, 0) : 0;
            double xpToNext = Math.max(0.0, (double)xpNeed - jobXP);
            result = result.replace("[Job]", effectiveJob).replace("[PlayerLevel]", String.valueOf(playerLevel)).replace("[MaxLevel]", String.valueOf(maxLevel)).replace("[JobXP]", String.format("%.1f", jobXP)).replace("[JobXPNeed]", String.valueOf(xpNeed)).replace("[XPToNext]", String.format("%.1f", xpToNext));
        }
        return result;
    }

    private void addKeyItem(MrLibGUI gui, String keyKey, Player player, String jobName) {
        String cfgMat;
        Inventory inventory = gui.getInventory();
        String path = "MrUltimateJobs.Rewards.keys." + keyKey;
        String type = this.rewardsConfig.getString(path + ".type", "");
        ArrayList<Integer> slots = new ArrayList<Integer>();
        Object slotsObj = this.rewardsConfig.get(path + ".slots");
        if (slotsObj instanceof Number) {
            slots.add(((Number)slotsObj).intValue());
        } else if (slotsObj instanceof String) {
            slots.addAll(this.parseSlots((String)slotsObj));
        } else if (slotsObj instanceof List) {
            for (Object o : (List)slotsObj) {
                if (o instanceof Number) {
                    slots.add(((Number)o).intValue());
                    continue;
                }
                if (!(o instanceof String)) continue;
                try {
                    slots.add(Integer.parseInt(((String)o).trim()));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        boolean glowing = this.rewardsConfig.getBoolean(path + ".glowing", false);
        boolean cmdEnabled = this.rewardsConfig.getBoolean(path + ".custom-model-data.enabled", false);
        int cmdValue = this.rewardsConfig.getInt(path + ".custom-model-data.value", 0);
        String name = this.rewardsConfig.getString(path + ".name", "");
        List loreList = this.rewardsConfig.getStringList(path + ".lore");
        String materialName = this.rewardsConfig.getString(path + ".material", "");
        ItemStack item = null;
        String displayName = "";
        if (materialName != null && !materialName.isEmpty() && (cfgMat = Material.getMaterial((String)materialName.toUpperCase())) != null) {
            item = new ItemStack((Material)cfgMat);
        }
        if (item == null) {
            switch (type.toLowerCase()) {
                case "back": {
                    item = new ItemStack(Material.ARROW);
                    displayName = "&cBack";
                    break;
                }
                case "next": {
                    item = new ItemStack(Material.PAPER);
                    displayName = "&aNext Page";
                    break;
                }
                case "previous": {
                    item = new ItemStack(Material.PAPER);
                    displayName = "&aPrevious Page";
                    break;
                }
                default: {
                    item = new ItemStack(Material.BARRIER);
                    displayName = "&cUnknown";
                }
            }
        }
        if (item != null) {
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                FileConfiguration jobConfig;
                String finalName = name != null && !name.isEmpty() ? name : (displayName.isEmpty() ? "" : displayName);
                FileConfiguration fileConfiguration = jobConfig = jobName != null ? this.plugin.getJobManager().getJobConfig(jobName) : null;
                if (!finalName.isEmpty()) {
                    meta.setDisplayName(MrLibColors.colorize((String)this.stripMessageTags(this.replaceCommonPlaceholders(finalName, player, jobName, jobConfig))));
                }
                try {
                    PersistentDataContainer pdc = meta.getPersistentDataContainer();
                    pdc.set(new NamespacedKey((Plugin)this.plugin, "rewards-nav"), PersistentDataType.STRING, (Object)type.toLowerCase());
                }
                catch (Throwable pdc) {
                    // empty catch block
                }
                if (loreList != null && !loreList.isEmpty()) {
                    ArrayList<String> coloredLore = new ArrayList<String>();
                    for (String line : loreList) {
                        coloredLore.add(MrLibColors.colorize((String)this.stripMessageTags(this.replaceCommonPlaceholders(line, player, jobName, jobConfig))));
                    }
                    meta.setLore(coloredLore);
                }
                if (cmdEnabled) {
                    try {
                        meta.setCustomModelData(Integer.valueOf(cmdValue));
                    }
                    catch (Throwable coloredLore) {
                        // empty catch block
                    }
                }
                if (glowing) {
                    try {
                        Enchantment glow = this.getGlowEnchant();
                        if (glow != null) {
                            meta.addEnchant(glow, 1, true);
                            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                item.setItemMeta(meta);
            }
            String finalType = type.toLowerCase();
            String finalJobName = jobName;
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot < 0 || slot >= gui.getInventory().getSize()) continue;
                gui.setItem(slot, item, event -> {
                    Player clicker = (Player)event.getWhoClicked();
                    event.setCancelled(true);
                    switch (finalType) {
                        case "back": {
                            this.openHeadMenu(clicker);
                            break;
                        }
                        case "next": {
                            int currentPage = this.rewardsPage.getOrDefault(clicker.getUniqueId(), 0);
                            this.openRewardsMenu(clicker, finalJobName, currentPage + 1);
                            break;
                        }
                        case "previous": {
                            int currPage = this.rewardsPage.getOrDefault(clicker.getUniqueId(), 0);
                            if (currPage <= 0) break;
                            this.openRewardsMenu(clicker, finalJobName, currPage - 1);
                        }
                    }
                });
            }
        }
    }

    private void addJobItem(MrLibGUI gui, String jobName, int slot, Player player) {
        ItemStack item;
        ItemMeta meta;
        Material material;
        Inventory inventory = gui.getInventory();
        FileConfiguration jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
        if (jobConfig == null) {
            return;
        }
        Object displayName = jobConfig.getString("MrUltimateJobs.Job.Name", "&f" + jobName);
        String materialName = this.getJobMaterial(jobName);
        boolean isInJob = this.plugin.getPlayerJobManager().isPlayerInJob(player, jobName);
        if (isInJob) {
            displayName = "&a" + (String)displayName + " " + this.plugin.getMessageManager().getMessage("general.your-job");
        }
        if ((material = Material.getMaterial((String)materialName.toUpperCase())) == null) {
            material = Material.PAPER;
        }
        if ((meta = (item = new ItemStack(material)).getItemMeta()) != null) {
            meta.setDisplayName(MrLibColors.colorize((String)this.stripMessageTags((String)displayName)));
            try {
                NamespacedKey jobKey = new NamespacedKey((Plugin)this.plugin, "job");
                PersistentDataContainer pdc = meta.getPersistentDataContainer();
                pdc.set(jobKey, PersistentDataType.STRING, (Object)jobName);
            }
            catch (Throwable jobKey) {
                // empty catch block
            }
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("");
            if (isInJob) {
                double playerXP;
                double xpToNextLevel;
                int playerLevel = this.plugin.getPlayerJobManager().getPlayerJobLevel(player, jobName);
                int maxLevel = 1;
                if (jobConfig.contains("MrUltimateJobs.Job.System.Levels")) {
                    Set levelKeys = jobConfig.getConfigurationSection("MrUltimateJobs.Job.System.Levels").getKeys(false);
                    for (String levelStr : levelKeys) {
                        try {
                            int level = Integer.parseInt(levelStr);
                            if (level <= maxLevel) continue;
                            maxLevel = level;
                        }
                        catch (NumberFormatException level) {}
                    }
                }
                int xpNeededForNextLevel = 0;
                if (jobConfig.contains("MrUltimateJobs.Job.System.Levels." + (playerLevel + 1))) {
                    xpNeededForNextLevel = jobConfig.getInt("MrUltimateJobs.Job.System.Levels." + (playerLevel + 1));
                }
                if ((xpToNextLevel = (double)xpNeededForNextLevel - (playerXP = this.plugin.getPlayerJobManager().getPlayerJobXP(player, jobName))) < 0.0) {
                    xpToNextLevel = 0.0;
                }
                int employedCount = this.plugin.getPlayerJobManager().getEmployedCount(jobName);
                lore.add(MrLibColors.colorize((String)("&7Employed: &e" + employedCount)));
                lore.add(MrLibColors.colorize((String)("&7Level: &e" + playerLevel + "&7/&e" + maxLevel)));
                lore.add(MrLibColors.colorize((String)("&7XP: &c" + String.format("%.1f", playerXP) + "&7/&c" + xpNeededForNextLevel)));
                lore.add(MrLibColors.colorize((String)("&7XP to next level: &c" + String.format("%.1f", xpToNextLevel))));
                lore.add("");
                lore.add(MrLibColors.colorize((String)"&cRight click &7| &fTo leave this job!"));
                lore.add(MrLibColors.colorize((String)"&eDrop (Q) &7| &fTo view rewards!"));
            } else {
                int maxLevel = 1;
                if (jobConfig.contains("MrUltimateJobs.Job.System.Levels")) {
                    Set levelKeys = jobConfig.getConfigurationSection("MrUltimateJobs.Job.System.Levels").getKeys(false);
                    for (String levelStr : levelKeys) {
                        try {
                            int level = Integer.parseInt(levelStr);
                            if (level <= maxLevel) continue;
                            maxLevel = level;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                int employedCount = this.plugin.getPlayerJobManager().getEmployedCount(jobName);
                lore.add(MrLibColors.colorize((String)("&7Employed: &e" + employedCount)));
                lore.add(MrLibColors.colorize((String)("&7Max Level: &e" + maxLevel)));
                lore.add(MrLibColors.colorize((String)"&eLeft click &7| &fTo join this job!"));
                lore.add(MrLibColors.colorize((String)"&cRight click &7| &fTo view details!"));
                lore.add(MrLibColors.colorize((String)"&eDrop (Q) &7| &fTo view rewards!"));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        if (slot >= 0 && slot < gui.getInventory().getSize()) {
            String finalJobName = jobName;
            boolean finalIsInJob = isInJob;
            gui.setItem(slot, item, event -> {
                Player clicker = (Player)event.getWhoClicked();
                event.setCancelled(true);
                ClickType clickType = event.getClick();
                if (clickType == ClickType.DROP || clickType == ClickType.CONTROL_DROP || event.isShiftClick() && event.isLeftClick()) {
                    this.openRewardsMenu(clicker, finalJobName);
                    return;
                }
                if (event.isLeftClick()) {
                    if (finalIsInJob) {
                        String msg = this.plugin.getMessageManager().getMessage("general.already-in-job").replace("[Job]", finalJobName);
                        this.plugin.sendMessage(clicker, msg);
                    } else {
                        clicker.closeInventory();
                        clicker.performCommand("jobs join " + finalJobName);
                    }
                } else if (event.isRightClick()) {
                    if (finalIsInJob) {
                        clicker.closeInventory();
                        clicker.performCommand("jobs leave " + finalJobName);
                    } else {
                        this.openHeadMenu(clicker);
                    }
                }
            });
        }
    }

    private void addRewardItems(MrLibGUI gui, String jobName, Player player, int page) {
        Inventory inventory = gui.getInventory();
        FileConfiguration jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
        if (jobConfig == null) {
            return;
        }
        String rewardSlotsPath = "MrUltimateJobs.Rewards.rewards.rewardslots";
        List<Integer> rewardSlots = this.parseSlots(this.rewardsConfig.getString(rewardSlotsPath + ".slots", ""));
        if (jobConfig.contains("MrUltimateJobs.Job.System.Levels-Rewards")) {
            Set rewardLevelsSet = jobConfig.getConfigurationSection("MrUltimateJobs.Job.System.Levels-Rewards").getKeys(false);
            ArrayList<Integer> levels = new ArrayList<Integer>();
            for (String s : rewardLevelsSet) {
                if ("ALL-Levels".equalsIgnoreCase(s)) continue;
                try {
                    levels.add(Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            Collections.sort(levels);
            int pageSize = rewardSlots.size();
            int start = Math.max(0, page) * pageSize;
            int end = Math.min(levels.size(), start + pageSize);
            int slotIndex = 0;
            for (int i = start; i < end; ++i) {
                int level = (Integer)levels.get(i);
                int slot = rewardSlots.get(slotIndex);
                this.addRewardItem(gui, jobName, level, slot, player);
                ++slotIndex;
            }
        }
    }

    private void addRewardItem(MrLibGUI gui, String jobName, int level, int slot, Player player) {
        String materialName;
        Material configMaterial;
        Inventory inventory = gui.getInventory();
        FileConfiguration jobConfig = this.plugin.getJobManager().getJobConfig(jobName);
        if (jobConfig == null) {
            return;
        }
        String rewardSlotsPath = "MrUltimateJobs.Rewards.rewards.rewardslots";
        Material material = Material.BLACK_STAINED_GLASS_PANE;
        String materialType = "Unclaimed";
        int playerLevel = 0;
        if (this.plugin.getPlayerJobManager().isPlayerInJob(player, jobName)) {
            playerLevel = this.plugin.getPlayerJobManager().getPlayerJobLevel(player, jobName);
        }
        boolean claimed = this.plugin.getPlayerDataManager().isRewardClaimed(player, jobName, level);
        if (playerLevel >= level) {
            materialType = claimed ? "Claimed" : "Unclaimed";
            material = claimed ? Material.GREEN_STAINED_GLASS_PANE : Material.BLACK_STAINED_GLASS_PANE;
        } else if (playerLevel + 1 == level) {
            material = Material.ORANGE_STAINED_GLASS_PANE;
            materialType = "NextLevel";
        } else if (playerLevel < level) {
            material = Material.RED_STAINED_GLASS_PANE;
            materialType = "NotAvaible";
        }
        String materialPath = rewardSlotsPath + ".material." + materialType;
        if (this.rewardsConfig.contains(materialPath) && (configMaterial = Material.getMaterial((String)(materialName = this.rewardsConfig.getString(materialPath, material.name())).toUpperCase())) != null) {
            material = configMaterial;
        }
        String displayName = this.rewardsConfig.getString(rewardSlotsPath + ".display-name", "&eReward &7| &fLevel [Level]");
        displayName = displayName.replace("[Level]", String.valueOf(level));
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MrLibColors.colorize((String)this.stripMessageTags(displayName)));
            try {
                PersistentDataContainer pdc = meta.getPersistentDataContainer();
                pdc.set(new NamespacedKey((Plugin)this.plugin, "job"), PersistentDataType.STRING, (Object)jobName);
                pdc.set(new NamespacedKey((Plugin)this.plugin, "level"), PersistentDataType.INTEGER, (Object)level);
            }
            catch (Throwable pdc) {
                // empty catch block
            }
            boolean rewardSlotsGlow = this.rewardsConfig.getBoolean(rewardSlotsPath + ".glowing", false);
            if (rewardSlotsGlow) {
                try {
                    Enchantment glow = this.getGlowEnchant();
                    if (glow != null) {
                        meta.addEnchant(glow, 1, true);
                        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    }
                }
                catch (Throwable glow) {
                    // empty catch block
                }
            }
            boolean cmdEnabled = this.rewardsConfig.getBoolean(rewardSlotsPath + ".material.custom-model-data.enabled", false);
            int cmdValue = this.rewardsConfig.getInt(rewardSlotsPath + ".material.custom-model-data.value", 0);
            if (cmdEnabled) {
                try {
                    meta.setCustomModelData(Integer.valueOf(cmdValue));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ArrayList<String> lore = new ArrayList<String>();
            List customLore = this.rewardsConfig.getStringList(rewardSlotsPath + ".lore");
            if (customLore != null && !customLore.isEmpty()) {
                for (String line : customLore) {
                    line = line.replace("[Level]", String.valueOf(level));
                    String status = "";
                    status = playerLevel >= level ? (claimed ? this.plugin.getMessageManager().getMessage("reward-status.claimed") : this.plugin.getMessageManager().getMessage("reward-status.available")) : (playerLevel + 1 == level ? this.plugin.getMessageManager().getMessage("reward-status.next-level") : this.plugin.getMessageManager().getMessage("reward-status.locked"));
                    if ((line = line.replace("[Status]", status)).contains("[Rewards]")) {
                        String rewardsText = this.getRewardsText(jobConfig, level);
                        line = line.replace("[Rewards]", rewardsText);
                    }
                    line = this.replaceCommonPlaceholders(line, player, jobName, jobConfig);
                    lore.add(MrLibColors.colorize((String)this.stripMessageTags(line)));
                }
            } else {
                lore.add("");
                String rewardsPath = "MrUltimateJobs.Job.System.Levels-Rewards." + level;
                if (jobConfig.contains(rewardsPath)) {
                    if (jobConfig.isList(rewardsPath + ".Name")) {
                        for (String line : jobConfig.getStringList(rewardsPath + ".Name")) {
                            lore.add(MrLibColors.colorize((String)this.stripMessageTags("&7" + line)));
                        }
                    } else if (jobConfig.isString(rewardsPath + ".Name")) {
                        String name = jobConfig.getString(rewardsPath + ".Name", "");
                        if (!name.isEmpty()) {
                            lore.add(MrLibColors.colorize((String)this.stripMessageTags("&7" + name)));
                        }
                    } else {
                        List cmds = jobConfig.getStringList(rewardsPath + ".Commands");
                        List format = this.rewardsConfig.getStringList("MrUltimateJobs.Rewards.placeholders.Reward");
                        int idx = 1;
                        for (String cmd : cmds) {
                            if (format != null && !format.isEmpty()) {
                                for (String f : format) {
                                    lore.add(MrLibColors.colorize((String)this.stripMessageTags(f.replace("[Reward]", cmd))));
                                }
                            } else {
                                lore.add(MrLibColors.colorize((String)this.stripMessageTags("&7Reward " + idx)));
                            }
                            ++idx;
                        }
                    }
                }
                lore.add("");
                String statusMessage = "";
                statusMessage = playerLevel >= level ? (claimed ? this.rewardsConfig.getString(rewardSlotsPath + ".status-messages.claimed", this.plugin.getMessageManager().getMessage("reward-status.claimed")) : this.rewardsConfig.getString(rewardSlotsPath + ".status-messages.available", this.plugin.getMessageManager().getMessage("reward-status.available"))) : (playerLevel + 1 == level ? this.rewardsConfig.getString(rewardSlotsPath + ".status-messages.next-level", this.plugin.getMessageManager().getMessage("reward-status.next-level")) : this.rewardsConfig.getString(rewardSlotsPath + ".status-messages.locked", this.plugin.getMessageManager().getMessage("reward-status.locked")));
                lore.add(MrLibColors.colorize((String)this.stripMessageTags(statusMessage)));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        if (slot >= 0 && slot < gui.getInventory().getSize()) {
            String finalJobName = jobName;
            int finalLevel = level;
            boolean finalClaimed = claimed;
            int finalPlayerLevel = playerLevel;
            gui.setItem(slot, item, event -> {
                Player clicker = (Player)event.getWhoClicked();
                event.setCancelled(true);
                if (finalPlayerLevel >= finalLevel) {
                    if (finalClaimed) {
                        String msg = this.plugin.getMessageManager().getMessage("general.reward-already-claimed");
                        this.plugin.sendMessage(clicker, msg);
                    } else {
                        clicker.closeInventory();
                        clicker.performCommand("jobs claim " + finalJobName + " " + finalLevel);
                    }
                } else {
                    String msg = this.plugin.getMessageManager().getMessage("general.reward-not-available");
                    this.plugin.sendMessage(clicker, msg);
                }
            });
        }
    }

    private String getJobMaterial(String jobName) {
        switch (jobName.toLowerCase()) {
            case "farmer": {
                return "WHEAT";
            }
            case "builder": {
                return "BRICKS";
            }
            case "fisher": {
                return "FISHING_ROD";
            }
            case "lumberjack": {
                return "WOODEN_AXE";
            }
            case "enchanter": {
                return "ENCHANTED_BOOK";
            }
            case "warrior": {
                return "IRON_SWORD";
            }
        }
        return "PAPER";
    }

    private List<Integer> parseSlots(String slotsString) {
        String[] parts;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        if (slotsString == null || slotsString.isEmpty()) {
            return slots;
        }
        for (String part : parts = slotsString.split(",")) {
            if ((part = part.trim()).contains("-")) {
                String[] range = part.split("-");
                try {
                    int start = Integer.parseInt(range[0].trim());
                    int end = Integer.parseInt(range[1].trim());
                    for (int i = start; i <= end; ++i) {
                        slots.add(i);
                    }
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            try {
                slots.add(Integer.parseInt(part));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return slots;
    }

    private Enchantment getGlowEnchant() {
        try {
            Enchantment unbreaking = Enchantment.getByName((String)"DURABILITY");
            if (unbreaking != null) {
                return unbreaking;
            }
        }
        catch (Throwable unbreaking) {
            // empty catch block
        }
        try {
            Enchantment prot = Enchantment.getByName((String)"PROTECTION_ENVIRONMENTAL");
            if (prot != null) {
                return prot;
            }
        }
        catch (Throwable prot) {
            // empty catch block
        }
        try {
            Enchantment sharp = Enchantment.getByName((String)"DAMAGE_ALL");
            if (sharp != null) {
                return sharp;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public FileConfiguration getMenuConfig() {
        if (this.menuConfig == null) {
            this.loadMenuConfig();
        }
        return this.menuConfig;
    }

    public FileConfiguration getRewardsConfig() {
        if (this.rewardsConfig == null) {
            this.loadRewardsConfig();
        }
        return this.rewardsConfig;
    }

    public int getRewardsPage(Player player) {
        return this.rewardsPage.getOrDefault(player.getUniqueId(), 0);
    }

    public String getCurrentRewardsJob(Player player) {
        return this.currentRewardsJob.get(player.getUniqueId());
    }

    public void reloadMenus() {
        this.loadMenuConfig();
        this.loadRewardsConfig();
    }

    private String getRewardsText(FileConfiguration jobConfig, int level) {
        StringBuilder rewards;
        block8: {
            String rewardsPath;
            block9: {
                block7: {
                    rewardsPath = "MrUltimateJobs.Job.System.Levels-Rewards." + level;
                    if (!jobConfig.contains(rewardsPath)) {
                        return "No rewards";
                    }
                    rewards = new StringBuilder();
                    if (!jobConfig.isList(rewardsPath + ".Name")) break block7;
                    List names = jobConfig.getStringList(rewardsPath + ".Name");
                    for (int i = 0; i < names.size(); ++i) {
                        if (i > 0) {
                            rewards.append(", ");
                        }
                        rewards.append((String)names.get(i));
                    }
                    break block8;
                }
                if (!jobConfig.isString(rewardsPath + ".Name")) break block9;
                String name = jobConfig.getString(rewardsPath + ".Name", "");
                if (name.isEmpty()) break block8;
                rewards.append(name);
                break block8;
            }
            List cmds = jobConfig.getStringList(rewardsPath + ".Commands");
            for (int i = 0; i < cmds.size(); ++i) {
                String cmd;
                if (i > 0) {
                    rewards.append(", ");
                }
                if ((cmd = (String)cmds.get(i)).startsWith("give ")) {
                    String[] parts = cmd.split(" ");
                    if (parts.length > 2) {
                        rewards.append(parts[1]).append(" x").append(parts.length > 2 ? parts[2] : "1");
                        continue;
                    }
                    rewards.append("Reward ").append(i + 1);
                    continue;
                }
                rewards.append("Reward ").append(i + 1);
            }
        }
        return rewards.length() > 0 ? rewards.toString() : "No rewards";
    }

    public void openTopMenu(Player player, String jobName) {
        this.openTopMenu(player, jobName, 0);
    }

    public void openTopMenu(Player player, String jobName, int page) {
        if (this.topConfig == null) {
            this.loadTopConfig();
            if (this.topConfig == null) {
                this.plugin.sendMessage(player, "&cTop menu configuration not found!");
                return;
            }
        }
        String title = this.topConfig.getString("MrUltimateJobs.tops.title", "&lJobs Top");
        String displayJobName = jobName;
        if (jobName.equalsIgnoreCase("All")) {
            displayJobName = this.topConfig.getString("MrUltimateJobs.tops.All", "All Jobs");
        }
        title = title.replace("[JobName]", displayJobName);
        int size = this.topConfig.getInt("MrUltimateJobs.tops.size", 54);
        int rows = size / 9;
        MrLibGUI gui = new MrLibGUI(MrLibColors.colorize((String)title), rows);
        this.topPage.put(player.getUniqueId(), Math.max(0, page));
        this.currentTopJob.put(player.getUniqueId(), jobName);
        if (this.topConfig.contains("MrUltimateJobs.tops.decorations")) {
            for (String decorationKey : this.topConfig.getConfigurationSection("MrUltimateJobs.tops.decorations").getKeys(false)) {
                this.addTopDecoration(gui, decorationKey, player, jobName);
            }
        }
        if (this.topConfig.contains("MrUltimateJobs.tops.keys")) {
            for (String keyKey : this.topConfig.getConfigurationSection("MrUltimateJobs.tops.keys").getKeys(false)) {
                this.addTopKeyItem(gui, keyKey, player, jobName, page);
            }
        }
        this.addTopPlayerItems(gui, jobName, player, page);
        gui.open(player);
    }

    private void addTopDecoration(MrLibGUI gui, String decorationKey, Player player, String jobName) {
        this.addDecoration(gui, decorationKey, "top", player, jobName);
    }

    private void addTopKeyItem(MrLibGUI gui, String keyKey, Player player, String jobName, int page) {
        Inventory inventory = gui.getInventory();
        String path = "MrUltimateJobs.tops.keys." + keyKey;
        String type = this.topConfig.getString(path + ".type", "");
        List<Integer> slots = this.parseSlots(this.topConfig.getString(path + ".slots", ""));
        for (int slot : slots) {
            ItemStack item = new ItemStack(Material.valueOf((String)this.topConfig.getString(path + ".material", "BARRIER")));
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                String name = this.topConfig.getString(path + ".name", "");
                meta.setDisplayName(MrLibColors.colorize((String)name));
                List lore = this.topConfig.getStringList(path + ".lore");
                ArrayList<String> coloredLore = new ArrayList<String>();
                for (String line : lore) {
                    coloredLore.add(MrLibColors.colorize((String)line));
                }
                meta.setLore(coloredLore);
                item.setItemMeta(meta);
            }
            String actionType = type;
            String currentJob = jobName;
            int currentPage = page;
            gui.setItem(slot, item, event -> {
                event.setCancelled(true);
                Player clicker = (Player)event.getWhoClicked();
                switch (actionType.toLowerCase()) {
                    case "back": {
                        this.openHeadMenu(clicker);
                        break;
                    }
                    case "next": {
                        this.openTopMenu(clicker, currentJob, currentPage + 1);
                        break;
                    }
                    case "previous": {
                        if (currentPage <= 0) break;
                        this.openTopMenu(clicker, currentJob, currentPage - 1);
                    }
                }
            });
        }
    }

    private void addTopPlayerItems(MrLibGUI gui, String jobName, Player player, int page) {
        Inventory inventory = gui.getInventory();
        String slotsStr = this.topConfig.getString("MrUltimateJobs.tops.top.topslots.slots", "10-16,19-25,28-34,37-43");
        List<Integer> slots = this.parseSlots(slotsStr);
        List<TopPlayerData> topPlayers = this.plugin.getPlayerJobManager().getTopPlayers(jobName, page * slots.size(), slots.size());
        for (int i = 0; i < topPlayers.size() && i < slots.size(); ++i) {
            TopPlayerData data = topPlayers.get(i);
            int slot = slots.get(i);
            this.addTopPlayerItem(gui, data, slot, player, jobName, page * slots.size() + i + 1);
        }
    }

    private void addTopPlayerItem(MrLibGUI gui, TopPlayerData data, int slot, Player viewer, String jobName, int rank) {
        Inventory inventory = gui.getInventory();
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta != null) {
            String lorePath;
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)data.getPlayerUUID()));
            String displayName = this.topConfig.getString("MrUltimateJobs.tops.top.topslots.display-name", "&e{PlayerName}");
            displayName = displayName.replace("[PlayerName]", data.getPlayerName()).replace("[Rank]", String.valueOf(rank)).replace("[Level]", String.valueOf(data.getLevel())).replace("[XP]", String.format("%.2f", data.getXp()));
            meta.setDisplayName(MrLibColors.colorize((String)displayName));
            String string = lorePath = jobName.equalsIgnoreCase("All") ? "MrUltimateJobs.tops.top.topslots.lore-all" : "MrUltimateJobs.tops.top.topslots.lore-job";
            if (!this.topConfig.contains(lorePath)) {
                lorePath = "MrUltimateJobs.tops.top.topslots.lore";
            }
            List lore = this.topConfig.getStringList(lorePath);
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : lore) {
                if (line.contains("[AllJobsList]") && jobName.equalsIgnoreCase("All")) {
                    String jobLineFormat = this.topConfig.getString("MrUltimateJobs.tops.top.topslots.job-line-format", " {#0300EA}\u27a3 &f[JobName]: {#3574FF}Lvl [JobLevel] {#00FF00}$[JobMoney]");
                    for (Map.Entry<String, TopPlayerData.JobStats> jobEntry : data.getAllJobs().entrySet()) {
                        String jobLine = jobLineFormat.replace("[JobName]", jobEntry.getKey()).replace("[JobLevel]", String.valueOf(jobEntry.getValue().getLevel())).replace("[JobMoney]", String.format("%.2f", jobEntry.getValue().getMoney())).replace("[JobXP]", String.format("%.2f", jobEntry.getValue().getXp())).replace("[JobRewards]", String.valueOf(jobEntry.getValue().getClaimedRewards()));
                        coloredLore.add(MrLibColors.colorize((String)jobLine));
                    }
                    continue;
                }
                if (line.contains("[JobActivity]") && !jobName.equalsIgnoreCase("All")) {
                    String jobActivitiesPath = "MrUltimateJobs.tops.top.topslots.job-activities." + jobName.toLowerCase();
                    List jobActivities = this.topConfig.contains(jobActivitiesPath) ? this.topConfig.getStringList(jobActivitiesPath) : this.topConfig.getStringList("MrUltimateJobs.tops.top.topslots.job-activities.default");
                    for (String activityLine : jobActivities) {
                        String processedLine = activityLine.replace("[BlocksBroken]", String.valueOf(data.getBlocksBroken())).replace("[BlocksPlaced]", String.valueOf(data.getBlocksPlaced())).replace("[ItemsCrafted]", String.valueOf(data.getItemsCrafted())).replace("[FishCaught]", String.valueOf(data.getFishCaught())).replace("[MobsKilled]", String.valueOf(data.getMobsKilled())).replace("[ItemsEnchanted]", String.valueOf(data.getItemsEnchanted()));
                        coloredLore.add(MrLibColors.colorize((String)processedLine));
                    }
                    continue;
                }
                line = line.replace("[PlayerName]", data.getPlayerName()).replace("[Rank]", String.valueOf(rank)).replace("[Level]", String.valueOf(data.getLevel())).replace("[XP]", String.format("%.2f", data.getXp())).replace("[JobName]", jobName).replace("[BlocksBroken]", String.valueOf(data.getBlocksBroken())).replace("[BlocksPlaced]", String.valueOf(data.getBlocksPlaced())).replace("[ItemsCrafted]", String.valueOf(data.getItemsCrafted())).replace("[FishCaught]", String.valueOf(data.getFishCaught())).replace("[MobsKilled]", String.valueOf(data.getMobsKilled())).replace("[ItemsEnchanted]", String.valueOf(data.getItemsEnchanted())).replace("[ClaimedRewards]", String.valueOf(data.getClaimedRewards())).replace("[TotalClaimedRewards]", String.valueOf(data.getClaimedRewards())).replace("[MoneyEarned]", String.format("%.2f", data.getMoneyEarned()));
                coloredLore.add(MrLibColors.colorize((String)line));
            }
            meta.setLore(coloredLore);
            item.setItemMeta((ItemMeta)meta);
        }
        inventory.setItem(slot, item);
    }

    private String stripMessageTags(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.replaceAll("\\(!message!\\)", "").replaceAll("\\(!title!\\)", "").replaceAll("\\(!subtitle!\\)", "").replaceAll("\\(!actionbar!\\)", "").replaceAll("\\(!noprefix!\\)", "").replaceAll("\\(!NOPREFIX!\\)", "").replaceAll("\\(!hover:[^!]*!\\)", "").replaceAll("\\(!click:[^!]*!\\)", "").replaceAll("\\(!sound:[^!]*!\\)", "").replaceAll("\\(!close!\\)", "").trim();
    }
}

