/*
 * Decompiled with CFR 0.152.
 */
package fr.creerio.elementalenchantments.mixins;

import fr.creerio.elementalenchantments.ElementalEnchantments;
import fr.creerio.elementalenchantments.ElementalEnchantmentsClient;
import fr.creerio.elementalenchantments.config.ConfigWLib;
import fr.creerio.elementalenchantments.interfaces.IArmorEntity;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class ArmoredEntity
extends class_1297
implements IArmorEntity {
    @Unique
    private boolean enableDarkCurse = false;
    @Unique
    private boolean enableElecCurse = false;
    @Unique
    private boolean enableFireCurse = false;
    @Unique
    private boolean enableFreezeCurse = false;
    @Unique
    private boolean enableLightCurse = false;

    protected ArmoredEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public void elementalenchantments$setEnableDarkCurse(boolean enableDarkCurse) {
        this.enableDarkCurse = enableDarkCurse;
    }

    @Override
    public void elementalenchantments$setEnableElecCurse(boolean enableElecCurse) {
        this.enableElecCurse = enableElecCurse;
    }

    @Override
    public void elementalenchantments$setEnableFireCurse(boolean enableFireCurse) {
        this.enableFireCurse = enableFireCurse;
    }

    @Override
    public void elementalenchantments$setEnableFreezeCurse(boolean enableFreezeCurse) {
        this.enableFreezeCurse = enableFreezeCurse;
    }

    @Override
    public void elementalenchantments$setEnableLightCurse(boolean enableLightCurse) {
        this.enableLightCurse = enableLightCurse;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void applyFreeze(CallbackInfo ci) {
        if (!ci.isCancelled() && this.method_32312() > 1 && this.enableFreezeCurse) {
            this.method_32317(ElementalEnchantments.isMidnightEnabled() ? ConfigWLib.frostCurseFrozenTickTime : 300);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 world = (class_3218)class_19372;
                world.method_65096((class_2394)class_2398.field_28013, this.method_23317(), this.method_23319(), this.method_23321(), 1, 0.0, -1.0, 0.0, 0.1);
            }
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void applyFire(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (cir.isCancelled()) {
            return;
        }
        if (this.method_5809() && this.enableFireCurse) {
            this.method_5639(ElementalEnchantments.isMidnightEnabled() ? ConfigWLib.fireCurseOnFireTime : 2);
            world.method_65096((class_2394)class_2398.field_27783, this.method_23317(), this.method_23319(), this.method_23321(), 3, 0.0, -1.0, 0.0, 0.1);
        }
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), index=3, argsOnly=true)
    private float modifyDmg(float amount) {
        boolean isNight;
        class_1937 world = this.method_37908();
        boolean isDay = world.field_9236 ? ElementalEnchantmentsClient.getIsServerDay() : world.method_8530();
        boolean bl = isNight = world.field_9236 ? ElementalEnchantmentsClient.getIsServerNight() : world.method_23886();
        if (isDay && this.enableLightCurse) {
            float lightCursePowerNerf = ElementalEnchantments.isMidnightEnabled() ? ConfigWLib.lightCursePowerNerf : 3.0f;
            return amount + amount / lightCursePowerNerf;
        }
        if (isNight && this.enableDarkCurse) {
            float darkCursePowerNerf = ElementalEnchantments.isMidnightEnabled() ? ConfigWLib.darkCursePowerNerf : 3.0f;
            return amount + amount / darkCursePowerNerf;
        }
        return amount;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArmoredEntity that = (ArmoredEntity)o;
        return this.enableDarkCurse == that.enableDarkCurse && this.enableElecCurse == that.enableElecCurse && this.enableFireCurse == that.enableFireCurse && this.enableFreezeCurse == that.enableFreezeCurse && this.enableLightCurse == that.enableLightCurse;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.enableDarkCurse, this.enableElecCurse, this.enableFireCurse, this.enableFreezeCurse, this.enableLightCurse);
    }
}

