/*
 * Decompiled with CFR 0.152.
 */
package fr.creerio.elementalenchantments.mixins;

import fr.creerio.elementalenchantments.ElementalEnchantments;
import fr.creerio.elementalenchantments.config.ConfigWLib;
import fr.creerio.elementalenchantments.network.ArmorRemovalPacket;
import fr.creerio.elementalenchantments.network.ThunderPacket;
import fr.creerio.elementalenchantments.network.TimePacket;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3695;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
public abstract class ServerDataSender
extends class_1937 {
    @Unique
    private boolean isDay = this.method_8530();
    @Unique
    private boolean isNight = this.method_23886();
    @Unique
    private boolean isThundering = this.method_8546();
    @Unique
    private boolean blockArmorRemoval = ServerDataSender.serverCanRemoveArmor();

    @Shadow
    public abstract List<class_3222> method_18456();

    @Unique
    private static boolean serverCanRemoveArmor() {
        return ElementalEnchantments.isMidnightEnabled() ? ConfigWLib.preventArmorRemoval : true;
    }

    protected ServerDataSender(class_5269 properties, class_5321<class_1937> registryRef, class_5455 registryManager, class_6880<class_2874> dimensionEntry, Supplier<class_3695> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Inject(method={"onPlayerConnected"}, at={@At(value="TAIL")})
    private void firstDataSend(class_3222 player, CallbackInfo ci) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new TimePacket(this.isDay, this.isNight));
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ThunderPacket(this.isThundering));
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ArmorRemovalPacket(this.blockArmorRemoval));
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void sendArmorRemoval(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        boolean isArmorRemovalBlocked = ServerDataSender.serverCanRemoveArmor();
        if (this.blockArmorRemoval != isArmorRemovalBlocked) {
            this.blockArmorRemoval = isArmorRemovalBlocked;
            for (class_3222 player : this.method_18456()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ArmorRemovalPacket(this.blockArmorRemoval));
            }
        }
    }

    @Inject(method={"tickTime"}, at={@At(value="TAIL")})
    private void sendClientTime(CallbackInfo ci) {
        boolean isServerDay = this.method_8530();
        boolean isServerNight = this.method_23886();
        boolean sendToPlayers = false;
        if (isServerDay != this.isDay) {
            this.isDay = isServerDay;
            sendToPlayers = true;
        }
        if (isServerNight != this.isNight) {
            this.isNight = isServerNight;
            sendToPlayers = true;
        }
        if (sendToPlayers) {
            for (class_3222 player : this.method_18456()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new TimePacket(isServerDay, isServerNight));
            }
        }
    }

    @Inject(method={"tickWeather"}, at={@At(value="TAIL")})
    private void sendClientWeather(CallbackInfo ci) {
        boolean isServerThundering = this.method_8546();
        if (isServerThundering != this.isThundering) {
            this.isThundering = isServerThundering;
            for (class_3222 player : this.method_18456()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ThunderPacket(isServerThundering));
            }
        }
    }
}

