/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.pipewasxd.strengthsmp.StrengthManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public record StrengthCommand(StrengthManager strengthManager, StrengthSMP plugin) implements CommandExecutor,
TabCompleter
{
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            int strength = this.strengthManager.getStrength(player);
            player.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c \u029c\u1d00\u1d20\u1d07 " + String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + strength + String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + " s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c");
            return true;
        }
        if (args[0].equalsIgnoreCase("set")) {
            if (!player.hasPermission("strengthsmp.admin")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (args.length < 3) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /strength set <player> <amount>");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                return true;
            }
            try {
                int amount = Integer.parseInt(args[2]);
                this.strengthManager.setStrength(target, amount);
                int actualStrength = this.strengthManager.getStrength(target);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Set " + target.getName() + "'s strength to " + actualStrength);
                target.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c\u0280 s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c \u029c\u1d00s \u0299\u1d07\u1d07\u0274 s\u1d07\u1d1b \u1d1b\u1d0f " + String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + actualStrength);
            }
            catch (NumberFormatException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number!");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!player.hasPermission("strengthsmp.admin")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            this.plugin.reloadConfig();
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "StrengthSMP config reloaded!");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /strength [set <player> <amount>] [reload]");
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        List<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if ("set".startsWith(args[0].toLowerCase())) {
                completions.add("set");
            }
            if ("reload".startsWith(args[0].toLowerCase())) {
                completions.add("reload");
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("set")) {
            String input = args[1].toLowerCase();
            completions = Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList());
        } else if (args.length == 3 && args[0].equalsIgnoreCase("set")) {
            completions.add("-5");
            completions.add("0");
            completions.add("1");
            completions.add("5");
        }
        return completions;
    }
}

