/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import me.pipewasxd.strengthsmp.ConfigManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public record StrengthItemRecipe(StrengthSMP plugin, ConfigManager configManager) {
    public static ItemStack createStrengthItem() {
        ItemStack item = new ItemStack(Material.NAUTILUS_SHELL);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.DARK_RED) + "s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c");
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + "\u0280\u026a\u0262\u029c\u1d1b-\u1d04\u029f\u026a\u1d04\u1d0b \u1d1b\u1d0f \u0262\u1d00\u026a\u0274 " + String.valueOf(ChatColor.GREEN) + "+1 " + String.valueOf(ChatColor.WHITE) + "s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c")));
            meta.setLore(lore);
            NamespacedKey key = new NamespacedKey("strengthsmp", "strength_item_modifier");
            AttributeModifier modifier = new AttributeModifier(key, 1.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.HAND);
            meta.addAttributeModifier(Attribute.GENERIC_ATTACK_DAMAGE, modifier);
            meta.setCustomModelData(Integer.valueOf(12345));
            NamespacedKey itemKey = new NamespacedKey("strengthsmp", "strength_item");
            meta.getPersistentDataContainer().set(itemKey, PersistentDataType.BYTE, (Object)1);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static boolean isStrengthItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        NamespacedKey itemKey = new NamespacedKey("strengthsmp", "strength_item");
        return meta.getPersistentDataContainer().has(itemKey, PersistentDataType.BYTE);
    }

    public void registerRecipe() {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "strength_item");
        Bukkit.removeRecipe((NamespacedKey)key);
        ShapedRecipe recipe = new ShapedRecipe(key, StrengthItemRecipe.createStrengthItem());
        Material topLeft = this.configManager.getRecipeTopLeft();
        Material top = this.configManager.getRecipeTop();
        Material topRight = this.configManager.getRecipeTopRight();
        Material left = this.configManager.getRecipeLeft();
        Material center = this.configManager.getRecipeCenter();
        Material right = this.configManager.getRecipeRight();
        Material bottomLeft = this.configManager.getRecipeBottomLeft();
        Material bottom = this.configManager.getRecipeBottom();
        Material bottomRight = this.configManager.getRecipeBottomRight();
        recipe.shape(new String[]{"ABC", "DEF", "GHI"});
        if (topLeft != Material.AIR) {
            recipe.setIngredient('A', topLeft);
        }
        if (top != Material.AIR) {
            recipe.setIngredient('B', top);
        }
        if (topRight != Material.AIR) {
            recipe.setIngredient('C', topRight);
        }
        if (left != Material.AIR) {
            recipe.setIngredient('D', left);
        }
        if (center != Material.AIR) {
            recipe.setIngredient('E', center);
        }
        if (right != Material.AIR) {
            recipe.setIngredient('F', right);
        }
        if (bottomLeft != Material.AIR) {
            recipe.setIngredient('G', bottomLeft);
        }
        if (bottom != Material.AIR) {
            recipe.setIngredient('H', bottom);
        }
        if (bottomRight != Material.AIR) {
            recipe.setIngredient('I', bottomRight);
        }
        try {
            Bukkit.addRecipe((Recipe)recipe);
            this.plugin.getLogger().info("Registered strength item recipe successfully.");
        }
        catch (IllegalStateException e) {
            this.plugin.getLogger().warning("Recipe already exists.");
        }
    }
}

