/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import me.pipewasxd.strengthsmp.ConfigManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.plugin.Plugin;

public record StrengthManager(StrengthSMP plugin, ConfigManager configManager) {
    public int getStrength(Player player) {
        return this.plugin.getConfig().getInt("players." + String.valueOf(player.getUniqueId()) + ".strength", 0);
    }

    public void setStrength(Player player, int strength) {
        int maxStrength = this.configManager.getMaxStrength();
        int minStrength = this.configManager.getMinStrength();
        strength = Math.max(minStrength, Math.min(maxStrength, strength));
        this.plugin.getConfig().set("players." + String.valueOf(player.getUniqueId()) + ".strength", (Object)strength);
        this.plugin.saveConfig();
        this.updatePlayerAttributes(player, strength);
    }

    public void addStrength(Player player, int amount) {
        int current = this.getStrength(player);
        this.setStrength(player, current + amount);
    }

    public boolean isAtMaxStrength(Player player) {
        return this.getStrength(player) >= this.configManager.getMaxStrength();
    }

    public boolean isAtMinStrength(Player player) {
        return this.getStrength(player) <= this.configManager.getMinStrength();
    }

    private void updatePlayerAttributes(Player player, int strength) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            AttributeInstance instance = player.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
            if (instance != null) {
                NamespacedKey key = new NamespacedKey("strengthsmp", "strength_modifier");
                instance.getModifiers().stream().filter(mod -> mod.getKey().equals((Object)key)).toList().forEach(arg_0 -> ((AttributeInstance)instance).removeModifier(arg_0));
                if (strength != 0) {
                    AttributeModifier modifier = new AttributeModifier(key, (double)strength, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.HAND);
                    instance.addModifier(modifier);
                }
            }
        });
    }

    public void loadPlayerStrength(Player player) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            int strength = this.getStrength(player);
            this.updatePlayerAttributes(player, strength);
            this.plugin.getLogger().info("Loaded strength " + strength + " for player " + player.getName());
        }, 10L);
    }
}

