/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.pipewasxd.strengthsmp.StrengthManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import me.pipewasxd.strengthsmp.WeaponManager;
import me.pipewasxd.strengthsmp.WeaponType;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class BowUltimate
implements Listener {
    private final StrengthSMP plugin;
    private final WeaponManager weaponManager;
    private final StrengthManager strengthManager;
    private final Map<UUID, Integer> shotCount = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> ultimateShotCount = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> ultimateCooldown = new HashMap<UUID, Long>();
    private final Map<UUID, BukkitRunnable> cooldownTasks = new HashMap<UUID, BukkitRunnable>();

    public BowUltimate(StrengthSMP plugin, WeaponManager weaponManager, StrengthManager strengthManager) {
        this.plugin = plugin;
        this.weaponManager = weaponManager;
        this.strengthManager = strengthManager;
    }

    public boolean onAbilityCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (player.getInventory().getItemInMainHand().getType() != Material.BOW) {
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#808080:#A9A9A9>\u028f\u1d0f\u1d1c \u1d0d\u1d1cs\u1d1b \u029c\u1d0f\u029f\u1d05 \u1d00 \u0299\u1d0f\u1d21 \u1d1b\u1d0f \u1d1cs\u1d07 \u1d1b\u029c\u026as!</gradient></bold>"));
            player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.6f, 1.2f);
            return true;
        }
        if (this.weaponManager.getPlayerWeapon(player) != WeaponType.BOW) {
            return true;
        }
        if (!this.strengthManager.isAtMaxStrength(player)) {
            return true;
        }
        UUID uuid = player.getUniqueId();
        int currentCount = this.ultimateShotCount.getOrDefault(uuid, 0);
        if (this.isOnCooldown(player)) {
            long remaining = (this.ultimateCooldown.get(uuid) - System.currentTimeMillis()) / 1000L;
            return true;
        }
        return true;
    }

    @EventHandler
    public void onBowShoot(EntityShootBowEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player shooter = (Player)livingEntity;
        Entity entity = event.getProjectile();
        if (!(entity instanceof Arrow)) {
            return;
        }
        final Arrow arrow = (Arrow)entity;
        if (event.getBow() == null || event.getBow().getType() != Material.BOW) {
            return;
        }
        if (this.weaponManager.getPlayerWeapon(shooter) != WeaponType.BOW) {
            return;
        }
        if (!this.strengthManager.isAtMaxStrength(shooter)) {
            return;
        }
        UUID uuid = shooter.getUniqueId();
        int passiveShots = this.shotCount.getOrDefault(uuid, 0) + 1;
        this.shotCount.put(uuid, passiveShots);
        if (passiveShots % 3 == 0) {
            arrow.setMetadata("bow_passive_2x", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            arrow.setGlowing(true);
            shooter.playSound(shooter.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.5f);
            new BukkitRunnable(this){

                public void run() {
                    if (arrow.isDead() || !arrow.isValid()) {
                        this.cancel();
                        return;
                    }
                    Particle.DustOptions redDust = new Particle.DustOptions(Color.fromRGB((int)255, (int)0, (int)0), 1.0f);
                    arrow.getWorld().spawnParticle(Particle.DUST, arrow.getLocation(), 2, 0.05, 0.05, 0.05, (Object)redDust);
                    arrow.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, arrow.getLocation(), 1, 0.05, 0.05, 0.05, 0.01);
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        }
        if (this.isOnCooldown(shooter)) {
            return;
        }
        int ultimateShots = this.ultimateShotCount.getOrDefault(uuid, 0) + 1;
        this.ultimateShotCount.put(uuid, ultimateShots);
        if (ultimateShots >= 10) {
            arrow.setMetadata("bow_ultimate_laser", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            arrow.setGlowing(true);
            arrow.setFireTicks(100);
            this.ultimateShotCount.put(uuid, 0);
            shooter.playSound(shooter.getLocation(), Sound.ENTITY_WARDEN_SONIC_BOOM, 1.0f, 1.2f);
            shooter.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#8B0000:#B22222>\u1d1c\u029f\u1d1b\u026a\u1d0d\u1d00\u1d1b\u1d07 \u1d00\u1d04\u1d1b\u026a\u1d20\u1d00\u1d1b\u1d07\u1d05</gradient></bold>"));
            shooter.playSound(shooter.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 0.8f);
            new BukkitRunnable(this){

                public void run() {
                    if (arrow.isDead() || !arrow.isValid()) {
                        this.cancel();
                        return;
                    }
                    Location arrowLoc = arrow.getLocation();
                    Particle.DustOptions blueDust = new Particle.DustOptions(Color.fromRGB((int)0, (int)100, (int)255), 1.5f);
                    arrow.getWorld().spawnParticle(Particle.DUST, arrowLoc, 5, 0.05, 0.05, 0.05, (Object)blueDust);
                    arrow.getWorld().spawnParticle(Particle.SONIC_BOOM, arrowLoc, 1);
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        } else if (ultimateShots % 2 == 0) {
            // empty if block
        }
    }

    @EventHandler
    public void onArrowHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)projectile;
        ProjectileSource projectileSource = arrow.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player shooter = (Player)projectileSource;
        if (this.weaponManager.getPlayerWeapon(shooter) != WeaponType.BOW) {
            return;
        }
        if (arrow.hasMetadata("bow_ultimate_laser")) {
            Location hitLoc = arrow.getLocation();
            Particle.DustOptions blueDust = new Particle.DustOptions(Color.fromRGB((int)0, (int)100, (int)255), 2.0f);
            hitLoc.getWorld().spawnParticle(Particle.DUST, hitLoc, 30, 0.3, 0.3, 0.3, (Object)blueDust);
            hitLoc.getWorld().spawnParticle(Particle.SONIC_BOOM, hitLoc, 3);
            hitLoc.getWorld().playSound(hitLoc, Sound.ENTITY_WARDEN_SONIC_BOOM, 1.0f, 1.0f);
            this.startCooldown(shooter);
        }
    }

    @EventHandler
    public void onArrowDamage(EntityDamageByEntityEvent event) {
        Location targetLoc;
        Entity entity = event.getDamager();
        if (!(entity instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entity;
        ProjectileSource projectileSource = arrow.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player shooter = (Player)projectileSource;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (this.weaponManager.getPlayerWeapon(shooter) != WeaponType.BOW) {
            return;
        }
        if (arrow.hasMetadata("bow_passive_2x")) {
            event.setDamage(event.getDamage() * 2.0);
            targetLoc = event.getEntity().getLocation().add(0.0, 1.0, 0.0);
            Particle.DustOptions redDust = new Particle.DustOptions(Color.fromRGB((int)255, (int)0, (int)0), 1.5f);
            targetLoc.getWorld().spawnParticle(Particle.DUST, targetLoc, 20, 0.3, 0.5, 0.3, (Object)redDust);
            targetLoc.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, targetLoc, 10, 0.3, 0.5, 0.3, 0.05);
            targetLoc.getWorld().playSound(targetLoc, Sound.ENTITY_PLAYER_ATTACK_CRIT, 1.0f, 1.2f);
        }
        if (arrow.hasMetadata("bow_ultimate_laser")) {
            event.setDamage(event.getDamage() * 3.0);
            targetLoc = event.getEntity().getLocation().add(0.0, 1.0, 0.0);
            Particle.DustOptions blueDust = new Particle.DustOptions(Color.fromRGB((int)0, (int)100, (int)255), 2.0f);
            targetLoc.getWorld().spawnParticle(Particle.DUST, targetLoc, 50, 0.3, 0.8, 0.3, (Object)blueDust);
            targetLoc.getWorld().spawnParticle(Particle.SONIC_BOOM, targetLoc, 5);
            shooter.playSound(shooter.getLocation(), Sound.ENTITY_WARDEN_SONIC_BOOM, 1.0f, 1.0f);
            targetLoc.getWorld().playSound(targetLoc, Sound.ENTITY_WARDEN_SONIC_BOOM, 1.0f, 1.0f);
            Entity entity2 = event.getEntity();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
            }
        }
    }

    private void startCooldown(final Player player) {
        final UUID uuid = player.getUniqueId();
        this.ultimateCooldown.put(uuid, System.currentTimeMillis() + 60000L);
        player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#A9A9A9:#D3D3D3>\u1d0f\u0274 \u1d04\u1d0f\u1d0f\u029f\u1d05\u1d0f\u1d21\u0274</gradient></bold>"));
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.5f, 1.0f);
        BukkitRunnable cooldownTask = new BukkitRunnable(this){
            final /* synthetic */ BowUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#006400:#008000>\u1d1c\u029f\u1d1b\u026a\u1d0d\u1d00\u1d1b\u1d07 \u0280\u1d07\u1d00\u1d05\u028f</gradient></bold>"));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.this$0.cooldownTasks.remove(uuid);
            }
        };
        cooldownTask.runTaskLater((Plugin)this.plugin, 1200L);
        this.cooldownTasks.put(uuid, cooldownTask);
    }

    public boolean isOnCooldown(Player player) {
        Long cooldownEnd = this.ultimateCooldown.get(player.getUniqueId());
        return cooldownEnd != null && System.currentTimeMillis() < cooldownEnd;
    }
}

