/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import me.pipewasxd.strengthsmp.StrengthSMP;
import org.bukkit.Material;

public record ConfigManager(StrengthSMP plugin) {
    public ConfigManager(StrengthSMP plugin) {
        this.plugin = plugin;
        plugin.getConfig().addDefault("max-strength", (Object)5);
        plugin.getConfig().addDefault("min-strength", (Object)1);
        plugin.getConfig().addDefault("default-strength", (Object)3);
        plugin.getConfig().addDefault("recipe.strength.top-left", (Object)"ENCHANTED_GOLDEN_APPLE");
        plugin.getConfig().addDefault("recipe.strength.top", (Object)"NETHERITE_INGOT");
        plugin.getConfig().addDefault("recipe.strength.top-right", (Object)"ENCHANTED_GOLDEN_APPLE");
        plugin.getConfig().addDefault("recipe.strength.left", (Object)"NETHERITE_INGOT");
        plugin.getConfig().addDefault("recipe.strength.center", (Object)"NETHER_STAR");
        plugin.getConfig().addDefault("recipe.strength.right", (Object)"NETHERITE_INGOT");
        plugin.getConfig().addDefault("recipe.strength.bottom-left", (Object)"ENCHANTED_GOLDEN_APPLE");
        plugin.getConfig().addDefault("recipe.strength.bottom", (Object)"NETHERITE_INGOT");
        plugin.getConfig().addDefault("recipe.strength.bottom-right", (Object)"ENCHANTED_GOLDEN_APPLE");
        plugin.getConfig().addDefault("recipe.reroll.top-left", (Object)"DIAMOND_BLOCK");
        plugin.getConfig().addDefault("recipe.reroll.top", (Object)"NETHERITE_HOE");
        plugin.getConfig().addDefault("recipe.reroll.top-right", (Object)"DIAMOND_BLOCK");
        plugin.getConfig().addDefault("recipe.reroll.left", (Object)"ECHO_SHARD");
        plugin.getConfig().addDefault("recipe.reroll.center", (Object)"WITHER_SKELETON_SKULL");
        plugin.getConfig().addDefault("recipe.reroll.right", (Object)"ECHO_SHARD");
        plugin.getConfig().addDefault("recipe.reroll.bottom-left", (Object)"DIAMOND_BLOCK");
        plugin.getConfig().addDefault("recipe.reroll.bottom", (Object)"TRIDENT");
        plugin.getConfig().addDefault("recipe.reroll.bottom-right", (Object)"DIAMOND_BLOCK");
        plugin.getConfig().options().copyDefaults(true);
        plugin.saveConfig();
    }

    public int getMaxStrength() {
        return this.plugin.getConfig().getInt("max-strength", 5);
    }

    public int getMinStrength() {
        return this.plugin.getConfig().getInt("min-strength", 1);
    }

    public int getDefaultStrength() {
        return this.plugin.getConfig().getInt("default-strength", 3);
    }

    private Material getRecipeMaterial(String recipePath) {
        String material = this.plugin.getConfig().getString(recipePath, "AIR");
        try {
            return Material.valueOf((String)material.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid recipe material at " + recipePath + ": " + material + ", using AIR");
            return Material.AIR;
        }
    }

    public Material getRecipeTopLeft() {
        return this.getRecipeMaterial("recipe.strength.top-left");
    }

    public Material getRecipeTop() {
        return this.getRecipeMaterial("recipe.strength.top");
    }

    public Material getRecipeTopRight() {
        return this.getRecipeMaterial("recipe.strength.top-right");
    }

    public Material getRecipeLeft() {
        return this.getRecipeMaterial("recipe.strength.left");
    }

    public Material getRecipeCenter() {
        return this.getRecipeMaterial("recipe.strength.center");
    }

    public Material getRecipeRight() {
        return this.getRecipeMaterial("recipe.strength.right");
    }

    public Material getRecipeBottomLeft() {
        return this.getRecipeMaterial("recipe.strength.bottom-left");
    }

    public Material getRecipeBottom() {
        return this.getRecipeMaterial("recipe.strength.bottom");
    }

    public Material getRecipeBottomRight() {
        return this.getRecipeMaterial("recipe.strength.bottom-right");
    }

    public Material getRerollRecipeTopLeft() {
        return this.getRecipeMaterial("recipe.reroll.top-left");
    }

    public Material getRerollRecipeTop() {
        return this.getRecipeMaterial("recipe.reroll.top");
    }

    public Material getRerollRecipeTopRight() {
        return this.getRecipeMaterial("recipe.reroll.top-right");
    }

    public Material getRerollRecipeLeft() {
        return this.getRecipeMaterial("recipe.reroll.left");
    }

    public Material getRerollRecipeCenter() {
        return this.getRecipeMaterial("recipe.reroll.center");
    }

    public Material getRerollRecipeRight() {
        return this.getRecipeMaterial("recipe.reroll.right");
    }

    public Material getRerollRecipeBottomLeft() {
        return this.getRecipeMaterial("recipe.reroll.bottom-left");
    }

    public Material getRerollRecipeBottom() {
        return this.getRecipeMaterial("recipe.reroll.bottom");
    }

    public Material getRerollRecipeBottomRight() {
        return this.getRecipeMaterial("recipe.reroll.bottom-right");
    }
}

