/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.pipewasxd.strengthsmp.StrengthManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import me.pipewasxd.strengthsmp.WeaponManager;
import me.pipewasxd.strengthsmp.WeaponType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public record StrengthCommand(StrengthManager strengthManager, WeaponManager weaponManager, StrengthSMP plugin) implements CommandExecutor,
TabCompleter
{
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can check their strength!");
                return true;
            }
            Player player = (Player)sender;
            int strength = this.strengthManager.getStrength(player);
            WeaponType weapon = this.weaponManager.getPlayerWeapon(player);
            player.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c \u029c\u1d00\u1d20\u1d07 " + String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + strength + String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + " s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c");
            player.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u1d21\u1d07\u1d00\u1d18\u1d0f\u0274: " + String.valueOf(ChatColor.WHITE) + weapon.getDisplayName());
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("strengthsmp.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to reload the config!");
                return true;
            }
            this.plugin.reloadConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Strength SMP Configuration reloaded successfully!");
            return true;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("set")) {
            int amount;
            if (!sender.hasPermission("strengthsmp.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to set strength!");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                return true;
            }
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number!");
                return true;
            }
            this.strengthManager.setStrength(target, amount);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set " + target.getName() + "'s strength to " + amount);
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("reroll")) {
            if (!sender.hasPermission("strengthsmp.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to reroll weapons!");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                return true;
            }
            WeaponType newWeapon = WeaponType.random();
            this.weaponManager.setPlayerWeapon(target, newWeapon);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Rerolled " + target.getName() + "'s weapon to " + newWeapon.name());
            return true;
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("weapontype") && args[1].equalsIgnoreCase("set")) {
            if (!sender.hasPermission("strengthsmp.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to set weapons!");
                return true;
            }
            WeaponType weapon = WeaponType.fromString(args[2]);
            if (weapon == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid weapon type! Valid types: sword, bow, shield, trident, axe");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[3]);
            if (target == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                return true;
            }
            this.weaponManager.setPlayerWeapon(target, weapon);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set " + target.getName() + "'s weapon to " + weapon.name());
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage:");
        sender.sendMessage(String.valueOf(ChatColor.RED) + "/strength - Check your strength");
        if (sender.hasPermission("strengthsmp.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "/strength set <player> <amount> - Set player's strength");
            sender.sendMessage(String.valueOf(ChatColor.RED) + "/strength reroll <player> - Reroll player's weapon");
            sender.sendMessage(String.valueOf(ChatColor.RED) + "/strength weapontype set <weapon> <player> - Set player's weapon");
            sender.sendMessage(String.valueOf(ChatColor.RED) + "/strength reload - Reload config");
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("strengthsmp.admin")) {
                completions.add("set");
                completions.add("reroll");
                completions.add("weapontype");
                completions.add("reload");
            }
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("reroll")) {
                if (sender.hasPermission("strengthsmp.admin")) {
                    return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
                }
            } else if (args[0].equalsIgnoreCase("weapontype") && sender.hasPermission("strengthsmp.admin")) {
                completions.add("set");
            }
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("set")) {
                if (sender.hasPermission("strengthsmp.admin")) {
                    completions.add("1");
                    completions.add("3");
                    completions.add("5");
                    completions.add("10");
                }
            } else if (args[0].equalsIgnoreCase("weapontype") && args[1].equalsIgnoreCase("set") && sender.hasPermission("strengthsmp.admin")) {
                completions.add("sword");
                completions.add("axe");
                completions.add("shield");
                completions.add("trident");
                completions.add("bow");
                completions.add("crossbow");
            }
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("weapontype") && args[1].equalsIgnoreCase("set") && sender.hasPermission("strengthsmp.admin")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[3].toLowerCase())).collect(Collectors.toList());
        }
        return completions;
    }
}

