/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.ArrayList;
import java.util.List;
import me.pipewasxd.strengthsmp.ConfigManager;
import me.pipewasxd.strengthsmp.StrengthItemRecipe;
import me.pipewasxd.strengthsmp.StrengthManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public record WithdrawCommand(StrengthManager strengthManager, ConfigManager configManager) implements CommandExecutor,
TabCompleter
{
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        int minStrength;
        int amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /withdraw <amount>");
            return true;
        }
        try {
            amount = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number!");
            return true;
        }
        if (amount <= 0) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Amount must be greater than 0!");
            return true;
        }
        int currentStrength = this.strengthManager.getStrength(player);
        if (currentStrength <= (minStrength = this.configManager.getMinStrength())) {
            player.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c \u1d0d\u1d1cs\u1d1b \u029c\u1d00\u1d20\u1d07 \u1d00\u1d1b \u029f\u1d07\u1d00s\u1d1b" + String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + minStrength + String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c \u1d1b\u1d0f \u1d21\u026a\u1d1b\u029c\u1d05\u0280\u1d00\u1d21!");
            return true;
        }
        int maxWithdrawable = currentStrength - minStrength;
        if (amount > maxWithdrawable) {
            return true;
        }
        this.strengthManager.addStrength(player, -amount);
        for (int i = 0; i < amount; ++i) {
            ItemStack strengthItem = StrengthItemRecipe.createStrengthItem();
            if (player.getInventory().firstEmpty() == -1) {
                player.getWorld().dropItemNaturally(player.getLocation(), strengthItem);
                continue;
            }
            player.getInventory().addItem(new ItemStack[]{strengthItem});
        }
        player.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c \u1d21\u026a\u1d1b\u029c\u1d05\u0280\u1d07\u1d21 " + String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + amount + " " + String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c");
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        int minStrength;
        Player player;
        int currentStrength;
        int maxWithdrawable;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1 && sender instanceof Player && (maxWithdrawable = (currentStrength = this.strengthManager.getStrength(player = (Player)sender)) - (minStrength = this.configManager.getMinStrength())) > 0) {
            completions.add("1");
            if (maxWithdrawable >= 5) {
                completions.add("5");
            }
            if (maxWithdrawable >= 10) {
                completions.add("10");
            }
            completions.add(String.valueOf(maxWithdrawable));
        }
        return completions;
    }
}

