/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.pipewasxd.strengthsmp.RerollBook;
import me.pipewasxd.strengthsmp.StrengthItemRecipe;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("strengthsmp.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /item <strength|reroll> <player> [amount]");
            return true;
        }
        String itemType = args[0].toLowerCase();
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return true;
        }
        int amount = 1;
        if (args.length >= 3) {
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid amount!");
                return true;
            }
        }
        if (amount <= 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Amount must be greater than 0!");
            return true;
        }
        if (amount > 64) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Amount cannot exceed 64!");
            return true;
        }
        ItemStack item = null;
        String itemName = "";
        switch (itemType) {
            case "strength": {
                item = StrengthItemRecipe.createStrengthItem();
                itemName = "Strength Item";
                break;
            }
            case "reroll": {
                item = RerollBook.createRerollBook();
                itemName = "Reroll Book";
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid item type! Use 'strength' or 'reroll'");
                return true;
            }
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack itemToGive = item.clone();
            if (target.getInventory().firstEmpty() == -1) {
                target.getWorld().dropItemNaturally(target.getLocation(), itemToGive);
                continue;
            }
            target.getInventory().addItem(new ItemStack[]{itemToGive});
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("strengthsmp.admin")) {
                completions.add("strength");
                completions.add("reroll");
            }
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && sender.hasPermission("strengthsmp.admin")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3) {
            if (sender.hasPermission("strengthsmp.admin")) {
                completions.add("67");
            }
            return completions.stream().filter(s -> s.startsWith(args[2])).collect(Collectors.toList());
        }
        return completions;
    }
}

