/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.Objects;
import me.pipewasxd.strengthsmp.ConfigManager;
import me.pipewasxd.strengthsmp.StrengthItemRecipe;
import me.pipewasxd.strengthsmp.StrengthManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

public record PlayerDeathListener(StrengthManager strengthManager, ConfigManager configManager) implements Listener
{
    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player victim = event.getEntity();
        Player killer = victim.getKiller();
        if (killer != null && killer != victim) {
            if (!this.strengthManager.isAtMinStrength(victim)) {
                this.strengthManager.addStrength(victim, -1);
                victim.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c \u029f\u1d0fs\u1d1b " + String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + "-1" + String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + " s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c");
                if (this.strengthManager.isAtMaxStrength(killer)) {
                    ItemStack strengthItem = StrengthItemRecipe.createStrengthItem();
                    event.getDrops().add(strengthItem);
                    killer.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c \u1d00\u0280\u1d07 \u1d00\u1d1b \u1d1b\u029c\u1d07 \u1d0d\u1d00x\u026a\u1d0d\u1d1c\u1d0d \u1d00\u1d0d\u1d0f\u1d1c\u0274\u1d1b \u1d0f\u0493 s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c!");
                } else {
                    this.strengthManager.addStrength(killer, 1);
                    killer.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c \u0262\u1d00\u026a\u0274\u1d07\u1d05 " + String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + "+1" + String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + " s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c");
                }
            } else {
                victim.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c \u1d00\u0280\u1d07 \u1d00\u1d1b \u1d1b\u029c\u1d07 \u1d0d\u026a\u0274\u026a\u1d0d\u1d1c\u1d0d \u1d00\u1d0d\u1d0f\u1d1c\u0274\u1d1b \u1d0f\u0493 s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c!");
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.strengthManager.loadPlayerStrength(event.getPlayer());
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Bukkit.getScheduler().runTaskLater(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("StrengthSMP")), () -> this.strengthManager.loadPlayerStrength(event.getPlayer()), 10L);
    }
}

