/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.pipewasxd.strengthsmp.StrengthManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import me.pipewasxd.strengthsmp.WeaponManager;
import me.pipewasxd.strengthsmp.WeaponType;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AxeUltimate
implements Listener {
    private final StrengthSMP plugin;
    private final WeaponManager weaponManager;
    private final StrengthManager strengthManager;
    private final Map<UUID, UUID> lastHitTarget = new HashMap<UUID, UUID>();
    private final Map<UUID, Integer> targetHitCount = new HashMap<UUID, Integer>();
    private final Map<UUID, Boolean> ultimateActive = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> ultimateReadyToRelease = new HashMap<UUID, Boolean>();
    private final Map<UUID, Double> storedDamage = new HashMap<UUID, Double>();
    private final Map<UUID, Long> ultimateCooldown = new HashMap<UUID, Long>();
    private final Map<UUID, BukkitRunnable> cooldownTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, BukkitRunnable> soundTasks = new HashMap<UUID, BukkitRunnable>();

    public AxeUltimate(StrengthSMP plugin, WeaponManager weaponManager, StrengthManager strengthManager) {
        this.plugin = plugin;
        this.weaponManager = weaponManager;
        this.strengthManager = strengthManager;
    }

    @EventHandler
    public void onAxeHit(EntityDamageByEntityEvent event) {
        Double stored;
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity2;
        if (!this.isAxe(attacker.getInventory().getItemInMainHand().getType())) {
            return;
        }
        if (this.weaponManager.getPlayerWeapon(attacker) != WeaponType.AXE) {
            return;
        }
        if (!this.strengthManager.isAtMaxStrength(attacker)) {
            return;
        }
        UUID attackerUUID = attacker.getUniqueId();
        UUID targetUUID = target.getUniqueId();
        if (this.ultimateReadyToRelease.getOrDefault(attackerUUID, false).booleanValue() && target instanceof Player && (stored = this.storedDamage.get(attackerUUID)) != null && stored > 0.0) {
            event.setDamage(event.getDamage() + stored);
            this.storedDamage.put(attackerUUID, 0.0);
            this.ultimateReadyToRelease.put(attackerUUID, false);
            Location targetLoc = target.getLocation().add(0.0, 1.0, 0.0);
            target.getWorld().spawnParticle(Particle.END_ROD, targetLoc, 50, 0.0, 0.0, 0.0, 0.3);
            target.getWorld().spawnParticle(Particle.FIREWORK, targetLoc, 100, 0.5, 0.5, 0.5, 0.2);
            attacker.playSound(attacker.getLocation(), Sound.BLOCK_RESPAWN_ANCHOR_DEPLETE, 1.0f, 1.5f);
            return;
        }
        if (this.ultimateActive.getOrDefault(attackerUUID, false).booleanValue()) {
            double damage = event.getDamage();
            this.storedDamage.put(attackerUUID, this.storedDamage.getOrDefault(attackerUUID, 0.0) + damage);
            event.setDamage(0.0);
            attacker.playSound(attacker.getLocation(), Sound.ENTITY_ELDER_GUARDIAN_CURSE, 0.5f, 1.5f);
            return;
        }
        if (event.isCritical()) {
            UUID lastTarget = this.lastHitTarget.get(attackerUUID);
            if (lastTarget == null || !lastTarget.equals(targetUUID)) {
                this.lastHitTarget.put(attackerUUID, targetUUID);
                this.targetHitCount.put(attackerUUID, 1);
            } else {
                int hits = this.targetHitCount.getOrDefault(attackerUUID, 0) + 1;
                this.targetHitCount.put(attackerUUID, hits);
                if (hits >= 5) {
                    this.applyStun(target);
                    this.targetHitCount.put(attackerUUID, 0);
                    this.lastHitTarget.remove(attackerUUID);
                    attacker.playSound(attacker.getLocation(), Sound.ENTITY_IRON_GOLEM_ATTACK, 1.0f, 0.8f);
                    if (target instanceof Player) {
                        Player targetPlayer = (Player)target;
                        targetPlayer.playSound(targetPlayer.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onSwapHands(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        if (this.weaponManager.getPlayerWeapon(player) != WeaponType.AXE) {
            return;
        }
        if (!this.strengthManager.isAtMaxStrength(player)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        event.setCancelled(true);
        if (this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            return;
        }
        if (this.isOnCooldown(player)) {
            return;
        }
        this.activateUltimate(player);
    }

    public void activateUltimate(final Player player) {
        final UUID uuid = player.getUniqueId();
        this.ultimateActive.put(uuid, true);
        this.storedDamage.put(uuid, 0.0);
        player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#8B0000:#B22222>\u1d1c\u029f\u1d1b\u026a\u1d0d\u1d00\u1d1b\u1d07 \u1d00\u1d04\u1d1b\u026a\u1d20\u1d00\u1d1b\u1d07\u1d05</gradient></bold>"));
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 0.8f);
        for (LivingEntity entity : player.getWorld().getNearbyLivingEntities(player.getLocation(), 30.0, 10.0, 30.0)) {
            if (entity.equals((Object)player)) continue;
            entity.getWorld().playSound(entity.getLocation(), Sound.ENTITY_ELDER_GUARDIAN_CURSE, 1.0f, 1.0f);
        }
        BukkitRunnable soundTask = new BukkitRunnable(this){
            int ticks = 0;
            final /* synthetic */ AxeUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks >= 5 || !this.this$0.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
                    this.cancel();
                    return;
                }
                Location loc = player.getLocation();
                for (Player nearbyPlayer : player.getWorld().getPlayers()) {
                    if (!(nearbyPlayer.getLocation().distance(loc) <= 30.0)) continue;
                    nearbyPlayer.playSound(loc, Sound.ENTITY_ELDER_GUARDIAN_CURSE, 0.8f, 1.5f);
                }
                ++this.ticks;
            }
        };
        soundTask.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        this.soundTasks.put(uuid, soundTask);
        new BukkitRunnable(this){
            final /* synthetic */ AxeUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                BukkitRunnable task = this.this$0.soundTasks.remove(uuid);
                if (task != null) {
                    task.cancel();
                }
                this.this$0.deactivateUltimate(player);
            }
        }.runTaskLater((Plugin)this.plugin, 100L);
    }

    private void deactivateUltimate(final Player player) {
        final UUID uuid = player.getUniqueId();
        if (!this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            return;
        }
        this.ultimateActive.put(uuid, false);
        this.ultimateReadyToRelease.put(uuid, true);
        this.ultimateCooldown.put(uuid, System.currentTimeMillis() + 60000L);
        player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#A9A9A9:#D3D3D3>\u1d0f\u0274 \u1d04\u1d0f\u1d0f\u029f\u1d05\u1d0f\u1d21\u0274</gradient></bold>"));
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.5f, 1.0f);
        BukkitRunnable cooldownTask = new BukkitRunnable(this){
            final /* synthetic */ AxeUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#006400:#008000>\u1d1c\u029f\u1d1b\u026a\u1d0d\u1d00\u1d1b\u1d07 \u0280\u1d07\u1d00\u1d05\u028f</gradient></bold>"));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.this$0.cooldownTasks.remove(uuid);
            }
        };
        cooldownTask.runTaskLater((Plugin)this.plugin, 1200L);
        this.cooldownTasks.put(uuid, cooldownTask);
    }

    private void applyStun(final LivingEntity target) {
        final Location freezeLocation = target.getLocation().clone();
        new BukkitRunnable(this){
            int ticks = 0;
            final int maxTicks = 60;

            public void run() {
                if (this.ticks >= 60 || !target.isValid() || target.isDead()) {
                    this.cancel();
                    return;
                }
                target.teleport(freezeLocation);
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public boolean isOnCooldown(Player player) {
        Long cooldownEnd = this.ultimateCooldown.get(player.getUniqueId());
        return cooldownEnd != null && System.currentTimeMillis() < cooldownEnd;
    }

    private boolean isAxe(Material material) {
        return switch (material) {
            case Material.WOODEN_AXE, Material.STONE_AXE, Material.IRON_AXE, Material.GOLDEN_AXE, Material.DIAMOND_AXE, Material.NETHERITE_AXE -> true;
            default -> false;
        };
    }
}

