/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.pipewasxd.strengthsmp.StrengthManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import me.pipewasxd.strengthsmp.WeaponManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class BowUltimate
implements Listener {
    private final StrengthSMP plugin;
    private final WeaponManager weaponManager;
    private final StrengthManager strengthManager;
    private final Map<UUID, Boolean> passiveActive = new HashMap<UUID, Boolean>();
    private final Map<UUID, BukkitRunnable> passiveTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, UUID> firstHitTarget = new HashMap<UUID, UUID>();
    private final Map<UUID, Long> firstHitTime = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> hitCount = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> ultimateCooldown = new HashMap<UUID, Long>();
    private final Map<UUID, BukkitRunnable> cooldownTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, Arrow> trackedArrows = new HashMap<UUID, Arrow>();

    public BowUltimate(StrengthSMP plugin, WeaponManager weaponManager, StrengthManager strengthManager) {
        this.plugin = plugin;
        this.weaponManager = weaponManager;
        this.strengthManager = strengthManager;
    }

    @EventHandler
    public void onBowShoot(EntityShootBowEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player shooter = (Player)livingEntity;
        Entity entity = event.getProjectile();
        if (!(entity instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entity;
        if (!this.strengthManager.isAtMaxStrength(shooter)) {
            return;
        }
        this.trackedArrows.put(arrow.getUniqueId(), arrow);
    }

    @EventHandler
    public void onArrowHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)projectile;
        ProjectileSource projectileSource = arrow.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player shooter = (Player)projectileSource;
        if (!this.trackedArrows.containsKey(arrow.getUniqueId())) {
            return;
        }
        Entity hitEntity = event.getHitEntity();
        if (hitEntity == null || !(hitEntity instanceof Player)) {
            this.resetUltimateProgress(shooter);
            this.trackedArrows.remove(arrow.getUniqueId());
            return;
        }
        Player target = (Player)hitEntity;
        UUID shooterUUID = shooter.getUniqueId();
        UUID targetUUID = target.getUniqueId();
        UUID firstTarget = this.firstHitTarget.get(shooterUUID);
        Long firstTime = this.firstHitTime.get(shooterUUID);
        int hits = this.hitCount.getOrDefault(shooterUUID, 0);
        if (firstTarget == null || !firstTarget.equals(targetUUID) || firstTime != null && System.currentTimeMillis() - firstTime > 15000L) {
            this.firstHitTarget.put(shooterUUID, targetUUID);
            this.firstHitTime.put(shooterUUID, System.currentTimeMillis());
            this.hitCount.put(shooterUUID, 1);
        } else if (firstTarget.equals(targetUUID)) {
            this.hitCount.put(shooterUUID, ++hits);
            if (hits == 3) {
                this.markArrowForUltimate(arrow);
                this.hitCount.put(shooterUUID, 0);
                this.firstHitTarget.remove(shooterUUID);
                shooter.sendMessage((Component)Component.text((String)"<gradient:#800000:#ff0000>\u00e1\u00b4\u0153\u00ca\u0178\u00e1\u00b4\u203a\u00c9\u00aa\u00e1\u00b4\u00e1\u00b4\u20ac\u00e1\u00b4\u203a\u00e1\u00b4\u2021 \u00ca\u20ac\u00e1\u00b4\u2021\u00e1\u00b4\u20ac\u00e1\u00b4\u2026\u00ca</gradient>"));
                shooter.playSound(shooter.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 0.8f);
            }
        }
        this.trackedArrows.remove(arrow.getUniqueId());
    }

    @EventHandler
    public void onUltimateDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entity;
        ProjectileSource projectileSource = arrow.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player shooter = (Player)projectileSource;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player target = (Player)entity2;
        if (arrow.hasMetadata("ultimate_arrow")) {
            double currentDamage = event.getDamage();
            event.setDamage(currentDamage * 2.5);
            this.spawnParticleBeam(shooter.getEyeLocation(), target.getLocation().add(0.0, 1.0, 0.0));
            shooter.playSound(shooter.getLocation(), Sound.ENTITY_WARDEN_SONIC_BOOM, 1.0f, 1.0f);
            target.playSound(target.getLocation(), Sound.ENTITY_WARDEN_SONIC_BOOM, 1.0f, 1.0f);
            this.activatePassive(shooter);
            this.startUltimateCooldown(shooter);
            arrow.removeMetadata("ultimate_arrow", (Plugin)this.plugin);
        }
    }

    private void markArrowForUltimate(Arrow arrow) {
        arrow.setMetadata("ultimate_arrow", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
    }

    private void spawnParticleBeam(Location start, Location end) {
        Vector direction = end.toVector().subtract(start.toVector());
        double distance = start.distance(end);
        direction.normalize().multiply(0.5);
        Location current = start.clone();
        for (double d = 0.0; d < distance; d += 0.5) {
            current.getWorld().spawnParticle(Particle.DUST, current, 3, 0.1, 0.1, 0.1, (Object)new Particle.DustOptions(Color.RED, 1.5f));
            current.add(direction);
        }
    }

    public void activatePassive(Player player) {
        final UUID uuid = player.getUniqueId();
        BukkitRunnable existingTask = this.passiveTasks.get(uuid);
        if (existingTask != null) {
            existingTask.cancel();
        }
        this.passiveActive.put(uuid, true);
        BukkitRunnable passiveTask = new BukkitRunnable(this){
            final /* synthetic */ BowUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.passiveActive.put(uuid, false);
                this.this$0.passiveTasks.remove(uuid);
            }
        };
        passiveTask.runTaskLater((Plugin)this.plugin, 300L);
        this.passiveTasks.put(uuid, passiveTask);
    }

    private void resetUltimateProgress(Player player) {
        UUID uuid = player.getUniqueId();
        this.firstHitTarget.remove(uuid);
        this.firstHitTime.remove(uuid);
        this.hitCount.put(uuid, 0);
    }

    private void startUltimateCooldown(final Player player) {
        final UUID uuid = player.getUniqueId();
        this.ultimateCooldown.put(uuid, System.currentTimeMillis() + 60000L);
        player.sendMessage((Component)Component.text((String)"<gradient:#660000:#cc0000>\u00e1\u00b4\u0153\u00ca\u0178\u00e1\u00b4\u203a\u00c9\u00aa\u00e1\u00b4\u00e1\u00b4\u20ac\u00e1\u00b4\u203a\u00e1\u00b4\u2021 \u00e1\u00b4\u00e1\u00b4 \u00e1\u00b4\u2021\u00ca\u20ac \u00e1\u00b4\u00c9\u00b4 \u00e1\u00b4\u201e\u00e1\u00b4\u00e1\u00b4\u00ca\u0178\u00e1\u00b4\u2026\u00e1\u00b4\u00e1\u00b4\u00a1\u00c9\u00b4</gradient>"));
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.5f, 1.0f);
        BukkitRunnable cooldownTask = new BukkitRunnable(this){
            final /* synthetic */ BowUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                player.sendMessage((Component)Component.text((String)"<gradient:#004d00:#00b300>\u00e1\u00b4\u201e\u00e1\u00b4\u00e1\u00b4\u00ca\u0178\u00e1\u00b4\u2026\u00e1\u00b4\u00e1\u00b4\u00a1\u00c9\u00b4 \u00e1\u00b4\u00e1\u00b4 \u00e1\u00b4\u2021\u00ca\u20ac</gradient>"));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.this$0.cooldownTasks.remove(uuid);
            }
        };
        cooldownTask.runTaskLater((Plugin)this.plugin, 1200L);
        this.cooldownTasks.put(uuid, cooldownTask);
    }

    public boolean isPassiveActive(Player player) {
        return this.passiveActive.getOrDefault(player.getUniqueId(), false);
    }

    public boolean isOnCooldown(Player player) {
        Long cooldownEnd = this.ultimateCooldown.get(player.getUniqueId());
        return cooldownEnd != null && System.currentTimeMillis() < cooldownEnd;
    }
}

