/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.pipewasxd.strengthsmp.StrengthManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import me.pipewasxd.strengthsmp.WeaponManager;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ShieldUltimate
implements Listener {
    private final StrengthSMP plugin;
    private final WeaponManager weaponManager;
    private final StrengthManager strengthManager;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final Map<UUID, Boolean> ultimateActive = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> ultimateCooldown = new HashMap<UUID, Long>();
    private final Map<UUID, BukkitRunnable> cooldownTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, BukkitRunnable> ultimateTasks = new HashMap<UUID, BukkitRunnable>();

    public ShieldUltimate(StrengthSMP plugin, WeaponManager weaponManager, StrengthManager strengthManager) {
        this.plugin = plugin;
        this.weaponManager = weaponManager;
        this.strengthManager = strengthManager;
    }

    @EventHandler
    public void onShieldUserDamaged(EntityDamageByEntityEvent event) {
        int remainingDurability;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity2;
        if (!this.strengthManager.isAtMaxStrength(victim)) {
            return;
        }
        if (victim.isBlocking() && victim.getInventory().getItemInOffHand().getType() == Material.SHIELD && (remainingDurability = victim.getInventory().getItemInOffHand().getType().getMaxDurability() - victim.getInventory().getItemInOffHand().getDurability()) <= 10) {
            this.applyPassiveEffect(attacker, victim);
        }
        if (this.ultimateActive.getOrDefault(victim.getUniqueId(), false).booleanValue()) {
            event.setDamage(event.getDamage() * 0.15);
            victim.getWorld().spawnParticle(Particle.ENCHANT, victim.getLocation().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.1);
        }
    }

    private void applyPassiveEffect(Player attacker, Player victim) {
        attacker.damage(4.0);
        Vector direction = attacker.getLocation().toVector().subtract(victim.getLocation().toVector()).normalize();
        direction.setY(0.5);
        direction.multiply(2.5);
        attacker.setVelocity(direction);
        victim.playSound(victim.getLocation(), Sound.ENTITY_IRON_GOLEM_ATTACK, 1.0f, 0.8f);
        attacker.playSound(attacker.getLocation(), Sound.ENTITY_PLAYER_HURT, 1.0f, 1.0f);
        victim.getWorld().spawnParticle(Particle.EXPLOSION, attacker.getLocation().add(0.0, 1.0, 0.0), 5, 0.3, 0.3, 0.3, 0.1);
    }

    @EventHandler
    public void onSwapHands(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        if (!this.strengthManager.isAtMaxStrength(player)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        event.setCancelled(true);
        if (this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            return;
        }
        if (this.isOnCooldown(player)) {
            return;
        }
        this.activateUltimate(player);
    }

    public void activateUltimate(final Player player) {
        UUID uuid = player.getUniqueId();
        this.ultimateActive.put(uuid, true);
        double maxHealth = player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        double healAmount = maxHealth * 0.2;
        double newHealth = Math.min(player.getHealth() + healAmount, maxHealth);
        player.setHealth(newHealth);
        player.sendMessage(this.miniMessage.deserialize((Object)"<bold><gradient:#8B0000:#B22222>\u1d1c\u029f\u1d1b\u026a\u1d0d\u1d00\u1d1b\u1d07 \u0280\u1d07\u1d00\u1d05\u028f</gradient></bold>"));
        player.playSound(player.getLocation(), Sound.ITEM_TOTEM_USE, 1.0f, 1.2f);
        BukkitRunnable particleTask = new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if (this.ticks >= 200 || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                player.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, player.getLocation().add(0.0, 1.0, 0.0), 3, 0.3, 0.5, 0.3, 0.01);
                this.ticks += 5;
            }
        };
        particleTask.runTaskTimer((Plugin)this.plugin, 0L, 5L);
        this.ultimateTasks.put(uuid, particleTask);
        new BukkitRunnable(this){
            final /* synthetic */ ShieldUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.deactivateUltimate(player);
            }
        }.runTaskLater((Plugin)this.plugin, 200L);
    }

    private void deactivateUltimate(final Player player) {
        final UUID uuid = player.getUniqueId();
        if (!this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            return;
        }
        BukkitRunnable task = this.ultimateTasks.remove(uuid);
        if (task != null) {
            task.cancel();
        }
        this.ultimateActive.put(uuid, false);
        this.ultimateCooldown.put(uuid, System.currentTimeMillis() + 60000L);
        player.sendMessage(this.miniMessage.deserialize((Object)"<bold><gradient:#A9A9A9:#D3D3D3>\u1d0f\u0274 \u1d04\u1d0f\u1d0f\u029f\u1d05\u1d0f\u1d21\u0274</gradient></bold>"));
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.5f, 1.0f);
        BukkitRunnable cooldownTask = new BukkitRunnable(this){
            final /* synthetic */ ShieldUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                player.sendMessage(this.this$0.miniMessage.deserialize((Object)"<bold><gradient:#006400:#008000>\u1d04\u1d0f\u1d0f\u029f\u1d05\u1d0f\u1d21\u0274 \u1d0f\u1d20\u1d07\u0280</gradient></bold>"));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.this$0.cooldownTasks.remove(uuid);
            }
        };
        cooldownTask.runTaskLater((Plugin)this.plugin, 1200L);
        this.cooldownTasks.put(uuid, cooldownTask);
    }

    public boolean isOnCooldown(Player player) {
        Long cooldownEnd = this.ultimateCooldown.get(player.getUniqueId());
        return cooldownEnd != null && System.currentTimeMillis() < cooldownEnd;
    }
}

