/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.pipewasxd.strengthsmp.StrengthManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import me.pipewasxd.strengthsmp.WeaponManager;
import me.pipewasxd.strengthsmp.WeaponType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public record StrengthCommand(StrengthManager strengthManager, WeaponManager weaponManager, StrengthSMP plugin) implements CommandExecutor,
TabCompleter
{
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            int strength = this.strengthManager.getStrength(player);
            WeaponType weapon = this.weaponManager.getPlayerWeapon(player);
            player.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c \u029c\u1d00\u1d20\u1d07 " + String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + strength + String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + " s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c");
            player.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u1d21\u1d07\u1d00\u1d18\u1d0f\u0274: " + weapon.getDisplayName());
            return true;
        }
        if (args[0].equalsIgnoreCase("set")) {
            if (!player.hasPermission("strengthsmp.admin")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (args.length < 3) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /strength set <player> <amount>");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                return true;
            }
            try {
                int amount = Integer.parseInt(args[2]);
                this.strengthManager.setStrength(target, amount);
                int actualStrength = this.strengthManager.getStrength(target);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Set " + target.getName() + "'s strength to " + actualStrength);
                target.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c\u0280 s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c \u029c\u1d00s \u0299\u1d07\u1d07\u0274 s\u1d07\u1d1b \u1d1b\u1d0f " + String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + actualStrength);
            }
            catch (NumberFormatException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number!");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!player.hasPermission("strengthsmp.admin")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            this.plugin.reloadConfig();
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "StrengthSMP config reloaded!");
            return true;
        }
        if (args[0].equalsIgnoreCase("reroll")) {
            if (!player.hasPermission("strengthsmp.admin")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (args.length < 2) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /strength reroll <player>");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                return true;
            }
            WeaponType newWeapon = WeaponType.random();
            this.weaponManager.setPlayerWeapon(target, newWeapon);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Rerolled " + target.getName() + "'s weapon to " + newWeapon.getDisplayName());
            target.sendMessage(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c\u0280 \u1d21\u1d07\u1d00\u1d18\u1d0f\u0274 \u029c\u1d00s \u0299\u1d07\u1d07\u0274 \u0280\u1d07\u0280\u1d0f\u029f\u029f\u1d07\u1d05 \u1d1b\u1d0f " + newWeapon.getDisplayName());
            return true;
        }
        if (args[0].equalsIgnoreCase("weapontype")) {
            if (!player.hasPermission("strengthsmp.admin")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (args.length < 4 || !args[1].equalsIgnoreCase("set")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /strength weapontype set <weapontype> <player>");
                return true;
            }
            WeaponType weaponType = WeaponType.fromString(args[2]);
            if (weaponType == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid weapon type! Valid types: sword, trident, axe");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[3]);
            if (target == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                return true;
            }
            this.weaponManager.setPlayerWeapon(target, weaponType);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Set " + target.getName() + "'s weapon to " + weaponType.getDisplayName());
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /strength [set <player> <amount>] [reload] [reroll <player>] [weapontype set <type> <player>]");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> options = Arrays.asList("set", "reload", "reroll", "weapontype");
            return options.stream().filter(opt -> opt.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("reroll")) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args[0].equalsIgnoreCase("weapontype") && "set".startsWith(args[1].toLowerCase())) {
                completions.add("set");
            }
        } else if (args.length == 3) {
            if (args[0].equalsIgnoreCase("set")) {
                completions.addAll(Arrays.asList("-5", "0", "1", "5"));
            } else if (args[0].equalsIgnoreCase("weapontype") && args[1].equalsIgnoreCase("set")) {
                return Arrays.stream(WeaponType.values()).map(type -> type.name().toLowerCase()).filter(name -> name.startsWith(args[2].toLowerCase())).collect(Collectors.toList());
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("weapontype") && args[1].equalsIgnoreCase("set")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[3].toLowerCase())).collect(Collectors.toList());
        }
        return completions;
    }
}

