/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.pipewasxd.strengthsmp.StrengthManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import me.pipewasxd.strengthsmp.WeaponManager;
import me.pipewasxd.strengthsmp.WeaponType;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SwordUltimate
implements Listener {
    private final StrengthSMP plugin;
    private final WeaponManager weaponManager;
    private final StrengthManager strengthManager;
    private final Map<UUID, Integer> hitCombo = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> lastHitTime = new HashMap<UUID, Long>();
    private final Map<UUID, Boolean> autoCritActive = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> ultimateActive = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> ultimateCooldown = new HashMap<UUID, Long>();
    private final Map<UUID, ItemStack> savedOffhandItems = new HashMap<UUID, ItemStack>();
    private final Map<UUID, BukkitRunnable> cooldownTasks = new HashMap<UUID, BukkitRunnable>();
    private final NamespacedKey ultimateKey;

    public SwordUltimate(StrengthSMP plugin, WeaponManager weaponManager, StrengthManager strengthManager) {
        this.plugin = plugin;
        this.weaponManager = weaponManager;
        this.strengthManager = strengthManager;
        this.ultimateKey = new NamespacedKey((Plugin)plugin, "ultimate_sword");
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        ItemStack weapon = attacker.getInventory().getItemInMainHand();
        if (!this.isSword(weapon.getType())) {
            return;
        }
        if (this.weaponManager.getPlayerWeapon(attacker) != WeaponType.SWORD) {
            return;
        }
        if (!this.strengthManager.isAtMaxStrength(attacker)) {
            return;
        }
        UUID uuid = attacker.getUniqueId();
        long currentTime = System.currentTimeMillis();
        Long lastHit = this.lastHitTime.get(uuid);
        if (lastHit != null && currentTime - lastHit < 500L) {
            return;
        }
        if (lastHit != null && currentTime - lastHit > 1500L) {
            this.resetCombo(attacker);
        }
        this.lastHitTime.put(uuid, currentTime);
        int combo = this.hitCombo.getOrDefault(uuid, 0) + 1;
        this.hitCombo.put(uuid, combo);
        if (combo == 3 && !this.autoCritActive.getOrDefault(uuid, false).booleanValue()) {
            this.autoCritActive.put(uuid, true);
            attacker.playSound(attacker.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.5f);
        }
        if (combo == 5 && !this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            this.activateUltimate(attacker);
        }
        if (this.autoCritActive.getOrDefault(uuid, false).booleanValue() && !event.isCritical()) {
            event.setDamage(event.getDamage() * 1.5);
            attacker.playSound(attacker.getLocation(), Sound.ENTITY_PLAYER_ATTACK_CRIT, 0.5f, 1.0f);
            attacker.getWorld().spawnParticle(Particle.CRIT, event.getEntity().getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.05);
        }
    }

    @EventHandler
    public void onSwapHands(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (this.ultimateActive.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        ItemStack item = event.getItemDrop().getItemStack();
        if (this.isUltimateSword(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack offhand;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.ultimateActive.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (this.isUltimateSword(clicked)) {
            event.setCancelled(true);
        }
        if (event.getSlotType() == InventoryType.SlotType.CONTAINER && this.isUltimateSword(offhand = player.getInventory().getItemInOffHand())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.ultimateActive.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return;
        }
        ItemStack offhand = player.getInventory().getItemInOffHand();
        if (this.isUltimateSword(offhand)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        ItemStack offhand = player.getInventory().getItemInOffHand();
        if (this.isUltimateSword(offhand)) {
            event.getDrops().removeIf(this::isUltimateSword);
            player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
        }
    }

    @EventHandler
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        if (!this.ultimateActive.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return;
        }
        ItemStack newItem = player.getInventory().getItem(event.getNewSlot());
        assert (newItem != null);
        this.applyAttackSpeedBoost(player, this.isSword(newItem.getType()));
    }

    @EventHandler
    public void onPlayerSwapInventory(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (this.ultimateActive.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            event.setCancelled(true);
        }
    }

    private boolean isUltimateSword(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        Byte marker = (Byte)item.getItemMeta().getPersistentDataContainer().get(this.ultimateKey, PersistentDataType.BYTE);
        return marker != null && marker == 1;
    }

    private void activateUltimate(final Player player) {
        UUID uuid = player.getUniqueId();
        if (this.isOnCooldown(player)) {
            return;
        }
        ItemStack offhand = player.getInventory().getItemInOffHand();
        this.savedOffhandItems.put(uuid, offhand.clone());
        ItemStack mainSword = player.getInventory().getItemInMainHand().clone();
        ItemMeta meta = mainSword.getItemMeta();
        if (meta != null) {
            meta.addEnchant(Enchantment.VANISHING_CURSE, 1, true);
            meta.getPersistentDataContainer().set(this.ultimateKey, PersistentDataType.BYTE, (Object)1);
            mainSword.setItemMeta(meta);
        }
        player.getInventory().setItemInOffHand(mainSword);
        this.ultimateActive.put(uuid, true);
        if (this.isSword(player.getInventory().getItemInMainHand().getType())) {
            this.applyAttackSpeedBoost(player, true);
        }
        player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#8B0000:#B22222>\u1d1c\u029f\u1d1b\u026a\u1d0d\u1d00\u1d1b\u1d07 \u1d00\u1d04\u1d1b\u026a\u1d20\u1d00\u1d1b\u1d07\u1d05</gradient></bold>"));
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 0.8f);
        new BukkitRunnable(this){
            final /* synthetic */ SwordUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.deactivateUltimate(player);
            }
        }.runTaskLater((Plugin)this.plugin, 300L);
    }

    private void deactivateUltimate(final Player player) {
        final UUID uuid = player.getUniqueId();
        if (!this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            return;
        }
        ItemStack originalOffhand = this.savedOffhandItems.remove(uuid);
        player.getInventory().setItemInOffHand(originalOffhand != null ? originalOffhand : new ItemStack(Material.AIR));
        this.applyAttackSpeedBoost(player, false);
        this.ultimateActive.put(uuid, false);
        this.ultimateCooldown.put(uuid, System.currentTimeMillis() + 60000L);
        this.resetCombo(player);
        player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#A9A9A9:#D3D3D3>\u1d0f\u0274 \u1d04\u1d0f\u1d0f\u029f\u1d05\u1d0f\u1d21\u0274</gradient></bold>"));
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.5f, 1.0f);
        BukkitRunnable cooldownTask = new BukkitRunnable(this){
            final /* synthetic */ SwordUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#006400:#008000>\u1d1c\u029f\u1d1b\u026a\u1d0d\u1d00\u1d1b\u1d07 \u0280\u1d07\u1d00\u1d05\u028f</gradient></bold>"));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.this$0.cooldownTasks.remove(uuid);
            }
        };
        cooldownTask.runTaskLater((Plugin)this.plugin, 1200L);
        this.cooldownTasks.put(uuid, cooldownTask);
    }

    private void resetCombo(Player player) {
        UUID uuid = player.getUniqueId();
        this.hitCombo.put(uuid, 0);
        this.autoCritActive.put(uuid, false);
    }

    private void applyAttackSpeedBoost(Player player, boolean apply) {
        AttributeInstance attackSpeed = player.getAttribute(Attribute.GENERIC_ATTACK_SPEED);
        if (attackSpeed == null) {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "sword_ultimate_speed");
        attackSpeed.getModifiers().stream().filter(mod -> mod.getKey().equals((Object)key)).forEach(arg_0 -> ((AttributeInstance)attackSpeed).removeModifier(arg_0));
        if (apply) {
            AttributeModifier modifier = new AttributeModifier(key, 4.0, AttributeModifier.Operation.ADD_NUMBER);
            attackSpeed.addModifier(modifier);
        }
    }

    public boolean isOnCooldown(Player player) {
        Long cooldownEnd = this.ultimateCooldown.get(player.getUniqueId());
        return cooldownEnd != null && System.currentTimeMillis() < cooldownEnd;
    }

    private boolean isSword(Material material) {
        return switch (material) {
            case Material.WOODEN_SWORD, Material.STONE_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.DIAMOND_SWORD, Material.NETHERITE_SWORD -> true;
            default -> false;
        };
    }
}

