/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import me.pipewasxd.strengthsmp.StrengthSMP;
import org.bukkit.Material;

public record ConfigManager(StrengthSMP plugin) {
    public ConfigManager(StrengthSMP plugin) {
        this.plugin = plugin;
        plugin.getConfig().addDefault("max-strength", (Object)5);
        plugin.getConfig().addDefault("min-strength", (Object)1);
        plugin.getConfig().addDefault("default-strength", (Object)3);
        plugin.getConfig().addDefault("recipe.top-left", (Object)"ENCHANTED_GOLDEN_APPLE");
        plugin.getConfig().addDefault("recipe.top", (Object)"NETHERITE_INGOT");
        plugin.getConfig().addDefault("recipe.top-right", (Object)"ENCHANTED_GOLDEN_APPLE");
        plugin.getConfig().addDefault("recipe.left", (Object)"NETHERITE_INGOT");
        plugin.getConfig().addDefault("recipe.center", (Object)"NETHER_STAR");
        plugin.getConfig().addDefault("recipe.right", (Object)"NETHERITE_INGOT");
        plugin.getConfig().addDefault("recipe.bottom-left", (Object)"ENCHANTED_GOLDEN_APPLE");
        plugin.getConfig().addDefault("recipe.bottom", (Object)"NETHERITE_INGOT");
        plugin.getConfig().addDefault("recipe.bottom-right", (Object)"ENCHANTED_GOLDEN_APPLE");
        plugin.getConfig().options().copyDefaults(true);
        plugin.saveConfig();
    }

    public int getMaxStrength() {
        return this.plugin.getConfig().getInt("max-strength", 5);
    }

    public int getMinStrength() {
        return this.plugin.getConfig().getInt("min-strength", 1);
    }

    public int getDefaultStrength() {
        return this.plugin.getConfig().getInt("default-strength", 3);
    }

    public Material getRecipeMaterial(String position) {
        String material = this.plugin.getConfig().getString("recipe." + position, "AIR");
        try {
            return Material.valueOf((String)material.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid recipe material at " + position + ": " + material + ", using AIR");
            return Material.AIR;
        }
    }

    public Material getRecipeTopLeft() {
        return this.getRecipeMaterial("top-left");
    }

    public Material getRecipeTop() {
        return this.getRecipeMaterial("top");
    }

    public Material getRecipeTopRight() {
        return this.getRecipeMaterial("top-right");
    }

    public Material getRecipeLeft() {
        return this.getRecipeMaterial("left");
    }

    public Material getRecipeCenter() {
        return this.getRecipeMaterial("center");
    }

    public Material getRecipeRight() {
        return this.getRecipeMaterial("right");
    }

    public Material getRecipeBottomLeft() {
        return this.getRecipeMaterial("bottom-left");
    }

    public Material getRecipeBottom() {
        return this.getRecipeMaterial("bottom");
    }

    public Material getRecipeBottomRight() {
        return this.getRecipeMaterial("bottom-right");
    }
}

