/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.pipewasxd.strengthsmp.StrengthManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import me.pipewasxd.strengthsmp.WeaponManager;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class CrossbowUltimate
implements Listener {
    private final StrengthSMP plugin;
    private final WeaponManager weaponManager;
    private final StrengthManager strengthManager;
    private final Map<UUID, Boolean> ultimateActive = new HashMap<UUID, Boolean>();
    private final Map<UUID, Integer> shotCount = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> ultimateCooldown = new HashMap<UUID, Long>();
    private final Map<UUID, BukkitRunnable> cooldownTasks = new HashMap<UUID, BukkitRunnable>();

    public CrossbowUltimate(StrengthSMP plugin, WeaponManager weaponManager, StrengthManager strengthManager) {
        this.plugin = plugin;
        this.weaponManager = weaponManager;
        this.strengthManager = strengthManager;
    }

    @EventHandler
    public void onCrossbowShoot(EntityShootBowEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player shooter = (Player)livingEntity;
        Entity entity = event.getProjectile();
        if (!(entity instanceof Arrow)) {
            return;
        }
        final Arrow arrow = (Arrow)entity;
        if (event.getBow() == null || event.getBow().getType() != Material.CROSSBOW) {
            return;
        }
        if (!this.strengthManager.isAtMaxStrength(shooter)) {
            return;
        }
        UUID uuid = shooter.getUniqueId();
        if (this.isOnCooldown(shooter)) {
            return;
        }
        if (!this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            this.ultimateActive.put(uuid, true);
            this.shotCount.put(uuid, 0);
        }
        int shots = this.shotCount.getOrDefault(uuid, 0) + 1;
        this.shotCount.put(uuid, shots);
        if (shots == 10) {
            arrow.setMetadata("crossbow_ultimate_arrow", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            arrow.setGlowing(true);
            arrow.setFireTicks(100);
            shooter.playSound(shooter.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.2f);
            shooter.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#8B0000:#B22222>\u1d1c\u029f\u1d1b\u026a\u1d0d\u1d00\u1d1b\u1d07 \u0280\u1d07\u1d00\u1d05\u028f</gradient></bold>"));
            new BukkitRunnable(this){

                public void run() {
                    if (arrow.isDead() || !arrow.isValid()) {
                        this.cancel();
                        return;
                    }
                    arrow.getWorld().spawnParticle(Particle.FLAME, arrow.getLocation(), 5, 0.1, 0.1, 0.1, 0.02);
                    arrow.getWorld().spawnParticle(Particle.SMOKE, arrow.getLocation(), 2, 0.05, 0.05, 0.05, 0.01);
                    arrow.getWorld().spawnParticle(Particle.CRIT, arrow.getLocation(), 3, 0.1, 0.1, 0.1, 0.01);
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
            this.deactivateUltimate(shooter);
        }
    }

    @EventHandler
    public void onArrowDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entity;
        ProjectileSource projectileSource = arrow.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player shooter = (Player)projectileSource;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player target = (Player)entity2;
        if (!arrow.hasMetadata("crossbow_ultimate_arrow")) {
            return;
        }
        double arrowBaseDamage = 9.0;
        double targetMaxHealth = target.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        event.setDamage(arrowBaseDamage);
        if (target.isBlocking()) {
            target.setCooldown(Material.SHIELD, 100);
        }
        target.getWorld().spawnParticle(Particle.CRIT, target.getLocation().add(0.0, 1.0, 0.0), 60, 0.5, 1.0, 0.5, 0.3);
        target.getWorld().spawnParticle(Particle.FLAME, target.getLocation().add(0.0, 1.0, 0.0), 40, 0.4, 0.8, 0.4, 0.1);
        target.getWorld().spawnParticle(Particle.ENCHANT, target.getLocation().add(0.0, 1.0, 0.0), 30, 0.3, 0.8, 0.3, 0.1);
        shooter.playSound(shooter.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 0.5f);
        target.playSound(target.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 0.5f);
        target.playSound(target.getLocation(), Sound.ITEM_SHIELD_BREAK, 1.0f, 1.0f);
        arrow.remove();
        this.startCooldown(shooter);
    }

    private void deactivateUltimate(Player player) {
        UUID uuid = player.getUniqueId();
        this.ultimateActive.put(uuid, false);
        this.shotCount.remove(uuid);
    }

    private void startCooldown(final Player player) {
        final UUID uuid = player.getUniqueId();
        this.ultimateCooldown.put(uuid, System.currentTimeMillis() + 60000L);
        player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#000066:#0000cc>\u1d0f\u0274 \u1d04\u1d0f\u1d0f\u029f\u1d05\u1d0f\u1d21\u0274</gradient></bold>"));
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.5f, 1.0f);
        BukkitRunnable cooldownTask = new BukkitRunnable(this){
            final /* synthetic */ CrossbowUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#004d00:#00b300>\u1d04\u1d0f\u1d0f\u029f\u1d05\u1d0f\u1d21\u0274 \u1d0f\u1d20\u1d07\u0280</gradient></bold>"));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.this$0.cooldownTasks.remove(uuid);
            }
        };
        cooldownTask.runTaskLater((Plugin)this.plugin, 1200L);
        this.cooldownTasks.put(uuid, cooldownTask);
    }

    public boolean isOnCooldown(Player player) {
        Long cooldownEnd = this.ultimateCooldown.get(player.getUniqueId());
        return cooldownEnd != null && System.currentTimeMillis() < cooldownEnd;
    }
}

