/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.pipewasxd.strengthsmp.StrengthManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import me.pipewasxd.strengthsmp.WeaponManager;
import me.pipewasxd.strengthsmp.WeaponType;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ShieldUltimate
implements Listener {
    private final StrengthSMP plugin;
    private final WeaponManager weaponManager;
    private final StrengthManager strengthManager;
    private final Map<UUID, Boolean> ultimateActive = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> ultimateCooldown = new HashMap<UUID, Long>();
    private final Map<UUID, BukkitRunnable> cooldownTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, BukkitRunnable> particleTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, Long> passiveActiveUntil = new HashMap<UUID, Long>();
    private final Map<UUID, Long> lastShieldDisable = new HashMap<UUID, Long>();

    public ShieldUltimate(StrengthSMP plugin, WeaponManager weaponManager, StrengthManager strengthManager) {
        this.plugin = plugin;
        this.weaponManager = weaponManager;
        this.strengthManager = strengthManager;
    }

    public boolean onAbilityCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (this.weaponManager.getPlayerWeapon(player) != WeaponType.SHIELD) {
            return true;
        }
        if (!this.strengthManager.isAtMaxStrength(player)) {
            return true;
        }
        UUID uuid = player.getUniqueId();
        if (this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            return true;
        }
        if (this.isOnCooldown(player)) {
            return true;
        }
        this.activateUltimate(player);
        return true;
    }

    @EventHandler
    public void onShieldDisable(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (this.weaponManager.getPlayerWeapon(victim) != WeaponType.SHIELD) {
            return;
        }
        if (!this.strengthManager.isAtMaxStrength(victim)) {
            return;
        }
        if (victim.getInventory().getItemInMainHand().getType() != Material.SHIELD && victim.getInventory().getItemInOffHand().getType() != Material.SHIELD) {
            return;
        }
        if (victim.hasCooldown(Material.SHIELD)) {
            UUID uuid = victim.getUniqueId();
            Long lastDisable = this.lastShieldDisable.get(uuid);
            long currentTime = System.currentTimeMillis();
            if (lastDisable == null || currentTime - lastDisable > 1000L) {
                this.lastShieldDisable.put(uuid, currentTime);
                this.activatePassive(victim);
            }
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        UUID uuid = player.getUniqueId();
        if (this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            event.setCancelled(true);
            return;
        }
        Long passiveEnd = this.passiveActiveUntil.get(uuid);
        if (passiveEnd != null && System.currentTimeMillis() < passiveEnd) {
            event.setDamage(event.getDamage() * 0.75);
        }
    }

    private void activatePassive(final Player player) {
        UUID uuid = player.getUniqueId();
        final long endTime = System.currentTimeMillis() + 5000L;
        this.passiveActiveUntil.put(uuid, endTime);
        player.playSound(player.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.5f);
        BukkitRunnable passiveParticles = new BukkitRunnable(this){

            public void run() {
                if (System.currentTimeMillis() >= endTime || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                player.getWorld().spawnParticle(Particle.ENCHANT, player.getLocation().add(0.0, 1.0, 0.0), 5, 0.3, 0.5, 0.3, 0.1);
            }
        };
        passiveParticles.runTaskTimer((Plugin)this.plugin, 0L, 10L);
    }

    @EventHandler
    public void onSwapHands(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        if (this.weaponManager.getPlayerWeapon(player) != WeaponType.SHIELD) {
            return;
        }
        if (!this.strengthManager.isAtMaxStrength(player)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        event.setCancelled(true);
        if (this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            return;
        }
        if (this.isOnCooldown(player)) {
            return;
        }
        this.activateUltimate(player);
    }

    private void activateUltimate(final Player player) {
        final UUID uuid = player.getUniqueId();
        this.ultimateActive.put(uuid, true);
        player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#8B0000:#B22222>\u1d1c\u029f\u1d1b\u026a\u1d0d\u1d00\u1d1b\u1d07 \u1d00\u1d04\u1d1b\u026a\u1d20\u1d00\u1d1b\u1d07\u1d05</gradient></bold>"));
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.2f);
        BukkitRunnable particleTask = new BukkitRunnable(this){
            final /* synthetic */ ShieldUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!this.this$0.ultimateActive.getOrDefault(uuid, false).booleanValue() || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                this.this$0.spawnHitboxOutline(player);
            }
        };
        particleTask.runTaskTimer((Plugin)this.plugin, 0L, 2L);
        this.particleTasks.put(uuid, particleTask);
        new BukkitRunnable(this){
            final /* synthetic */ ShieldUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.deactivateUltimate(player);
            }
        }.runTaskLater((Plugin)this.plugin, 300L);
    }

    private void spawnHitboxOutline(Player player) {
        World world = player.getWorld();
        Location center = player.getLocation();
        double centerX = center.getX();
        double centerY = center.getY();
        double centerZ = center.getZ();
        double minX = centerX - 0.4;
        double maxX = centerX + 0.4;
        double minY = centerY;
        double maxY = centerY + 1.8;
        double minZ = centerZ - 0.4;
        double maxZ = centerZ + 0.4;
        double step = 0.15;
        this.drawLine(world, minX, minY, minZ, maxX, minY, minZ, step, true);
        this.drawLine(world, maxX, minY, minZ, maxX, minY, maxZ, step, false);
        this.drawLine(world, maxX, minY, maxZ, minX, minY, maxZ, step, true);
        this.drawLine(world, minX, minY, maxZ, minX, minY, minZ, step, false);
        this.drawLine(world, minX, maxY, minZ, maxX, maxY, minZ, step, true);
        this.drawLine(world, maxX, maxY, minZ, maxX, maxY, maxZ, step, false);
        this.drawLine(world, maxX, maxY, maxZ, minX, maxY, maxZ, step, true);
        this.drawLine(world, minX, maxY, maxZ, minX, maxY, minZ, step, false);
        this.drawLine(world, minX, minY, minZ, minX, maxY, minZ, step, true);
        this.drawLine(world, maxX, minY, minZ, maxX, maxY, minZ, step, false);
        this.drawLine(world, maxX, minY, maxZ, maxX, maxY, maxZ, step, true);
        this.drawLine(world, minX, minY, maxZ, minX, maxY, maxZ, step, false);
        for (double y = 0.0; y <= 1.8; y += 0.25) {
            Location loc = center.clone().add(0.0, y, 0.0);
            world.spawnParticle(Particle.SOUL, loc, 1, 0.0, 0.0, 0.0, 0.0);
            world.spawnParticle(Particle.ENCHANT, loc, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void drawLine(World world, double x1, double y1, double z1, double x2, double y2, double z2, double step, boolean isBlue) {
        double distance = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
        double dx = (x2 - x1) / distance;
        double dy = (y2 - y1) / distance;
        double dz = (z2 - z1) / distance;
        Particle.DustOptions dustOptions = new Particle.DustOptions(isBlue ? Color.fromRGB((int)0, (int)100, (int)255) : Color.fromRGB((int)0, (int)0, (int)0), 1.5f);
        for (double d = 0.0; d <= distance; d += step) {
            Location loc = new Location(world, x1 + dx * d, y1 + dy * d, z1 + dz * d);
            world.spawnParticle(Particle.DUST, loc, 0, 0.0, 0.0, 0.0, 1.0, (Object)dustOptions);
            world.spawnParticle(Particle.SOUL, loc, 1, 0.0, 0.0, 0.0, 0.0);
            world.spawnParticle(Particle.ENCHANT, loc, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void deactivateUltimate(final Player player) {
        final UUID uuid = player.getUniqueId();
        if (!this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            return;
        }
        BukkitRunnable particleTask = this.particleTasks.remove(uuid);
        if (particleTask != null) {
            particleTask.cancel();
        }
        this.ultimateActive.put(uuid, false);
        this.ultimateCooldown.put(uuid, System.currentTimeMillis() + 120000L);
        player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#A9A9A9:#D3D3D3>\u1d0f\u0274 \u1d04\u1d0f\u1d0f\u029f\u1d05\u1d0f\u1d21\u0274</gradient></bold>"));
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.5f, 1.0f);
        BukkitRunnable cooldownTask = new BukkitRunnable(this){
            final /* synthetic */ ShieldUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#006400:#008000>\u1d1c\u029f\u1d1b\u026a\u1d0d\u1d00\u1d1b\u1d07 \u0280\u1d07\u1d00\u1d05\u028f</gradient></bold>"));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.this$0.cooldownTasks.remove(uuid);
            }
        };
        cooldownTask.runTaskLater((Plugin)this.plugin, 2400L);
        this.cooldownTasks.put(uuid, cooldownTask);
    }

    private boolean isOnCooldown(Player player) {
        Long cooldownEnd = this.ultimateCooldown.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return false;
        }
        return System.currentTimeMillis() < cooldownEnd;
    }
}

